/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.util.Map;
import org.yaml.snakeyaml.error.YAMLException;

public class DumperOptions {
    private ScalarStyle defaultStyle = ScalarStyle.PLAIN;
    private FlowStyle defaultFlowStyle = FlowStyle.AUTO;
    private boolean canonical = false;
    private boolean allowUnicode = true;
    private int indent = 2;
    private int bestWidth = 80;
    private LineBreak lineBreak = LineBreak.UNIX;
    private boolean explicitStart = false;
    private boolean explicitEnd = false;
    private String explicitRoot = null;
    private Version version = null;
    private Map<String, String> tags = null;

    public boolean isAllowUnicode() {
        return this.allowUnicode;
    }

    public void setAllowUnicode(boolean bl) {
        this.allowUnicode = bl;
    }

    public ScalarStyle getDefaultScalarStyle() {
        return this.defaultStyle;
    }

    public void setDefaultScalarStyle(ScalarStyle scalarStyle) {
        if (scalarStyle == null) {
            throw new NullPointerException("Use ScalarStyle enum.");
        }
        this.defaultStyle = scalarStyle;
    }

    public void setIndent(int n) {
        if (n < 1) {
            throw new YAMLException("Indent must be at least 1");
        }
        if (n > 10) {
            throw new YAMLException("Indent must be at most 10");
        }
        this.indent = n;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setCanonical(boolean bl) {
        this.canonical = bl;
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    public void setWidth(int n) {
        this.bestWidth = n;
    }

    public int getWidth() {
        return this.bestWidth;
    }

    public LineBreak getLineBreak() {
        return this.lineBreak;
    }

    public void setDefaultFlowStyle(FlowStyle flowStyle) {
        if (flowStyle == null) {
            throw new NullPointerException("Use FlowStyle enum.");
        }
        this.defaultFlowStyle = flowStyle;
    }

    public FlowStyle getDefaultFlowStyle() {
        return this.defaultFlowStyle;
    }

    public String getExplicitRoot() {
        return this.explicitRoot;
    }

    public void setExplicitRoot(String string) {
        if (string == null) {
            throw new NullPointerException("Root tag must be specified.");
        }
        this.explicitRoot = string;
    }

    public void setLineBreak(LineBreak lineBreak) {
        if (lineBreak == null) {
            throw new NullPointerException("Specify line break.");
        }
        this.lineBreak = lineBreak;
    }

    public boolean isExplicitStart() {
        return this.explicitStart;
    }

    public void setExplicitStart(boolean bl) {
        this.explicitStart = bl;
    }

    public boolean isExplicitEnd() {
        return this.explicitEnd;
    }

    public void setExplicitEnd(boolean bl) {
        this.explicitEnd = bl;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> map) {
        this.tags = map;
    }

    public static enum Version {
        V1_0(new Integer[]{1, 0}),
        V1_1(new Integer[]{1, 1});

        private Integer[] version;

        private Version(Integer[] integerArray) {
            this.version = integerArray;
        }

        public Integer[] getArray() {
            return this.version;
        }

        public String toString() {
            return "Version: " + this.version[0] + "." + this.version[1];
        }
    }

    public static enum LineBreak {
        WIN("\r\n"),
        MAC("\r"),
        UNIX("\n");

        private String lineBreak;

        private LineBreak(String string2) {
            this.lineBreak = string2;
        }

        public String getString() {
            return this.lineBreak;
        }

        public String toString() {
            return "Line break: " + this.name();
        }

        public static LineBreak getPlatformLineBreak() {
            String string = System.getProperty("line.separator");
            for (LineBreak lineBreak : LineBreak.values()) {
                if (!lineBreak.lineBreak.equals(string)) continue;
                return lineBreak;
            }
            return UNIX;
        }
    }

    public static enum FlowStyle {
        FLOW(Boolean.TRUE),
        BLOCK(Boolean.FALSE),
        AUTO(null);

        private Boolean styleBoolean;

        private FlowStyle(Boolean bl) {
            this.styleBoolean = bl;
        }

        public Boolean getStyleBoolean() {
            return this.styleBoolean;
        }

        public String toString() {
            return "Flow style: '" + this.styleBoolean + "'";
        }
    }

    public static enum ScalarStyle {
        DOUBLE_QUOTED(new Character('\"')),
        SINGLE_QUOTED(new Character('\'')),
        LITERAL(new Character('|')),
        FOLDED(new Character('>')),
        PLAIN(null);

        private Character styleChar;

        private ScalarStyle(Character c) {
            this.styleChar = c;
        }

        public Character getChar() {
            return this.styleChar;
        }

        public String toString() {
            return "Scalar style: '" + this.styleChar + "'";
        }
    }
}

