/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.Tuple;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.util.ArrayStack;

public abstract class BaseConstructor {
    protected final Map<NodeId, Construct> yamlClassConstructors = new EnumMap<NodeId, Construct>(NodeId.class);
    protected final Map<String, Construct> yamlConstructors = new HashMap<String, Construct>();
    private Composer composer;
    private final Map<Node, Object> constructedObjects = new HashMap<Node, Object>();
    private final Set<Node> recursiveObjects = new HashSet<Node>();
    private final ArrayStack<Tuple<Node, Object>> toBeConstructedAt2ndStep = new ArrayStack(10);
    private final ArrayList<Tuple<Map<Object, Object>, Tuple<Object, Object>>> maps2fill = new ArrayList();
    private final ArrayList<Tuple<Set<Object>, Object>> sets2fill = new ArrayList();
    protected String rootTag = null;

    public void setComposer(Composer composer) {
        this.composer = composer;
    }

    public boolean checkData() {
        return this.composer.checkNode();
    }

    public Object getData() {
        this.composer.checkNode();
        Node node = this.composer.getNode();
        if (this.rootTag != null) {
            node.setTag(this.rootTag);
        }
        return this.constructDocument(node);
    }

    public Object getSingleData() {
        Node node = this.composer.getSingleNode();
        if (node != null) {
            if (this.rootTag != null) {
                node.setTag(this.rootTag);
            }
            return this.constructDocument(node);
        }
        return null;
    }

    private Object constructDocument(Node node) {
        Object object = this.constructObject(node);
        while (!this.toBeConstructedAt2ndStep.isEmpty()) {
            Iterator<Tuple<Set<Object>, Object>> iterator = this.toBeConstructedAt2ndStep.pop();
            this.callPostCreate((Node)((Tuple)((Object)iterator))._1(), ((Tuple)((Object)iterator))._2());
        }
        if (!this.maps2fill.isEmpty()) {
            for (Tuple<Set<Object>, Object> tuple : this.maps2fill) {
                Tuple tuple2 = (Tuple)tuple._2();
                ((Map)((Object)tuple._1())).put(tuple2._1(), tuple2._2());
            }
            this.maps2fill.clear();
        }
        if (!this.sets2fill.isEmpty()) {
            for (Tuple<Set<Object>, Object> tuple : this.sets2fill) {
                tuple._1().add(tuple._2());
            }
            this.sets2fill.clear();
        }
        this.constructedObjects.clear();
        this.recursiveObjects.clear();
        this.toBeConstructedAt2ndStep.clear();
        return object;
    }

    protected Object constructObject(Node node) {
        if (this.constructedObjects.containsKey(node)) {
            return this.constructedObjects.get(node);
        }
        if (this.recursiveObjects.contains(node)) {
            throw new ConstructorException(null, null, "found unconstructable recursive node", node.getStartMark());
        }
        this.recursiveObjects.add(node);
        Object object = this.callConstructor(node);
        if (node.isTwoStepsConstruction()) {
            this.toBeConstructedAt2ndStep.push(new Tuple<Node, Object>(node, object));
        }
        this.constructedObjects.put(node, object);
        this.recursiveObjects.remove(node);
        return object;
    }

    protected Object callConstructor(Node node) {
        return this.getConstructor(node).construct(node);
    }

    protected void callPostCreate(Node node, Object object) {
        this.getConstructor(node).construct2ndStep(node, object);
    }

    private Construct getConstructor(Node node) {
        if (node.useClassConstructor()) {
            return this.yamlClassConstructors.get((Object)node.getNodeId());
        }
        Construct construct = this.yamlConstructors.get(node.getTag());
        if (construct == null) {
            return this.yamlConstructors.get(null);
        }
        return construct;
    }

    protected Object constructScalar(ScalarNode scalarNode) {
        return scalarNode.getValue();
    }

    protected List<Object> createDefaultList(int n) {
        return new ArrayList<Object>(n);
    }

    protected List<? extends Object> constructSequence(SequenceNode sequenceNode) {
        List list;
        if (List.class.isAssignableFrom(sequenceNode.getType()) && !sequenceNode.getType().isInterface()) {
            try {
                list = (List)sequenceNode.getType().newInstance();
            }
            catch (Exception exception) {
                throw new YAMLException(exception);
            }
        } else {
            list = this.createDefaultList(sequenceNode.getValue().size());
        }
        this.constructSequenceStep2(sequenceNode, list);
        return list;
    }

    protected void constructSequenceStep2(SequenceNode sequenceNode, List<Object> list) {
        for (Node node : sequenceNode.getValue()) {
            list.add(this.constructObject(node));
        }
    }

    protected Map<Object, Object> createDefaultMap() {
        return new LinkedHashMap<Object, Object>();
    }

    protected Set<Object> createDefaultSet() {
        return new LinkedHashSet<Object>();
    }

    protected Set<Object> constructSet(MappingNode mappingNode) {
        Set<Object> set = this.createDefaultSet();
        this.constructSet2ndStep(mappingNode, set);
        return set;
    }

    protected Map<Object, Object> constructMapping(MappingNode mappingNode) {
        Map<Object, Object> map = this.createDefaultMap();
        this.constructMapping2ndStep(mappingNode, map);
        return map;
    }

    protected void constructMapping2ndStep(MappingNode mappingNode, Map<Object, Object> map) {
        List<NodeTuple> list = mappingNode.getValue();
        for (NodeTuple nodeTuple : list) {
            Node node = nodeTuple.getKeyNode();
            Node node2 = nodeTuple.getValueNode();
            Object object = this.constructObject(node);
            if (object != null) {
                try {
                    object.hashCode();
                }
                catch (Exception exception) {
                    throw new ConstructorException("while constructing a mapping", mappingNode.getStartMark(), "found unacceptable key " + object, nodeTuple.getKeyNode().getStartMark(), exception);
                }
            }
            Object object2 = this.constructObject(node2);
            if (node.isTwoStepsConstruction()) {
                this.maps2fill.add(0, new Tuple<Map<Object, Object>, Tuple<Object, Object>>(map, new Tuple<Object, Object>(object, object2)));
                continue;
            }
            map.put(object, object2);
        }
    }

    protected void constructSet2ndStep(MappingNode mappingNode, Set<Object> set) {
        List<NodeTuple> list = mappingNode.getValue();
        for (NodeTuple nodeTuple : list) {
            Node node = nodeTuple.getKeyNode();
            Object object = this.constructObject(node);
            if (object != null) {
                try {
                    object.hashCode();
                }
                catch (Exception exception) {
                    throw new ConstructorException("while constructing a Set", mappingNode.getStartMark(), "found unacceptable key " + object, nodeTuple.getKeyNode().getStartMark(), exception);
                }
            }
            if (node.isTwoStepsConstruction()) {
                this.sets2fill.add(0, new Tuple<Set<Object>, Object>(set, object));
                continue;
            }
            set.add(object);
        }
    }
}

