/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.util.Base64Coder;

public class SafeConstructor
extends BaseConstructor {
    public static ConstructUndefined undefinedConstructor = new ConstructUndefined();
    private static final Map<String, Boolean> BOOL_VALUES = new HashMap<String, Boolean>();
    private static final Pattern TIMESTAMP_REGEXP;
    private static final Pattern YMD_REGEXP;

    public SafeConstructor() {
        this.yamlConstructors.put("tag:yaml.org,2002:null", new ConstructYamlNull());
        this.yamlConstructors.put("tag:yaml.org,2002:bool", new ConstructYamlBool());
        this.yamlConstructors.put("tag:yaml.org,2002:int", new ConstructYamlInt());
        this.yamlConstructors.put("tag:yaml.org,2002:float", new ConstructYamlFloat());
        this.yamlConstructors.put("tag:yaml.org,2002:binary", new ConstructYamlBinary());
        this.yamlConstructors.put("tag:yaml.org,2002:timestamp", new ConstructYamlTimestamp());
        this.yamlConstructors.put("tag:yaml.org,2002:omap", new ConstructYamlOmap());
        this.yamlConstructors.put("tag:yaml.org,2002:pairs", new ConstructYamlPairs());
        this.yamlConstructors.put("tag:yaml.org,2002:set", new ConstructYamlSet());
        this.yamlConstructors.put("tag:yaml.org,2002:str", new ConstructYamlStr());
        this.yamlConstructors.put("tag:yaml.org,2002:seq", new ConstructYamlSeq());
        this.yamlConstructors.put("tag:yaml.org,2002:map", new ConstructYamlMap());
        this.yamlConstructors.put(null, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.scalar, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.sequence, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.mapping, undefinedConstructor);
    }

    private void flattenMapping(MappingNode mappingNode) {
        ArrayList<NodeTuple> arrayList = new ArrayList<NodeTuple>();
        int n = 0;
        List<NodeTuple> list = mappingNode.getValue();
        block4: while (n < list.size()) {
            Node node = list.get(n).getKeyNode();
            Node node2 = list.get(n).getValueNode();
            if (node.getTag().equals("tag:yaml.org,2002:merge")) {
                list.remove(n);
                switch (node2.getNodeId()) {
                    case mapping: {
                        MappingNode mappingNode2 = (MappingNode)node2;
                        this.flattenMapping(mappingNode2);
                        arrayList.addAll(mappingNode2.getValue());
                        break;
                    }
                    case sequence: {
                        ArrayList<List<NodeTuple>> arrayList2 = new ArrayList<List<NodeTuple>>();
                        SequenceNode sequenceNode = (SequenceNode)node2;
                        List<Node> list2 = sequenceNode.getValue();
                        for (Node node3 : list2) {
                            if (!(node3 instanceof MappingNode)) {
                                throw new ConstructorException("while constructing a mapping", mappingNode.getStartMark(), "expected a mapping for merging, but found " + (Object)((Object)node3.getNodeId()), node3.getStartMark());
                            }
                            MappingNode mappingNode2 = (MappingNode)node3;
                            this.flattenMapping(mappingNode2);
                            arrayList2.add(mappingNode2.getValue());
                        }
                        Collections.reverse(arrayList2);
                        for (List list3 : arrayList2) {
                            arrayList.addAll(list3);
                        }
                        continue block4;
                    }
                    default: {
                        throw new ConstructorException("while constructing a mapping", mappingNode.getStartMark(), "expected a mapping or list of mappings for merging, but found " + (Object)((Object)node2.getNodeId()), node2.getStartMark());
                    }
                }
                continue;
            }
            if (node.getTag().equals("tag:yaml.org,2002:value")) {
                node.setTag("tag:yaml.org,2002:str");
                ++n;
                continue;
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            arrayList.addAll(list);
            mappingNode.setValue(arrayList);
        }
    }

    @Override
    protected void constructMapping2ndStep(MappingNode mappingNode, Map<Object, Object> map) {
        this.flattenMapping(mappingNode);
        super.constructMapping2ndStep(mappingNode, map);
    }

    @Override
    protected void constructSet2ndStep(MappingNode mappingNode, Set<Object> set) {
        this.flattenMapping(mappingNode);
        super.constructSet2ndStep(mappingNode, set);
    }

    private Number createNumber(int n, String string, int n2) {
        Number number;
        if (n < 0) {
            string = "-" + string;
        }
        try {
            int n3 = Integer.parseInt(string, n2);
            number = new Integer(n3);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                long l = Long.parseLong(string, n2);
                number = new Long(l);
            }
            catch (NumberFormatException numberFormatException2) {
                number = new BigInteger(string, n2);
            }
        }
        return number;
    }

    static {
        BOOL_VALUES.put("yes", Boolean.TRUE);
        BOOL_VALUES.put("no", Boolean.FALSE);
        BOOL_VALUES.put("true", Boolean.TRUE);
        BOOL_VALUES.put("false", Boolean.FALSE);
        BOOL_VALUES.put("on", Boolean.TRUE);
        BOOL_VALUES.put("off", Boolean.FALSE);
        TIMESTAMP_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(?:Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$");
        YMD_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");
    }

    private static final class ConstructUndefined
    extends AbstractConstruct {
        private ConstructUndefined() {
        }

        @Override
        public Object construct(Node node) {
            throw new ConstructorException(null, null, "could not determine a constructor for the tag " + node.getTag(), node.getStartMark());
        }
    }

    private class ConstructYamlMap
    implements Construct {
        private ConstructYamlMap() {
        }

        @Override
        public Object construct(Node node) {
            if (node.isTwoStepsConstruction()) {
                return SafeConstructor.this.createDefaultMap();
            }
            return SafeConstructor.this.constructMapping((MappingNode)node);
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            if (!node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected recursive mapping structure. Node: " + node);
            }
            SafeConstructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
        }
    }

    private class ConstructYamlSeq
    implements Construct {
        private ConstructYamlSeq() {
        }

        @Override
        public Object construct(Node node) {
            SequenceNode sequenceNode = (SequenceNode)node;
            if (node.isTwoStepsConstruction()) {
                return SafeConstructor.this.createDefaultList(sequenceNode.getValue().size());
            }
            return SafeConstructor.this.constructSequence(sequenceNode);
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            if (!node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected recursive sequence structure. Node: " + node);
            }
            SafeConstructor.this.constructSequenceStep2((SequenceNode)node, (List)object);
        }
    }

    private class ConstructYamlStr
    extends AbstractConstruct {
        private ConstructYamlStr() {
        }

        @Override
        public Object construct(Node node) {
            return (String)SafeConstructor.this.constructScalar((ScalarNode)node);
        }
    }

    private class ConstructYamlSet
    implements Construct {
        private ConstructYamlSet() {
        }

        @Override
        public Object construct(Node node) {
            if (node.isTwoStepsConstruction()) {
                return SafeConstructor.this.createDefaultSet();
            }
            return SafeConstructor.this.constructSet((MappingNode)node);
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            if (!node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected recursive set structure. Node: " + node);
            }
            SafeConstructor.this.constructSet2ndStep((MappingNode)node, (Set)object);
        }
    }

    private class ConstructYamlPairs
    extends AbstractConstruct {
        private ConstructYamlPairs() {
        }

        @Override
        public Object construct(Node node) {
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a sequence, but found " + (Object)((Object)node.getNodeId()), node.getStartMark());
            }
            SequenceNode sequenceNode = (SequenceNode)node;
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(sequenceNode.getValue().size());
            for (Node node2 : sequenceNode.getValue()) {
                if (!(node2 instanceof MappingNode)) {
                    throw new ConstructorException("while constructingpairs", node.getStartMark(), "expected a mapping of length 1, but found " + (Object)((Object)node2.getNodeId()), node2.getStartMark());
                }
                MappingNode mappingNode = (MappingNode)node2;
                if (mappingNode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a single mapping item, but found " + mappingNode.getValue().size() + " items", mappingNode.getStartMark());
                }
                Node node3 = mappingNode.getValue().get(0).getKeyNode();
                Node node4 = mappingNode.getValue().get(0).getValueNode();
                Object object = SafeConstructor.this.constructObject(node3);
                Object object2 = SafeConstructor.this.constructObject(node4);
                arrayList.add(new Object[]{object, object2});
            }
            return arrayList;
        }
    }

    private class ConstructYamlOmap
    extends AbstractConstruct {
        private ConstructYamlOmap() {
        }

        @Override
        public Object construct(Node node) {
            LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a sequence, but found " + (Object)((Object)node.getNodeId()), node.getStartMark());
            }
            SequenceNode sequenceNode = (SequenceNode)node;
            for (Node node2 : sequenceNode.getValue()) {
                if (!(node2 instanceof MappingNode)) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a mapping of length 1, but found " + (Object)((Object)node2.getNodeId()), node2.getStartMark());
                }
                MappingNode mappingNode = (MappingNode)node2;
                if (mappingNode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a single mapping item, but found " + mappingNode.getValue().size() + " items", mappingNode.getStartMark());
                }
                Node node3 = mappingNode.getValue().get(0).getKeyNode();
                Node node4 = mappingNode.getValue().get(0).getValueNode();
                Object object = SafeConstructor.this.constructObject(node3);
                Object object2 = SafeConstructor.this.constructObject(node4);
                linkedHashMap.put(object, object2);
            }
            return linkedHashMap;
        }
    }

    private class ConstructYamlTimestamp
    extends AbstractConstruct {
        private ConstructYamlTimestamp() {
        }

        @Override
        public Object construct(Node node) {
            ScalarNode scalarNode = (ScalarNode)node;
            String string = scalarNode.getValue();
            Matcher matcher = YMD_REGEXP.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                String string4 = matcher.group(3);
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                calendar.clear();
                calendar.set(1, Integer.parseInt(string2));
                calendar.set(2, Integer.parseInt(string3) - 1);
                calendar.set(5, Integer.parseInt(string4));
                return calendar.getTime();
            }
            matcher = TIMESTAMP_REGEXP.matcher(string);
            if (!matcher.matches()) {
                throw new YAMLException("Unexpected timestamp: " + string);
            }
            String string5 = matcher.group(1);
            String string6 = matcher.group(2);
            String string7 = matcher.group(3);
            String string8 = matcher.group(4);
            String string9 = matcher.group(5);
            String string10 = matcher.group(6);
            String string11 = matcher.group(7);
            String string12 = matcher.group(8);
            String string13 = matcher.group(9);
            int n = 0;
            if (string11 != null && (n = Integer.parseInt(string11)) != 0) {
                while (10 * n < 1000) {
                    n *= 10;
                }
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Integer.parseInt(string5));
            calendar.set(2, Integer.parseInt(string6) - 1);
            calendar.set(5, Integer.parseInt(string7));
            calendar.set(11, Integer.parseInt(string8));
            calendar.set(12, Integer.parseInt(string9));
            calendar.set(13, Integer.parseInt(string10));
            calendar.set(14, n);
            if (string12 != null) {
                int n2 = 0;
                int n3 = 1;
                if (string12.startsWith("-")) {
                    n3 = -1;
                }
                n2 += Integer.parseInt(string12.substring(1)) * 3600000;
                if (string13 != null) {
                    n2 += Integer.parseInt(string13) * 60000;
                }
                calendar.set(15, n3 * n2);
            } else {
                calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            return calendar.getTime();
        }
    }

    private class ConstructYamlBinary
    extends AbstractConstruct {
        private ConstructYamlBinary() {
        }

        @Override
        public Object construct(Node node) {
            byte[] byArray = Base64Coder.decode(SafeConstructor.this.constructScalar((ScalarNode)node).toString().toCharArray());
            return byArray;
        }
    }

    private class ConstructYamlFloat
    extends AbstractConstruct {
        private ConstructYamlFloat() {
        }

        @Override
        public Object construct(Node node) {
            String string = SafeConstructor.this.constructScalar((ScalarNode)node).toString().replaceAll("_", "");
            int n = 1;
            char c = string.charAt(0);
            if (c == '-') {
                n = -1;
                string = string.substring(1);
            } else if (c == '+') {
                string = string.substring(1);
            }
            String string2 = string.toLowerCase();
            if (".inf".equals(string2)) {
                return new Double(n == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            if (".nan".equals(string2)) {
                return new Double(Double.NaN);
            }
            if (string.indexOf(58) != -1) {
                String[] stringArray = string.split(":");
                int n2 = 1;
                double d = 0.0;
                int n3 = stringArray.length;
                for (int i = 0; i < n3; ++i) {
                    d += Double.parseDouble(stringArray[n3 - i - 1]) * (double)n2;
                    n2 *= 60;
                }
                return new Double((double)n * d);
            }
            Double d = Double.valueOf(string);
            return new Double(d * (double)n);
        }
    }

    private class ConstructYamlInt
    extends AbstractConstruct {
        private ConstructYamlInt() {
        }

        @Override
        public Object construct(Node node) {
            String string = SafeConstructor.this.constructScalar((ScalarNode)node).toString().replaceAll("_", "");
            int n = 1;
            char c = string.charAt(0);
            if (c == '-') {
                n = -1;
                string = string.substring(1);
            } else if (c == '+') {
                string = string.substring(1);
            }
            int n2 = 10;
            if ("0".equals(string)) {
                return new Integer(0);
            }
            if (string.startsWith("0b")) {
                string = string.substring(2);
                n2 = 2;
            } else if (string.startsWith("0x")) {
                string = string.substring(2);
                n2 = 16;
            } else if (string.startsWith("0")) {
                string = string.substring(1);
                n2 = 8;
            } else {
                if (string.indexOf(58) != -1) {
                    String[] stringArray = string.split(":");
                    int n3 = 1;
                    int n4 = 0;
                    int n5 = stringArray.length;
                    for (int i = 0; i < n5; ++i) {
                        n4 = (int)((long)n4 + Long.parseLong(stringArray[n5 - i - 1]) * (long)n3);
                        n3 *= 60;
                    }
                    return SafeConstructor.this.createNumber(n, String.valueOf(n4), 10);
                }
                return SafeConstructor.this.createNumber(n, string, 10);
            }
            return SafeConstructor.this.createNumber(n, string, n2);
        }
    }

    private class ConstructYamlBool
    extends AbstractConstruct {
        private ConstructYamlBool() {
        }

        @Override
        public Object construct(Node node) {
            String string = (String)SafeConstructor.this.constructScalar((ScalarNode)node);
            return BOOL_VALUES.get(string.toLowerCase());
        }
    }

    private class ConstructYamlNull
    extends AbstractConstruct {
        private ConstructYamlNull() {
        }

        @Override
        public Object construct(Node node) {
            SafeConstructor.this.constructScalar((ScalarNode)node);
            return null;
        }
    }
}

