/*
 * See LICENSE file in distribution for copyright and licensing information.
 */
package org.yaml.snakeyaml.resolver;
//Source for Ragel 6.3

/**
 * Generated by Ragel 6.3 (http://www.complang.org/ragel/)
 * @see http://www.complang.org/ragel/
 */
public class RagelMachine {
    %%{
        machine snakeyaml;
        action bool_tag { tag = "tag:yaml.org,2002:bool"; }
        action merge_tag { tag = "tag:yaml.org,2002:merge"; }
        action null_tag { tag = "tag:yaml.org,2002:null"; }
        action value_tag { tag = "tag:yaml.org,2002:value"; }
        action int_tag { tag = "tag:yaml.org,2002:int"; }
        action float_tag { tag = "tag:yaml.org,2002:float"; }
        action timestamp_tag { tag = "tag:yaml.org,2002:timestamp"; }
        
        Bool = ("yes" | "Yes" | "YES" | "no" | "No" | "NO" | 
                "true" | "True" | "TRUE" | "false" | "False" | "FALSE" | 
                "on" | "On" | "ON" | "off" | "Off" | "OFF") %/bool_tag;
        Merge = "<<" %/merge_tag;
        Value = "=" %/value_tag;
        Null  = ("~" | "null" | "Null" | "NULL" | " ") %/null_tag;
        
        sign = "-" | "+";
        digit2 = digit | "_";
        binaryInt = "0b" [0-1_]+;
        octalInt = "0" [0-7_]+;
        decimalInt = "0" | [1-9]digit2* (":" [0-5]? digit)*;
        hexaInt = "0x" [0-9a-fA-F_]+;
        Int = sign? (binaryInt | octalInt | decimalInt | hexaInt) %/int_tag;
        
        exp = [eE] sign digit+;
        Float = ((sign? ((digit+ digit2* "." digit2* exp?)
        			 | ((digit+ digit2*)? "." digit+ digit2* exp?)
                     | (digit+ (":" [0-5]? digit)+ "." digit*)
                     | "." ("inf" | "Inf" | "INF"))) 
                 | ("." ("nan" | "NaN" | "NAN"))) %/float_tag;
              
        TimestampShort = digit{4} ("-" digit{2}){2} %/timestamp_tag;
        fract = "." digit*;
        zone = [ \t]* ("Z" | (sign digit{1,2} ( ":" digit{2} )?));
        Timestamp = digit{4} ("-" digit{1,2}){2} ([Tt] | [ \t]+) 
        	digit{1,2} ":" digit{2} ":" digit{2} fract? zone? %/timestamp_tag;
                 
        Scalar = Bool | Null | Int | Float | TimestampShort | Merge | Value | Timestamp;
        main := Scalar;
        write data nofinal;
    }%%
    
    public String scan(String scalar) {
        if (scalar == null) {
            throw new NullPointerException("Scalar must be provided.");
        }
        String tag = null;
        int cs = 0;
        int p = 0;
        int pe = scalar.length();
        int eof = pe;
        char[] data;
        if (pe == 0) {
            // NULL value
            data = new char[] { '~' };
            pe = 1;
            eof = 1;
        } else {
            data = scalar.toCharArray();
        }
        %%{
            # Initialize and execute.
            write init;
            write exec;
        }%%

        return tag;
    }
}