/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.Comparator;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.util.NodeComparator;

public class CloneTest
extends AbstractTestCase {
    private Comparator comparator = new NodeComparator();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.CloneTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testBug1148333() {
        DOMDocumentFactory factory = (DOMDocumentFactory)DOMDocumentFactory.getInstance();
        DOMDocument doc = (DOMDocument)factory.createDocument();
        Element el = doc.addElement("root");
        el.addNamespace("pref2", "uri2");
        DOMDocument clone = (DOMDocument)doc.cloneNode(true);
        CloneTest.assertNotSame((Object)doc, (Object)clone);
        this.assertNodesEqual(doc, clone);
    }

    public void testElementWithNamespaceClone() {
        Element element = DocumentFactory.getInstance().createElement("element");
        element.addNamespace("prefix", "uri");
        Element clone = (Element)element.clone();
        CloneTest.assertNotSame((Object)element, (Object)clone);
        this.assertNodesEqual(element, clone);
    }

    public void testDocumentClone() throws Exception {
        this.document.setName("doc1");
        Document doc2 = (Document)this.document.clone();
        CloneTest.assertNotSame((Object)this.document, (Object)doc2);
        this.assertNodesEqual(this.document, doc2);
    }

    public void testAddCloneToOtherElement() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document doc = factory.createDocument();
        Element root = doc.addElement("root");
        Element parent1 = root.addElement("parent");
        Element child1 = parent1.addElement("child");
        Element parent2 = (Element)parent1.clone();
        root.add(parent2);
        CloneTest.assertSame((String)"parent not correct", (Object)root, (Object)parent2.getParent());
        CloneTest.assertSame((String)"document not correct", (Object)doc, (Object)parent2.getDocument());
        Element child2 = parent2.element("child");
        CloneTest.assertNotSame((String)"child not cloned", (Object)child1, (Object)child2);
        CloneTest.assertSame((String)"parent not correct", (Object)parent2, (Object)child2.getParent());
        CloneTest.assertSame((String)"document not correct", (Object)doc, (Object)child2.getDocument());
    }

    public void testRootElementClone() throws Exception {
        this.testElementClone(this.document.getRootElement());
    }

    public void testAuthorElementClone() throws Exception {
        this.testElementClone((Element)this.document.selectSingleNode("//author"));
    }

    public void testRootCompare1() throws Exception {
        Document doc2 = (Document)this.document.clone();
        Element author = doc2.getRootElement();
        author.addAttribute("foo", "bar");
        CloneTest.assertTrue((String)"Documents are not equal", (this.comparator.compare(this.document, doc2) != 0 ? 1 : 0) != 0);
    }

    public void testRootCompare2() throws Exception {
        Document doc2 = (Document)this.document.clone();
        Element author = doc2.getRootElement();
        author.addText("foo");
        CloneTest.assertTrue((String)"Documents are not equal", (this.comparator.compare(this.document, doc2) != 0 ? 1 : 0) != 0);
    }

    public void testAuthorCompare1() throws Exception {
        Document doc2 = (Document)this.document.clone();
        Element author = (Element)doc2.selectSingleNode("//author");
        author.addAttribute("name", "James Strachan");
        CloneTest.assertTrue((String)"Documents are not equal", (this.comparator.compare(this.document, doc2) != 0 ? 1 : 0) != 0);
    }

    public void testAuthorCompare2() throws Exception {
        Document doc2 = (Document)this.document.clone();
        Element author = (Element)doc2.selectSingleNode("//author");
        author.addText("foo");
        CloneTest.assertTrue((String)"Documents are not equal", (this.comparator.compare(this.document, doc2) != 0 ? 1 : 0) != 0);
    }

    protected void testElementClone(Element element) throws Exception {
        Element element2 = (Element)element.clone();
        CloneTest.assertTrue((String)"Returned a new Element", (element2 != element ? 1 : 0) != 0);
        CloneTest.assertNull((String)"New element has no parent", (Object)element2.getParent());
        CloneTest.assertNull((String)"New element has no Document", (Object)element2.getDocument());
        CloneTest.assertTrue((String)"Element fragments are equal", (this.comparator.compare(element, element2) == 0 ? 1 : 0) != 0);
    }
}

