/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DetachTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.DetachTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testRoot() throws Exception {
        this.document.setName("doc1");
        Element root = this.document.getRootElement();
        DetachTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        DetachTest.assertTrue((String)"Root has no parent", (root.getParent() == null ? 1 : 0) != 0);
        root.detach();
        DetachTest.assertTrue((String)"Detached root now has no document", (root.getDocument() == null ? 1 : 0) != 0);
        DetachTest.assertTrue((String)"Original doc now has no root element", (this.document.getRootElement() == null ? 1 : 0) != 0);
        Document doc2 = DocumentHelper.createDocument();
        doc2.setName("doc2");
        DetachTest.assertTrue((String)"Doc2 has no root element", (doc2.getRootElement() == null ? 1 : 0) != 0);
        doc2.setRootElement(root);
        DetachTest.assertTrue((String)"Doc2 has now has root element", (doc2.getRootElement() == root ? 1 : 0) != 0);
        DetachTest.assertTrue((String)"Root element now has document", (root.getDocument() == doc2 ? 1 : 0) != 0);
        Document doc3 = DocumentHelper.createDocument();
        doc3.setName("doc3");
        doc3.addElement("foo");
        DetachTest.assertTrue((String)"Doc3 has root element", (doc3.getRootElement() != null ? 1 : 0) != 0);
        root = doc2.getRootElement();
        root.detach();
        doc3.setRootElement(root);
        DetachTest.assertTrue((String)"Doc3 now has root element", (doc3.getRootElement() == root ? 1 : 0) != 0);
        DetachTest.assertSame((String)"Root element now has a document", (Object)root.getDocument(), (Object)doc3);
        DetachTest.assertTrue((String)"Doc2 has no root element", (doc2.getRootElement() == null ? 1 : 0) != 0);
    }
}

