/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.StringWriter;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;

public class HTMLWriterTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.HTMLWriterTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testWriter() throws Exception {
        String xml = "<html> <body><![CDATA[First&nbsp;test]]></body> </html>";
        Document document = DocumentHelper.parseText(xml);
        StringWriter buffer = new StringWriter();
        HTMLWriter writer = new HTMLWriter(buffer);
        writer.write(document);
        String output = buffer.toString();
        String expects = "\n<html>\n  <body>First&nbsp;test</body>\n</html>\n";
        System.out.println("expects: " + expects);
        System.out.println("output: " + output);
        HTMLWriterTest.assertEquals((String)"Output is correct", (String)expects, (String)output);
    }

    public void testBug923882() throws Exception {
        Document doc = DocumentFactory.getInstance().createDocument();
        Element root = doc.addElement("root");
        root.addText("this is ");
        root.addText(" sim");
        root.addText("ple text ");
        root.addElement("child");
        root.addText(" contai");
        root.addText("ning spaces and");
        root.addText(" multiple textnodes");
        OutputFormat format = new OutputFormat();
        format.setEncoding("UTF-8");
        format.setIndentSize(4);
        format.setNewlines(true);
        format.setTrimText(true);
        format.setExpandEmptyElements(true);
        StringWriter buffer = new StringWriter();
        HTMLWriter writer = new HTMLWriter(buffer, format);
        writer.write(doc);
        String xml = buffer.toString();
        this.log(xml);
        int start = xml.indexOf("<root");
        int end = xml.indexOf("/root>") + 6;
        String eol = "\n";
        String expected = "<root>this is simple text" + eol + "    <child></child>containing spaces and multiple textnodes" + eol + "</root>";
        System.out.println("Expected:");
        System.out.println(expected);
        System.out.println("Obtained:");
        System.out.println(xml.substring(start, end));
        HTMLWriterTest.assertEquals((String)expected, (String)xml.substring(start, end));
    }

    public void testBug923882asWriter() throws Exception {
        StringWriter buffer = new StringWriter();
        HTMLWriter writer = new HTMLWriter(buffer, OutputFormat.createPrettyPrint());
        writer.characters("wor".toCharArray(), 0, 3);
        writer.characters("d-being-cut".toCharArray(), 0, 11);
        String expected = "word-being-cut";
        HTMLWriterTest.assertEquals((String)expected, (String)buffer.toString());
        buffer = new StringWriter();
        writer = new HTMLWriter(buffer, OutputFormat.createPrettyPrint());
        writer.characters("    wor".toCharArray(), 0, 7);
        writer.characters("d being    ".toCharArray(), 0, 11);
        writer.characters("  cut".toCharArray(), 0, 5);
        expected = "word being cut";
        HTMLWriterTest.assertEquals((String)expected, (String)buffer.toString());
    }

    public void testBug923882asWriterWithEmptyCharArray() throws Exception {
        StringWriter buffer = new StringWriter();
        HTMLWriter writer = new HTMLWriter(buffer, OutputFormat.createPrettyPrint());
        writer.characters("wor".toCharArray(), 0, 3);
        writer.characters(new char[0], 0, 0);
        writer.characters("d-being-cut".toCharArray(), 0, 11);
        String expected = "word-being-cut";
        HTMLWriterTest.assertEquals((String)expected, (String)buffer.toString());
    }

    public void testBug619415() throws Exception {
        Document doc = this.getDocument("/xml/test/dosLineFeeds.xml");
        StringWriter wr = new StringWriter();
        HTMLWriter writer = new HTMLWriter(wr, new OutputFormat("", false));
        writer.write(doc);
        String result = wr.toString();
        System.out.println(result);
        HTMLWriterTest.assertTrue((result.indexOf("Mary had a little lamb.") > -1 ? 1 : 0) != 0);
        HTMLWriterTest.assertTrue((result.indexOf("Hello, this is a test.") > -1 ? 1 : 0) != 0);
    }
}

