/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class IteratorTest
extends AbstractTestCase {
    private static final int NUMELE = 10;
    protected Document iterDocument;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.IteratorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.iterDocument = DocumentHelper.createDocument();
        Element root = this.iterDocument.addElement("root");
        int i = 0;
        while (i < 10) {
            root.addElement("iterator test").addAttribute("instance", Integer.toString(i));
            ++i;
        }
    }

    public void testElementCount() throws Exception {
        Element root = this.iterDocument.getRootElement();
        IteratorTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        List elements = root.elements("iterator test");
        int elementSize = elements.size();
        IteratorTest.assertTrue((String)("Root has " + elementSize + " children"), (elements != null && elementSize == 10 ? 1 : 0) != 0);
    }

    public void testPlainIteration() throws Exception {
        Element root = this.iterDocument.getRootElement();
        List elements = root.elements("iterator test");
        Iterator iter = root.elementIterator("iterator test");
        int elementSize = elements.size();
        int count = 0;
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            IteratorTest.assertEquals((String)("instance " + e.attribute("instance").getValue() + " equals " + count), (String)e.attribute("instance").getValue(), (String)Integer.toString(count));
            ++count;
        }
        IteratorTest.assertTrue((String)(String.valueOf(elementSize) + " elements iterated"), (count == elementSize ? 1 : 0) != 0);
    }

    public void testSkipAlternates() throws Exception {
        Element root = this.iterDocument.getRootElement();
        List elements = root.elements("iterator test");
        Iterator iter = root.elementIterator("iterator test");
        int elementSize = elements.size();
        int count = 0;
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            IteratorTest.assertEquals((String)("instance " + e.attribute("instance").getValue() + " equals " + count * 2), (String)e.attribute("instance").getValue(), (String)Integer.toString(count * 2));
            iter.next();
            ++count;
        }
        IteratorTest.assertTrue((String)(String.valueOf(elementSize / 2) + " alternate elements iterated"), (count == elementSize / 2 ? 1 : 0) != 0);
    }

    public void testNoHasNext() throws Exception {
        Element root = this.iterDocument.getRootElement();
        List elements = root.elements("iterator test");
        Iterator iter = root.elementIterator("iterator test");
        int elementSize = elements.size();
        int count = 0;
        Element e = null;
        while (count < elementSize) {
            e = (Element)iter.next();
            IteratorTest.assertEquals((String)("instance " + e.attribute("instance").getValue() + " equals " + count), (String)e.attribute("instance").getValue(), (String)Integer.toString(count));
            System.out.println("instance " + e.attribute("instance").getValue() + " equals " + count);
            ++count;
        }
        try {
            e = (Element)iter.next();
            if (e != null) {
                IteratorTest.assertTrue((String)("no more elements,value instead is " + e.attribute("instance").getValue()), (e == null ? 1 : 0) != 0);
            }
        }
        catch (Exception exp) {
            IteratorTest.assertTrue((String)"Real iterators throw NoSuchElementException", (boolean)(exp instanceof NoSuchElementException));
        }
    }

    public void testExtraHasNexts() throws Exception {
        Element root = this.iterDocument.getRootElement();
        List elements = root.elements("iterator test");
        Iterator iter = root.elementIterator("iterator test");
        int elementSize = elements.size();
        int count = 0;
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            IteratorTest.assertEquals((String)("instance " + e.attribute("instance").getValue() + " equals " + count), (String)e.attribute("instance").getValue(), (String)Integer.toString(count));
            iter.hasNext();
            ++count;
        }
        IteratorTest.assertTrue((String)(String.valueOf(elementSize) + " elements iterated with extra hasNexts"), (count == elementSize ? 1 : 0) != 0);
    }
}

