/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXReader;
import org.dom4j.io.SAXWriter;
import org.dom4j.io.XMLWriter;

public class RoundTripTest
extends AbstractTestCase {
    protected String[] testDocuments = new String[]{"/xml/test/encode.xml", "/xml/fibo.xml", "/xml/test/schema/personal-prefix.xsd", "/xml/test/soap2.xml", "/xml/test/test_schema.xml"};
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.RoundTripTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testTextRoundTrip() throws Exception {
        int i = 0;
        int size = this.testDocuments.length;
        while (i < size) {
            Document doc = this.getDocument(this.testDocuments[i]);
            this.roundTripText(doc);
            ++i;
        }
    }

    public void testSAXRoundTrip() throws Exception {
        int i = 0;
        int size = this.testDocuments.length;
        while (i < size) {
            Document doc = this.getDocument(this.testDocuments[i]);
            this.roundTripSAX(doc);
            ++i;
        }
    }

    public void testDOMRoundTrip() throws Exception {
        int i = 0;
        int size = this.testDocuments.length;
        while (i < size) {
            Document doc = this.getDocument(this.testDocuments[i]);
            this.roundTripDOM(doc);
            ++i;
        }
    }

    public void testJAXPRoundTrip() throws Exception {
        int i = 0;
        int size = this.testDocuments.length;
        while (i < size) {
            Document doc = this.getDocument(this.testDocuments[i]);
            this.roundTripJAXP(doc);
            ++i;
        }
    }

    public void testFullRoundTrip() throws Exception {
        int i = 0;
        int size = this.testDocuments.length;
        while (i < size) {
            Document doc = this.getDocument(this.testDocuments[i]);
            this.roundTripFull(doc);
            ++i;
        }
    }

    public void testRoundTrip() throws Exception {
        Document document = this.getDocument("/xml/xmlspec.xml");
        Document doc1 = this.roundTripSAX(document);
        Document doc2 = this.roundTripDOM(doc1);
        Document doc3 = this.roundTripSAX(doc2);
        Document doc4 = this.roundTripText(doc3);
        Document doc5 = this.roundTripDOM(doc4);
        this.assertDocumentsEqual(document, doc5);
    }

    protected Document roundTripDOM(Document document) throws Exception {
        DOMWriter domWriter = new DOMWriter();
        org.w3c.dom.Document domDocument = domWriter.write(document);
        DOMReader domReader = new DOMReader();
        Document newDocument = domReader.read(domDocument);
        newDocument.setName(document.getName());
        this.assertDocumentsEqual(document, newDocument);
        return newDocument;
    }

    protected Document roundTripJAXP(Document document) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        StringWriter buffer = new StringWriter();
        StreamResult streamResult = new StreamResult(buffer);
        DocumentSource documentSource = new DocumentSource(document);
        transformer.transform(documentSource, streamResult);
        DocumentResult documentResult = new DocumentResult();
        StreamSource streamSource = new StreamSource(new StringReader(buffer.toString()));
        transformer.transform(streamSource, documentResult);
        Document newDocument = documentResult.getDocument();
        newDocument.setName(document.getName());
        this.assertDocumentsEqual(document, newDocument);
        return newDocument;
    }

    protected Document roundTripSAX(Document document) throws Exception {
        SAXContentHandler contentHandler = new SAXContentHandler();
        SAXWriter saxWriter = new SAXWriter(contentHandler, contentHandler, contentHandler);
        saxWriter.write(document);
        Document newDocument = contentHandler.getDocument();
        newDocument.setName(document.getName());
        this.assertDocumentsEqual(document, newDocument);
        return newDocument;
    }

    protected Document roundTripText(Document document) throws Exception {
        StringWriter out = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(out);
        xmlWriter.write(document);
        String xml = out.toString();
        StringReader in = new StringReader(xml);
        SAXReader reader = new SAXReader();
        Document newDocument = reader.read(in);
        newDocument.setName(document.getName());
        this.assertDocumentsEqual(document, newDocument);
        return newDocument;
    }

    protected Document roundTripFull(Document document) throws Exception {
        Document doc2 = this.roundTripDOM(document);
        Document doc3 = this.roundTripSAX(doc2);
        Document doc4 = this.roundTripText(doc3);
        this.assertDocumentsEqual(document, doc4);
        return doc4;
    }
}

