/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.textui.TestRunner;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.datatype.AbstractDataTypeTestCase;
import org.dom4j.datatype.DatatypeDocumentFactory;
import org.dom4j.io.SAXReader;

public class Datatype2Test
extends AbstractDataTypeTestCase {
    public static final int YEAR = 2001;
    public static final int MONTH = 10;
    public static final int DATE = 31;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.datatype.Datatype2Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testSchema() throws Exception {
        Document schema = this.getSchema();
        this.validateDocumentWithSchema(schema);
    }

    public void testSchemaWithNamedComplexType() throws Exception {
        Document schema = this.getSchemaWithNamedComplexType();
        this.validateDocumentWithSchema(schema);
    }

    public void testSchemaWithReference() throws Exception {
        Document schema = this.getSchemaWithReference();
        this.validateDocumentWithSchema(schema);
    }

    public void testSchemaWithNamedSimpleType() throws Exception {
        Document schema = this.getSchemaWithNamedSimpleType();
        this.validateDocumentWithSchema(schema);
    }

    private void validateDocumentWithSchema(Document schema) throws Exception {
        Document doc = this.getSource(schema);
        Element root = doc.getRootElement();
        this.validateLongAttribute(root);
        this.validateFloatElement(root);
        this.validateDateElement(root);
    }

    private void validateLongAttribute(Element root) throws Exception {
        Attribute attr = root.attribute("longAttribute");
        Object attrData = attr.getData();
        this.validateData("testLongAttribute", attrData, new Long(123L));
        System.out.println("retrieved attribute " + attrData);
    }

    private void validateFloatElement(Element root) throws Exception {
        Element elem = root.element("floatElement");
        Object elemData = elem.getData();
        this.validateData("testFloatElement", elemData, new Float(1.23));
        System.out.println("retrieved element:" + elemData);
    }

    private void validateDateElement(Element root) throws Exception {
        Element elem = root.element("dateElement");
        Object elemData = elem.getData();
        Calendar expected = Datatype2Test.getDate();
        System.out.println("retrieved element:" + elemData);
        Datatype2Test.assertTrue((boolean)(elemData instanceof Calendar));
        Calendar elemCal = (Calendar)elemData;
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyyZ");
        format.setTimeZone(elemCal.getTimeZone());
        String elemStr = format.format(elemCal.getTime());
        format.setTimeZone(expected.getTimeZone());
        String expectedStr = format.format(expected.getTime());
        Datatype2Test.assertEquals((String)"testDateElement", (String)expectedStr, (String)elemStr);
    }

    private void validateData(String test, Object retrieved, Object expected) throws Exception {
        Class<?> retrievedClass = retrieved.getClass();
        Class<?> expectedClass = expected.getClass();
        if (!expectedClass.equals(retrievedClass)) {
            String msg = "class mismatch in " + test + ":expected " + expectedClass + ", retrieved " + retrievedClass;
            throw new Exception(msg);
        }
        if (!expected.equals(retrieved)) {
            String msg = "value mismatch in " + test + ":expected " + expected + ", retrieved " + retrieved;
            throw new Exception(msg);
        }
    }

    private Document getSource(Document schema) throws Exception {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version='1.0' ?>");
        b.append("<test xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
        b.append("        xsi:noNamespaceSchemaLocation='long.xsd'");
        b.append("        longAttribute='123' >");
        b.append("    <floatElement>1.23</floatElement>");
        b.append("    <dateElement>" + Datatype2Test.getDateString() + "</dateElement>");
        b.append("</test>");
        StringReader in = new StringReader(b.toString());
        DatatypeDocumentFactory docFactory = new DatatypeDocumentFactory();
        docFactory.loadSchema(schema);
        SAXReader parser = new SAXReader(docFactory);
        return parser.read(in);
    }

    private Document getSchema() throws Exception {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version='1.0' encoding='UTF-8'?>");
        b.append("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'>");
        b.append(" <xsd:element name='test'>");
        b.append("  <xsd:complexType>");
        b.append("   <xsd:sequence>");
        b.append("    <xsd:element name='floatElement' type='xsd:float' />");
        b.append("    <xsd:element name='dateElement' type='xsd:date' />");
        b.append("   </xsd:sequence>");
        b.append("   <xsd:attribute name='longAttribute' type='xsd:long' />");
        b.append("  </xsd:complexType>");
        b.append(" </xsd:element>");
        b.append("</xsd:schema>");
        StringReader in = new StringReader(b.toString());
        SAXReader parser = new SAXReader();
        return parser.read(in);
    }

    private Document getSchemaWithNamedComplexType() throws Exception {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version='1.0' encoding='UTF-8'?>");
        b.append("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'>");
        b.append(" <xsd:element name='test' type='TimePeriodType' />");
        b.append(" <xsd:complexType name='TimePeriodType'>");
        b.append("  <xsd:sequence>");
        b.append("   <xsd:element name='floatElement' type='xsd:float' />");
        b.append("   <xsd:element name='dateElement' type='xsd:date' />");
        b.append("  </xsd:sequence>");
        b.append("  <xsd:attribute name='longAttribute' type='xsd:long' />");
        b.append(" </xsd:complexType>");
        b.append("</xsd:schema>");
        StringReader in = new StringReader(b.toString());
        SAXReader parser = new SAXReader();
        return parser.read(in);
    }

    private Document getSchemaWithReference() throws Exception {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version='1.0' encoding='UTF-8'?>");
        b.append("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'>");
        b.append(" <xsd:element name='test' type='TimePeriodType' />");
        b.append(" <xsd:complexType name='TimePeriodType'>");
        b.append("  <xsd:sequence>");
        b.append("   <xsd:element name='floatElement' type='xsd:float' />");
        b.append("   <xsd:element ref='dateElement' />");
        b.append("  </xsd:sequence>");
        b.append("  <xsd:attribute name='longAttribute' type='xsd:long' />");
        b.append(" </xsd:complexType>");
        b.append(" <xsd:element name='dateElement' type='xsd:date' />");
        b.append("</xsd:schema>");
        StringReader in = new StringReader(b.toString());
        SAXReader parser = new SAXReader();
        return parser.read(in);
    }

    private Document getSchemaWithNamedSimpleType() throws Exception {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version='1.0' encoding='UTF-8'?>");
        b.append("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'>");
        b.append(" <xsd:element name='test'>");
        b.append("  <xsd:complexType>");
        b.append("   <xsd:sequence>");
        b.append("    <xsd:element name='floatElement' type='xsd:float' />");
        b.append("    <xsd:element name='dateElement' type='dateType' />");
        b.append("   </xsd:sequence>");
        b.append("   <xsd:attribute name='longAttribute' type='xsd:long' />");
        b.append("  </xsd:complexType>");
        b.append(" </xsd:element>");
        b.append(" <xsd:simpleType name='dateType'>");
        b.append("  <xsd:restriction base='xsd:date'>");
        b.append("  </xsd:restriction>");
        b.append(" </xsd:simpleType>");
        b.append("</xsd:schema>");
        StringReader in = new StringReader(b.toString());
        SAXReader parser = new SAXReader();
        return parser.read(in);
    }

    private static String getDateString() {
        String yyyy = Integer.toString(2001);
        String mm = Integer.toString(10);
        String dd = Integer.toString(31);
        return String.valueOf(yyyy) + "-" + mm + "-" + dd + "Z";
    }

    private static Calendar getDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.set(1, 2001);
        calendar.set(2, 9);
        calendar.set(5, 31);
        ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).setTimeZone(new SimpleTimeZone(0, "XSD 'Z' timezone"));
        return calendar;
    }
}

