/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class ValueOfTest
extends AbstractTestCase {
    protected static String[] paths = new String[]{"/root", "//author", "//author/@name", "/root/author[1]", "/root/author[1]/@name", "/root/author[2]", "/root/author[2]/@name", "/root/author[3]", "/root/author[3]/@name", "name()", "name(.)", "name(..)", "name(child::node())", "name(parent::*)", "name(../*)", "name(../child::node())", "local-name()", "local-name(..)", "local-name(parent::*)", "local-name(../*)", "parent::*", "name(/.)", "name(/child::node())", "name(/*)", ".", "..", "../*", "../child::node()", "/.", "/*", "*", "/child::node()"};
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.xpath.ValueOfTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testXPaths() throws Exception {
        Element root = this.document.getRootElement();
        List children = root.elements("author");
        Element child1 = (Element)children.get(0);
        this.testXPath(this.document);
        this.testXPath(root);
        this.testXPath(child1);
    }

    protected void testXPath(Node node) throws Exception {
        this.log("Testing XPath on: " + node);
        this.log("===============================");
        int size = paths.length;
        int i = 0;
        while (i < size) {
            this.testXPath(node, paths[i]);
            ++i;
        }
    }

    protected void testXPath(Node node, String xpathExpr) throws Exception {
        try {
            XPath xpath = node.createXPath(xpathExpr);
            String value = xpath.valueOf(node);
            this.log("valueOf: " + xpathExpr + " is: " + value);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ValueOfTest.assertTrue((String)("Failed with exception: " + e), (boolean)false);
        }
    }
}

