require("libs.utils")
local hook_paint = nil
local hook_win_msg = nil
local tip_show_tick = GetTickCount()
local screen_width = dota.GetScreenWidth()
local screen_height = dota.GetScreenHeight()
local font = dota.DrawUtils.GetInstance():CreateFont("", 14, 600, 0, 0, bit.bor(EFontFlags.FONTFLAG_DROPSHADOW, EFontFlags.FONTFLAG_OUTLINE))

function OnWndProc(uMsg, wParam, lParam)
    if uMsg == WM_KEYDOWN then
        if wParam == VK_HOME then
            dota.ExecuteCommand("dota_toggle_free_camera")
        elseif wParam == VK_NUMPAD8 then
            dota.CameraBase.SetPitch(dota.CameraBase.GetPitch() - 1)
            --dota.CameraFree.SetPitch(dota.CameraFree.GetPitch() - 1)
            tip_show_tick = GetTickCount() + 1500
        elseif wParam == VK_NUMPAD5 then
            dota.CameraBase.SetPitch(dota.CameraBase.GetPitch() + 1)
            --dota.CameraFree.SetPitch(dota.CameraFree.GetPitch() + 1)
            tip_show_tick = GetTickCount() + 1500
        elseif wParam == VK_NUMPAD4 then
            dota.CameraBase.SetYaw(dota.CameraBase.GetYaw() + 1)
            --dota.CameraFree.SetYaw(dota.CameraFree.GetYaw() + 1)
            tip_show_tick = GetTickCount() + 1500
        elseif wParam == VK_NUMPAD6 then
            dota.CameraBase.SetYaw(dota.CameraBase.GetYaw() - 1)
            --dota.CameraFree.SetYaw(dota.CameraFree.GetYaw() - 1)
            tip_show_tick = GetTickCount() + 1500
            
        elseif wParam == VK_NUMPAD1 then
            --dota.CameraFree.SetRoll(dota.CameraFree.GetRoll() - 1)
            --tip_show_tick = GetTickCount() + 1500
        elseif wParam == VK_NUMPAD3 then
            --dota.CameraFree.SetRoll(dota.CameraFree.GetRoll() + 1)
            --tip_show_tick = GetTickCount() + 1500
        elseif wParam == VK_NUMPAD2 then
            --dota.CameraFree.SetRoll(0)
            --tip_show_tick = GetTickCount() + 1500
        end
    end
end

function OnPaint()
    -- 这里可以设置数值提示是否自动消失
    if (tip_show_tick > GetTickCount()) then
        dota.DrawString(font, screen_width/2,screen_height/100*32, 255,192,203,255, true, string.format("Pitch: %.2f\nYaw: %.2f", dota.CameraBase.GetPitch(), dota.CameraBase.GetYaw()))
        --dota.DrawString(font, screen_width/2,screen_height/100*32+20, 255,192,203,255, true, string.format("Pitch: %.2f\nYaw: %.2f\nRoll: %.2f", dota.CameraFree.GetPitch(), dota.CameraFree.GetYaw(), dota.CameraFree.GetRoll()))
    end
end

function Initialize()
    hook_paint = dota.AddPaintHook(OnPaint)
    hook_win_msg = dota.AddWinMsgHook(OnWndProc)

    log.Warning("[Lua] camera_control.lua loaded\n")
end

--[[
class CameraBase
  GetPitch
  SetPitch
  GetYaw
  SetYaw
  --该类可以调节英雄观察模式下的摄像机角度
  --游戏内聊天框命令-[指令] [数值] 例如：-pitch 60 和-yaw 120
class end

class CameraFree
  GetPitch
  SetPitch
  GetYaw
  SetYaw
  GetRoll
  SetRoll
  --该类里面的指令必须在进入free camera模式下方可调用，否则可能会引起游戏崩溃。
  --该类可以调节free camera模式下的摄像机角度，观战模式下，控制台执行 dota_toggle_free_camera 进入该模式。
  --游戏内聊天框命令-[指令] [数值] 例如：-freepitch 60 和-freeyaw 120 以及-freeroll 20
class end

更多资料：
  pitch yaw roll是什么？ http://blog.csdn.net/yuzhongchun/article/details/22749521

]]