require("libs.utils")
local hook_paint
local hook_win_msg
local hook_mouse_wheeled
local camera_distance = 0
local camera_distance_show_count = 0
local screen_width = dota.GetScreenWidth()
local screen_height = dota.GetScreenHeight()
local font = dota.DrawUtils.GetInstance():CreateFont("", 14, 600, 0, 0, bit.bor(EFontFlags.FONTFLAG_DROPSHADOW, EFontFlags.FONTFLAG_OUTLINE))
    
function OnMouseWheeled(delta)
    if (bit.band(GetAsyncKeyState(VK_CONTROL),0x8000) == 0x8000) then
        camera_distance = dota.GetCameraDistance() - delta * 16
        dota.SetCameraDistance(camera_distance)
        camera_distance_show_count = GetTickCount() + 1500
        App.GetConfig():SetInt("/utils/CameraDistance", camera_distance)
        return true
    end
end

function OnWndProc(uMsg, wParam, lParam)
    if uMsg == WM_KEYDOWN then
        if wParam == VK_ADD then
            if (bit.band(GetAsyncKeyState(VK_CONTROL),0x8000) == 0x8000) then
                camera_distance = dota.GetCameraDistance() + 16
                dota.SetCameraDistance(camera_distance)
                camera_distance_show_count = GetTickCount() + 1500
                App.GetConfig():SetInt("/utils/CameraDistance", camera_distance)
            end
        elseif wParam == VK_SUBTRACT then
            if (bit.band(GetAsyncKeyState(VK_CONTROL),0x8000) == 0x8000) then
                camera_distance = dota.GetCameraDistance() - 16
                dota.SetCameraDistance(camera_distance)
                camera_distance_show_count = GetTickCount() + 1500
                App.GetConfig():SetInt("/utils/CameraDistance", camera_distance)
            end
        elseif wParam == VK_MULTIPLY then
            if (bit.band(GetAsyncKeyState(VK_CONTROL),0x8000) == 0x8000) then
                camera_distance = 1134
                dota.SetCameraDistance(camera_distance)
                camera_distance_show_count = GetTickCount() + 1500
                App.GetConfig():SetInt("/utils/CameraDistance", camera_distance)
            end
        end
    end
end

function onPaint()
    if (camera_distance_show_count > GetTickCount()) then
        dota.DrawString(font, screen_width/2,screen_height/100*32, 255,192,203,255, true, string.format("当前视距：x%.2f", camera_distance/1134))
    end
end

function Initialize()
    camera_distance = App.GetConfig():GetInt("/utils/CameraDistance", 2270)
    camera_distance_show_count = GetTickCount()
    dota.SetCameraDistance(camera_distance)
    
    hook_paint = dota.AddPaintHook(onPaint)
    hook_win_msg = dota.AddWinMsgHook(OnWndProc)
    hook_mouse_wheeled = dota.AddMouseWheeledHook(OnMouseWheeled)

    log.Warning("camera_distance.lua loaded\n")
end