require("libs.utils")

local hook = nil
local screen_width = dota.GetScreenWidth()
local screen_height = dota.GetScreenHeight()
local font = dota.DrawUtils.GetInstance():CreateFont("", 12, 500, 0, 0, bit.bor(EFontFlags.FONTFLAG_DROPSHADOW, EFontFlags.FONTFLAG_OUTLINE))

function OnPaint()
    local localHero = dota.GetLocalHero()
    if (localHero == nil) then return end
    local base_entity = nil
    local i = 0
    local n = dota.GetHighestEntityIndex()
    for i = 0, n do
        repeat
            local base_entity = dota.GetClientEntity(i)
            if (base_entity == nil) then break end
            local class_id = base_entity:GetClientClass():GetClassID()

            if (class_id ~= ClassIDs.CDOTA_BaseNPC_Tower and class_id ~= ClassIDs.CDOTA_BaseNPC_Fort and class_id ~= ClassIDs.CDOTA_BaseNPC_Barracks and class_id ~= ClassIDs.CDOTA_BaseNPC_Building) then
                if (base_entity:IsVisible() == false) then break end    -- 单位不可视
            end
            if (class_id < ClassIDs.CDOTA_BaseNPC or class_id > ClassIDs.CDOTA_BaseNPC_Warlock_Golem) then break end    -- 过滤CDOTA_BaseNPC

            local healthbar_offset = base_entity:GetHealthbarOffset();
            if (healthbar_offset == -1) then break end
            local vecScreen = dota.WorldToScreen(base_entity:GetAbsOrigin(),dota.Vector(0, 0, healthbar_offset))
            if (vecScreen.x <= 0 or vecScreen.x >= screen_width or vecScreen.y <= 0 or vecScreen.y >= screen_height) then break end
            
            local base_npc = dota.toBaseNPC(base_entity)
            local health    = base_npc:GetHealth()
            local health_max = base_npc:GetMaxHealth()
            
            if (health <= 0) then break end
            
            if (localHero:GetTeamNum() == base_npc:GetTeamNum()) then
                if (health * 2 > health_max) then break end    -- 己方单位血量超过50%无法反补
            end
            
            local armorType = 0.5
            local height_fix = 22
            if (class_id == ClassIDs.CDOTA_BaseNPC_Tower) then
                height_fix = 70;
            elseif (class_id == ClassIDs.CDOTA_BaseNPC_Fort) then
                height_fix = 70;
            elseif (class_id == ClassIDs.CDOTA_BaseNPC_Barracks) then
                height_fix = 70;
            elseif (class_id == ClassIDs.CDOTA_BaseNPC_Creep_Lane) then
                armorType = 1;
            elseif (class_id == ClassIDs.CDOTA_BaseNPC_Creep_Neutral) then
                armorType = 1;
            end
            
            local real_damage = localHero:GetRealDamage(base_npc,armorType);
            if (health - real_damage - real_damage > 0) then break end    -- 超过两次攻击
                
            if (health - real_damage > 0) then
                dota.DrawString( font, vecScreen.x, vecScreen.y - height_fix, 255,255,0,255, true, health)   -- 两次攻击
                
            else
                dota.DrawString( font, vecScreen.x, vecScreen.y - height_fix, 255,0,0,255, true, health)    -- 一次攻击
            end
            
            break   -- 跳出repeat死循环
        until true
    end -- for循环结束
end

function Initialize()
    hook = dota.AddPaintHook(OnPaint)
    log.Warning("lasthit_tips.lua loaded\n")
end


--[[    TeamNum：天辉2，夜魇3，中立生物4

        local neutrals    = dota.FindEntitiesWithName("CDOTA_BaseNPC_Creep_Neutral") -- 中立生物
        local creeps      = dota.FindEntitiesWithName("CDOTA_BaseNPC_Creep_Lane")    -- 线上小兵
        local sieges      = dota.FindEntitiesWithName("CDOTA_BaseNPC_Creep_Siege")   -- 攻城车
        local towers      = dota.FindEntitiesWithName("CDOTA_BaseNPC_Tower")         -- 防御塔
        local buildings   = dota.FindEntitiesWithName("CDOTA_BaseNPC_Building")      -- 建筑
        local barrackses  = dota.FindEntitiesWithName("CDOTA_BaseNPC_Barracks")      -- 兵营
        local forts       = dota.FindEntitiesWithName("CDOTA_BaseNPC_Fort")          -- 大本营

--]]