require("libs.class_id")

WM_KEYDOWN = 0x0100
WM_DotaConfig = RegisterWindowMessage("WM_SH_GAME")

ConfigFlags = {
    FreeCameraDistance           = 1,
    AutoAccept                   = 2,
    LastHitTips                  = 3,
    LastHitCount                 = 4,
    CameraDisableZoom            = 5,
    MapHighDefinition            = 6,
    UltimateTimer                = 7,
    RightClickDeny               = 8,
    AntiRunBack                  = 9,
    NetGraph                     = 10,
    IngameTimer                  = 11,
    GamePausedTimer              = 12,
    GamePausedBroadcast          = 13,
    RuneTimer                    = 14,
    RuneTips                     = 15,
    RuneBroadcast                = 16,
    RoshanTimer                  = 17,
    RoshanBroadcast              = 18,
    ShowTeamHealthNum            = 19,
    ShowTeamManaNum              = 20,
    ShowTeamLevel                = 21,
    ShowEnemyHealthNum           = 22,
    ShowEnemyManaNum             = 23,
    ShowEnemyLevel               = 24,
    ShowPlayerNames              = 25,
    ObserveEnemyHero             = 26,
    ShowItemsPanel               = 27,
    EnableRangeFinder            = 28,
    ShowTopHealthBar             = 29,
    ShowEnemyHeroManaBar         = 30,
    ShowPing                     = 31,
    ShowTowerRange               = 32,
    AutoSwithToGame              = 33,
    WeatherEffects               = 34,
    WeatherEffects_Value         = 35,
    WeatherEffectsRandom         = 36,
    WeatherEffectsRandom_Value   = 37,
    FpsMax                       = 38,
    FpsMax_Value                 = 39,
    HealthPerVertical            = 40,
    HealthPerVertical_Value      = 41,
    ShowHeroRange                = 42,
    ShowHeroRange_Value          = 43,
    AntiLowViolence              = 44,
    AntiWordFilter               = 45,
    AccountIDFound               = 46,
    ModifyChatColor              = 47,
    ShowChatTails                = 48,
    StartOfflineGame             = 49,
    RemoteCmd                    = 50,
    ChatColorID                  = 51,
    dota_bot_practice_difficulty = 52,
    dota_start_ai_game           = 53,
    RainbowText                  = 54,
    PrivateBroadcast             = 55,
    SetHudSkin                   = 56,
    GamePathFound                = 57,
    LauncherChanged              = 58,
    SteamPathFound               = 59,
    GameStart                    = 60,
    CameraControl                = 61,
    StunBar                      = 62
}

function LOWORD(dword)
    return bit.band(dword,0xFFFF)
end

function HIWORD(dword)
    return bit.band(bit.rshift(dword,16),0xFFFF)
end


--[[
 * Virtual Keys, Standard Set
--]]

VK_P  = 0x50
VK_R  = 0x52

VK_LBUTTON      =  0x01
VK_RBUTTON      =  0x02
VK_CANCEL       =  0x03
VK_MBUTTON      =  0x04    --[[ NOT contiguous with L & RBUTTON--]]
VK_XBUTTON1     =  0x05    --[[ NOT contiguous with L & RBUTTON--]]
VK_XBUTTON2     =  0x06    --[[ NOT contiguous with L & RBUTTON--]]

--[[
 * 0x07 : unassigned
--]]

VK_BACK         =  0x08
VK_TAB          =  0x09

--[[
 * 0x0A - 0x0B : reserved
--]]

VK_CLEAR        =  0x0C
VK_RETURN       =  0x0D

VK_SHIFT        =  0x10
VK_CONTROL      =  0x11
VK_MENU         =  0x12
VK_PAUSE        =  0x13
VK_CAPITAL      =  0x14

VK_KANA         =  0x15
VK_HANGEUL      =  0x15  --[[ old name - should be here for compatibility--]]
VK_HANGUL       =  0x15
VK_JUNJA        =  0x17
VK_FINAL        =  0x18
VK_HANJA        =  0x19
VK_KANJI        =  0x19

VK_ESCAPE       =  0x1B

VK_CONVERT      =  0x1C
VK_NONCONVERT   =  0x1D
VK_ACCEPT       =  0x1E
VK_MODECHANGE   =  0x1F

VK_SPACE        =  0x20
VK_PRIOR        =  0x21
VK_NEXT         =  0x22
VK_END          =  0x23
VK_HOME         =  0x24
VK_LEFT         =  0x25
VK_UP           =  0x26
VK_RIGHT        =  0x27
VK_DOWN         =  0x28
VK_SELECT       =  0x29
VK_PRINT        =  0x2A
VK_EXECUTE      =  0x2B
VK_SNAPSHOT     =  0x2C
VK_INSERT       =  0x2D
VK_DELETE       =  0x2E
VK_HELP         =  0x2F

--[[
 * VK_0 - VK_9 are the same as ASCII '0' - '9' (0x30 - 0x39)
 * 0x40 : unassigned
 * VK_A - VK_Z are the same as ASCII 'A' - 'Z' (0x41 - 0x5A)
--]]

VK_LWIN         =  0x5B
VK_RWIN         =  0x5C
VK_APPS         =  0x5D

--[[
 * 0x5E : reserved
--]]

VK_SLEEP        =  0x5F

VK_NUMPAD0      =  0x60
VK_NUMPAD1      =  0x61
VK_NUMPAD2      =  0x62
VK_NUMPAD3      =  0x63
VK_NUMPAD4      =  0x64
VK_NUMPAD5      =  0x65
VK_NUMPAD6      =  0x66
VK_NUMPAD7      =  0x67
VK_NUMPAD8      =  0x68
VK_NUMPAD9      =  0x69
VK_MULTIPLY     =  0x6A
VK_ADD          =  0x6B
VK_SEPARATOR    =  0x6C
VK_SUBTRACT     =  0x6D
VK_DECIMAL      =  0x6E
VK_DIVIDE       =  0x6F
VK_F1           =  0x70
VK_F2           =  0x71
VK_F3           =  0x72
VK_F4           =  0x73
VK_F5           =  0x74
VK_F6           =  0x75
VK_F7           =  0x76
VK_F8           =  0x77
VK_F9           =  0x78
VK_F10          =  0x79
VK_F11          =  0x7A
VK_F12          =  0x7B
VK_F13          =  0x7C
VK_F14          =  0x7D
VK_F15          =  0x7E
VK_F16          =  0x7F
VK_F17          =  0x80
VK_F18          =  0x81
VK_F19          =  0x82
VK_F20          =  0x83
VK_F21          =  0x84
VK_F22          =  0x85
VK_F23          =  0x86
VK_F24          =  0x87

--[[
 * 0x88 - 0x8F : unassigned
--]]

VK_NUMLOCK      =  0x90
VK_SCROLL       =  0x91

--[[
 * NEC PC-9800 kbd definitions
--]]
VK_OEM_NEC_EQUAL =  0x92   -- '=' key on numpad

--[[
 * Fujitsu/OASYS kbd definitions
--]]
VK_OEM_FJ_JISHO =  0x92   -- 'Dictionary' key
VK_OEM_FJ_MASSHOU =  0x93   -- 'Unregister word' key
VK_OEM_FJ_TOUROKU =  0x94   -- 'Register word' key
VK_OEM_FJ_LOYA  =  0x95   -- 'Left OYAYUBI' key
VK_OEM_FJ_ROYA  =  0x96   -- 'Right OYAYUBI' key

--[[
 * 0x97 - 0x9F : unassigned
--]]

--[[
 * VK_L* & VK_R* - left and right Alt, Ctrl and Shift virtual keys.
 * Used only as parameters to GetAsyncKeyState() and GetKeyState().
 * No other API or message will distinguish left and right keys in this way.
--]]
VK_LSHIFT       =  0xA0
VK_RSHIFT       =  0xA1
VK_LCONTROL     =  0xA2
VK_RCONTROL     =  0xA3
VK_LMENU        =  0xA4
VK_RMENU        =  0xA5


EFontFlags = {
    FONTFLAG_NONE           = 0x000,
    FONTFLAG_ITALIC         = 0x001,
    FONTFLAG_UNDERLINE      = 0x002,
    FONTFLAG_STRIKEOUT      = 0x004,
    FONTFLAG_SYMBOL         = 0x008,
    FONTFLAG_ANTIALIAS      = 0x010,
    FONTFLAG_GAUSSIANBLUR   = 0x020,
    FONTFLAG_ROTARY         = 0x040,
    FONTFLAG_DROPSHADOW     = 0x080,
    FONTFLAG_ADDITIVE       = 0x100,
    FONTFLAG_OUTLINE        = 0x200,
    FONTFLAG_CUSTOM         = 0x400
}
