require("libs.utils")

local win_msg_hook = nil
local game_start_hook = nil
local hook = nil
local font = dota.DrawUtils.GetInstance():CreateFont("", 14, 800, 0, 0, bit.bor(EFontFlags.FONTFLAG_DROPSHADOW, EFontFlags.FONTFLAG_OUTLINE))

local screenHeight = nil
local roshSpawnTime = 0
local roshan_kill_hook = nil

-- roshan_tips.lua

local bShowRoshanTimer = App.GetConfig():GetBool("/utils/RoshanTimer")
local bAutoSendRoshSpawn = App.GetConfig():GetBool("/utils/RoshanBroadcast")

local say_method = App.GetConfig():GetBool("/utils/PrivateBroadcast") and "say_student" or "say_team"

function onWndProc(uMsg, wParam, lParam)
	if uMsg == WM_DotaConfig then
		if wParam == ConfigFlags.RoshanTimer then
    		bShowRoshanTimer = lParam > 0
        elseif wParam == ConfigFlags.RoshanBroadcast then
            bAutoSendRoshSpawn = lParam > 0
        elseif wParam == ConfigFlags.PrivateBroadcast then
            say_method = (lParam > 0) and "say_student" or "say_team"
		end
	end
end

function OnPaint()
    local gameTime = math.floor(dota.GameRules:GetInstance():GetGameTime())
    if (roshSpawnTime > 0) then
        local remain = math.floor(roshSpawnTime - gameTime)
        if (remain <= 0) then
            roshSpawnTime = 0
        end
        -- 肉山计时
        if (bShowRoshanTimer == true) then
            local tstring = string.format("肉山刷新：%02.0f:%02.0f", math.floor(math.fmod(remain,3600.0)/60.0), math.fmod(remain, 60.0))
            dota.DrawString(font, 5, screenHeight / 100 * 52 + 20 * 0, 0,255,0,255, false, tstring)
        end
        -- 肉山广播
        if (bAutoSendRoshSpawn == true) then
            if (roshSpawnTime == 0) then
                dota.ExecuteCommand(string.format("%s \"\x12肉山\x01将在\x12 3分钟内 \x01随机刷新，请注意\x12插眼\x01。(Dota2超级助手)\"",say_method))
            end
        end
    end
end

function OnRoshanKill()
    roshSpawnTime = math.floor(dota.GameRules:GetInstance():GetGameTime()+ 60*8)
end

function OnMapLoadFinished()
    roshSpawnTime = 0
end

function Initialize()    
    screenHeight = dota.GetScreenHeight()
    hook = dota.AddPaintHook(OnPaint)
    win_msg_hook = dota.AddWinMsgHook(onWndProc)
    game_start_hook = dota.AddMapLoadFinishedHook(OnMapLoadFinished)
    roshan_kill_hook = dota.AddEventListener("dota_roshan_kill", OnRoshanKill)

    log.Warning("[lua loaded] roshan_tips.lua\n")
end