﻿require("libs.utils")

local win_msg_hook = nil
local hook = nil
local font = dota.DrawUtils.GetInstance():CreateFont("", 14, 800, 0, 0, bit.bor(EFontFlags.FONTFLAG_DROPSHADOW, EFontFlags.FONTFLAG_OUTLINE))

local broadcastCount = 0
local screenHeight = nil
local RuneTypes = {"双倍伤害","极速","幻象","隐身","恢复","赏金","奥术"}

-- rune_tips.lua
local bShowRuneTimer = App.GetConfig():GetBool("/utils/RuneTimer")
local bShowRuneTips = App.GetConfig():GetBool("/utils/RuneTips")
local bAutoSendRuneRefresh = App.GetConfig():GetBool("/utils/RuneBroadcast")

local say_method = App.GetConfig():GetBool("/utils/PrivateBroadcast") and "say_student" or "say_team"

function onWndProc(uMsg, wParam, lParam)
	if uMsg == WM_DotaConfig then
		if wParam == ConfigFlags.RuneTimer then
    		bShowRuneTimer = lParam > 0
        elseif wParam == ConfigFlags.RuneTips then
            bShowRuneTips = lParam > 0
        elseif wParam == ConfigFlags.RuneBroadcast then
            bAutoSendRuneRefresh = lParam > 0
        elseif wParam == ConfigFlags.PrivateBroadcast then
            say_method = (lParam > 0) and "say_student" or "say_team"
		end
	end
end

function OnPaint()
    local gameRules = dota.GameRules:GetInstance()
    local gameTime = gameRules:GetGameTime()
    local gameStartTime = gameRules:GetGameStartTime()
    local preGameStartTime = gameRules:GetPreGameStartTime()
    local remain = 0
    if preGameStartTime > 0 then
        if gameStartTime == 0 then
            remain = math.floor(preGameStartTime + 90 - 15 - gameTime)
        else
            remain = math.floor((2 - math.fmod((gameTime - gameStartTime) / 60, 2)) * 60)
        end
        -- 神符计时
        if (bShowRuneTimer==true) then
            dota.DrawString(font, 5, screenHeight / 100 * 52 + 20 * 1, 0,255,0,255, false, string.format("神符刷新：%02.0f:%02.0f", math.floor(math.fmod(remain,3600.0)/60.0), math.fmod(remain, 60.0)))
        end
        
        -- 神符广播
        if (bAutoSendRuneRefresh==true) then
            if (broadcastCount == 0) then
                if remain == 10 then
                    broadcastCount = 10
                end
            elseif broadcastCount > remain then
                broadcastCount = 0
                dota.ExecuteCommand(string.format("%s \"\x12神符\x01 将在\x12 10秒后 \x01刷新，请注意查看。(Dota2超级助手)\"",say_method))
            end
        end

    end
    
    -- 神符提醒
    if (bShowRuneTips==true) then
        local base_entity = nil
        local i = 0
        local n = dota.GetHighestEntityIndex()
        for i = 0, n do
            repeat
                base_entity = dota.GetClientEntity(i)
                if (base_entity == nil) then break end
                
                local classID = base_entity:GetClientClass():GetClassID()
                if (classID ~= ClassIDs.CDOTA_Item_Rune) then break end

                local rune      = dota.toCDOTA_Item_Rune(base_entity)
                local position  = rune:GetAbsOrigin()
                local runeType  = rune:GetRuneType() + 1
                
                if (position.x < 0) then
                    dota.DrawString(font, 5, screenHeight / 100 * 52 + 20 * 2, 255,0,0,255, false, string.format("上路神符：%s",RuneTypes[runeType]))
                else
                    dota.DrawString(font, 5, screenHeight / 100 * 52 + 20 * 3, 255,0,0,255, false, string.format("下路神符：%s",RuneTypes[runeType]))
                end
                break
            until true
        end
    end

end

function Initialize()    
    screenHeight = dota.GetScreenHeight()
    hook = dota.AddPaintHook(OnPaint)
    win_msg_hook = dota.AddWinMsgHook(onWndProc)

    log.Warning("[lua loaded] rune_tips.lua\n")
end