/*
 * Decompiled with CFR 0.152.
 */
package net.nerrd.intellij.plugin.dpicalculator.form;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.nerrd.intellij.plugin.dpicalculator.util.Calculator;

public class DpiCalculatorDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JTextField xxxhdpiTextField;
    private JTextField xxhdpiTextField;
    private JTextField xhdpiTextField;
    private JTextField hdpiTextField;
    private JTextField mdpiTextField;
    private JTextField ldpiTextField;
    private JTextField tvdpiTextField;
    private JLabel roundedTvdpi;
    private JLabel roundedLdpi;
    private JLabel roundedMdpi;
    private JLabel roundedHdpi;
    private JLabel roundedXhdpi;
    private JLabel roundedXxhdpi;
    private JLabel roundedXxxhdpi;
    private List<JTextField> dpiTextFieldsSet;
    private List<JLabel> roundedDpiLabelsSet;
    private List<Float> sizes;
    private List<Integer> sizesRounded;

    public DpiCalculatorDialog() {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setTitle("Android DPI Calculator");
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        ActionListener escapeKeyListener = e -> this.setVisible(false);
        this.getRootPane().registerKeyboardAction(escapeKeyListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.initLists();
        this.initListeners();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void applyNewDensityValues(JTextField currentDpiTextField) {
        try {
            float originalSize = Float.valueOf(currentDpiTextField.getText()).floatValue();
            this.sizes = Calculator.calculate(originalSize, this.dpiTextFieldsSet.indexOf(currentDpiTextField));
            this.sizesRounded = Calculator.calculateRoundedToScale(this.sizes);
            this.updateInputs(currentDpiTextField);
            this.updateRoundedValues();
        }
        catch (NumberFormatException ex) {
            currentDpiTextField.setToolTipText("Enter integers or floating point numbers");
            this.removeValues();
        }
    }

    private void updateRoundedValues() {
        this.roundedXxxhdpi.setText(String.valueOf(this.sizesRounded.get(0)));
        this.roundedXxhdpi.setText(String.valueOf(this.sizesRounded.get(1)));
        this.roundedXhdpi.setText(String.valueOf(this.sizesRounded.get(2)));
        this.roundedHdpi.setText(String.valueOf(this.sizesRounded.get(3)));
        this.roundedMdpi.setText(String.valueOf(this.sizesRounded.get(4)));
        this.roundedLdpi.setText(String.valueOf(this.sizesRounded.get(5)));
        this.roundedTvdpi.setText(String.valueOf(this.sizesRounded.get(6)));
    }

    private void moveRoundedValuesToInputs() {
        this.xxxhdpiTextField.setText(String.valueOf(this.sizesRounded.get(0)));
        this.xxhdpiTextField.setText(String.valueOf(this.sizesRounded.get(1)));
        this.xhdpiTextField.setText(String.valueOf(this.sizesRounded.get(2)));
        this.hdpiTextField.setText(String.valueOf(this.sizesRounded.get(3)));
        this.mdpiTextField.setText(String.valueOf(this.sizesRounded.get(4)));
        this.ldpiTextField.setText(String.valueOf(this.sizesRounded.get(5)));
        this.tvdpiTextField.setText(String.valueOf(this.sizesRounded.get(6)));
    }

    private void updateInputs(JTextField currentDpiTextField) {
        for (JTextField textField : this.dpiTextFieldsSet) {
            if (currentDpiTextField == null || textField == currentDpiTextField) continue;
            textField.setText(this.formatSize(this.sizes.get(this.dpiTextFieldsSet.indexOf(textField)).floatValue()));
        }
    }

    private String formatSize(float size) {
        String formattedSize = (double)size == Math.ceil(size) ? String.valueOf(Math.round(size)) : String.format("%.2f", Float.valueOf(size));
        return formattedSize.replaceAll(",", ".");
    }

    private void removeValues() {
        for (JTextField textField : this.dpiTextFieldsSet) {
            textField.setText("");
        }
        for (JLabel label : this.roundedDpiLabelsSet) {
            label.setText(" ");
        }
    }

    private void initLists() {
        this.dpiTextFieldsSet = new ArrayList<JTextField>(7);
        this.dpiTextFieldsSet.add(0, this.xxxhdpiTextField);
        this.dpiTextFieldsSet.add(1, this.xxhdpiTextField);
        this.dpiTextFieldsSet.add(2, this.xhdpiTextField);
        this.dpiTextFieldsSet.add(3, this.hdpiTextField);
        this.dpiTextFieldsSet.add(4, this.mdpiTextField);
        this.dpiTextFieldsSet.add(5, this.ldpiTextField);
        this.dpiTextFieldsSet.add(6, this.tvdpiTextField);
        this.roundedDpiLabelsSet = new ArrayList<JLabel>(7);
        this.roundedDpiLabelsSet.add(0, this.roundedXxxhdpi);
        this.roundedDpiLabelsSet.add(1, this.roundedXxhdpi);
        this.roundedDpiLabelsSet.add(2, this.roundedXhdpi);
        this.roundedDpiLabelsSet.add(3, this.roundedHdpi);
        this.roundedDpiLabelsSet.add(4, this.roundedMdpi);
        this.roundedDpiLabelsSet.add(5, this.roundedLdpi);
        this.roundedDpiLabelsSet.add(6, this.roundedTvdpi);
    }

    private void onOK() {
        this.setVisible(false);
    }

    private void initListeners() {
        this.buttonOK.addActionListener(e -> this.onOK());
        KeyListener inputChangeListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() != '\uffff') {
                    DpiCalculatorDialog.this.applyNewDensityValues((JTextField)keyEvent.getSource());
                }
            }
        };
        for (JTextField textField : this.dpiTextFieldsSet) {
            textField.addKeyListener(inputChangeListener);
            textField.getInputContext().selectInputMethod(new Locale("en", "US"));
        }
        MouseListener roundedValuesLabelClick = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DpiCalculatorDialog.this.moveRoundedValuesToInputs();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        for (JLabel label : this.roundedDpiLabelsSet) {
            label.addMouseListener(roundedValuesLabelClick);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JTextField jTextField7;
        JButton jButton;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(4, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton = new JButton();
        jButton.setText("OK");
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setVerticalTextPosition(1);
        jLabel8.setVerticalAlignment(1);
        jLabel8.setText("Click on rounded (with scale ratio) values below inputs to copy them");
        jPanel2.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 6, new Dimension(-1, 20), new Dimension(-1, 20), new Dimension(-1, 20)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(3, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.xxxhdpiTextField = jTextField7 = new JTextField();
        jTextField7.setToolTipText("xxxhdpi");
        jTextField7.setText("");
        jPanel4.add((Component)jTextField7, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 4, null, new Dimension(70, -1), new Dimension(70, -1)));
        this.tvdpiTextField = jTextField6 = new JTextField();
        jTextField6.setToolTipText("tvdpi");
        jPanel4.add((Component)jTextField6, new GridConstraints(1, 6, 1, 1, 8, 1, 2, 4, null, new Dimension(70, -1), new Dimension(70, -1)));
        this.xxhdpiTextField = jTextField5 = new JTextField();
        jTextField5.setToolTipText("xxhdpi");
        jTextField5.setColumns(0);
        jTextField5.setText("");
        jPanel4.add((Component)jTextField5, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 4, null, new Dimension(70, -1), new Dimension(70, -1)));
        this.xhdpiTextField = jTextField4 = new JTextField();
        jTextField4.setToolTipText("xhdpi");
        jPanel4.add((Component)jTextField4, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 4, null, new Dimension(70, -1), new Dimension(70, -1)));
        this.hdpiTextField = jTextField3 = new JTextField();
        jTextField3.setToolTipText("hdpi");
        jPanel4.add((Component)jTextField3, new GridConstraints(1, 3, 1, 1, 8, 1, 2, 4, null, new Dimension(70, -1), new Dimension(70, -1)));
        this.mdpiTextField = jTextField2 = new JTextField();
        jTextField2.setToolTipText("mdpi");
        jPanel4.add((Component)jTextField2, new GridConstraints(1, 4, 1, 1, 8, 1, 2, 4, null, new Dimension(70, -1), new Dimension(70, -1)));
        this.ldpiTextField = jTextField = new JTextField();
        jTextField.setToolTipText("ldpi");
        jPanel4.add((Component)jTextField, new GridConstraints(1, 5, 1, 1, 8, 1, 2, 4, null, new Dimension(70, -1), new Dimension(70, -1)));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("xxxhdpi");
        jPanel4.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 20), new Dimension(60, 20)));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("xxhdpi");
        jPanel4.add((Component)jLabel10, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 20), new Dimension(60, 20)));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("xhdpi");
        jPanel4.add((Component)jLabel11, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 7, null, new Dimension(-1, 20), new Dimension(60, 20)));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("hdpi");
        jPanel4.add((Component)jLabel12, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 7, null, new Dimension(-1, 20), new Dimension(60, 20)));
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("mdpi");
        jPanel4.add((Component)jLabel13, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 7, null, new Dimension(-1, 20), new Dimension(60, 20)));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("ldpi");
        jPanel4.add((Component)jLabel14, new GridConstraints(0, 5, 1, 1, 8, 0, 0, 6, null, new Dimension(-1, 20), new Dimension(60, 20)));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("tvdpi");
        jPanel4.add((Component)jLabel15, new GridConstraints(0, 6, 1, 1, 8, 0, 0, 6, null, new Dimension(-1, 20), new Dimension(60, 20)));
        this.roundedXxxhdpi = jLabel7 = new JLabel();
        Font font = jLabel7.getFont();
        jLabel7.setFont(new Font(font.getName(), 1, font.getSize()));
        jLabel7.setText("0");
        jPanel4.add((Component)jLabel7, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.roundedXxhdpi = jLabel6 = new JLabel();
        Font font2 = jLabel6.getFont();
        jLabel6.setFont(new Font(font2.getName(), 1, font2.getSize()));
        jLabel6.setText("0");
        jPanel4.add((Component)jLabel6, new GridConstraints(2, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.roundedXhdpi = jLabel5 = new JLabel();
        Font font3 = jLabel5.getFont();
        jLabel5.setFont(new Font(font3.getName(), 1, font3.getSize()));
        jLabel5.setText("0");
        jPanel4.add((Component)jLabel5, new GridConstraints(2, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.roundedHdpi = jLabel4 = new JLabel();
        Font font4 = jLabel4.getFont();
        jLabel4.setFont(new Font(font4.getName(), 1, font4.getSize()));
        jLabel4.setText("0");
        jPanel4.add((Component)jLabel4, new GridConstraints(2, 3, 1, 1, 4, 0, 0, 0, null, null, null));
        this.roundedMdpi = jLabel3 = new JLabel();
        Font font5 = jLabel3.getFont();
        jLabel3.setFont(new Font(font5.getName(), 1, font5.getSize()));
        jLabel3.setText("0");
        jPanel4.add((Component)jLabel3, new GridConstraints(2, 4, 1, 1, 4, 0, 0, 0, null, null, null));
        this.roundedLdpi = jLabel2 = new JLabel();
        Font font6 = jLabel2.getFont();
        jLabel2.setFont(new Font(font6.getName(), 1, font6.getSize()));
        jLabel2.setText("0");
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 5, 1, 1, 4, 0, 0, 0, null, null, null));
        this.roundedTvdpi = jLabel = new JLabel();
        Font font7 = jLabel.getFont();
        jLabel.setFont(new Font(font7.getName(), 1, font7.getSize()));
        jLabel.setText("0");
        jPanel4.add((Component)jLabel, new GridConstraints(2, 6, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("Enter size in one density to get the sizes in all other.");
        jPanel.add((Component)jLabel16, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 6, new Dimension(-1, 24), new Dimension(-1, 24), new Dimension(-1, 24)));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 25), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

