/*
 * Decompiled with CFR 0.152.
 */
package net.nerrd.intellij.plugin.dpicalculator.util;

import java.util.ArrayList;
import java.util.List;

public class Calculator {
    public static List<Float> calculate(float originalSize, int dpi) {
        float mdpi = 1.0f;
        switch (dpi) {
            case 0: {
                mdpi = originalSize / 4.0f;
                break;
            }
            case 1: {
                mdpi = originalSize / 2.0f;
                break;
            }
            case 2: {
                mdpi = originalSize / 2.0f;
                break;
            }
            case 3: {
                mdpi = originalSize / 1.5f;
                break;
            }
            case 4: {
                mdpi = originalSize / 1.0f;
                break;
            }
            case 5: {
                mdpi = originalSize / 0.75f;
                break;
            }
            case 6: {
                mdpi = originalSize / 1.33f;
            }
        }
        ArrayList<Float> sizes = new ArrayList<Float>(7);
        sizes.add(0, Float.valueOf(mdpi * 4.0f));
        sizes.add(1, Float.valueOf(mdpi * 3.0f));
        sizes.add(2, Float.valueOf(mdpi * 2.0f));
        sizes.add(3, Float.valueOf(mdpi * 1.5f));
        sizes.add(4, Float.valueOf(mdpi));
        sizes.add(5, Float.valueOf(mdpi * 0.75f));
        sizes.add(6, Float.valueOf(mdpi * 1.33f));
        return sizes;
    }

    public static List<Integer> calculateRoundedToScale(List<Float> originalCalculations) {
        ArrayList<Integer> rounded = new ArrayList<Integer>(6);
        rounded.add(0, Calculator.calculateRoundedValuesToNearestScaleRatioMultiplication(originalCalculations.get(0).floatValue(), 16));
        rounded.add(1, Calculator.calculateRoundedValuesToNearestScaleRatioMultiplication(originalCalculations.get(1).floatValue(), 12));
        rounded.add(2, Calculator.calculateRoundedValuesToNearestScaleRatioMultiplication(originalCalculations.get(2).floatValue(), 8));
        rounded.add(3, Calculator.calculateRoundedValuesToNearestScaleRatioMultiplication(originalCalculations.get(3).floatValue(), 6));
        rounded.add(4, Calculator.calculateRoundedValuesToNearestScaleRatioMultiplication(originalCalculations.get(4).floatValue(), 4));
        rounded.add(5, Calculator.calculateRoundedValuesToNearestScaleRatioMultiplication(originalCalculations.get(5).floatValue(), 3));
        rounded.add(6, (int)Math.ceil(originalCalculations.get(6).floatValue()));
        return rounded;
    }

    private static int calculateRoundedValuesToNearestScaleRatioMultiplication(float value, int multiplier) {
        int roundedValue = Math.round(value / (float)multiplier) * multiplier;
        return roundedValue == 0 ? multiplier : roundedValue;
    }
}

