/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.droiddraw.URLOpener;
import org.droiddraw.gui.Preferences;
import org.droiddraw.gui.PropertiesPanel;
import org.droiddraw.gui.Viewer;
import org.droiddraw.gui.WidgetAddRecord;
import org.droiddraw.property.Property;
import org.droiddraw.property.StringProperty;
import org.droiddraw.util.ArrayHandler;
import org.droiddraw.util.ColorHandler;
import org.droiddraw.util.StringHandler;
import org.droiddraw.widget.AbstractWidget;
import org.droiddraw.widget.Button;
import org.droiddraw.widget.CheckBox;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.Widget;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidEditor {
    public static int MAJOR_VERSION = 0;
    public static int MINOR_VERSION = 20;
    Layout layout;
    Widget selected;
    Viewer viewer;
    ScreenMode screen;
    int sx;
    int sy;
    PropertiesPanel pp;
    File stringFile = null;
    Hashtable<String, String> strings;
    File colorFile = null;
    Hashtable<String, Color> colors;
    File arrayFile = null;
    Hashtable<String, Vector<String>> arrays;
    Preferences prefs;
    UndoManager undo;
    Vector<ChangeListener> changeListeners;
    boolean changed;
    File drawable_dir;
    URLOpener opener;
    String theme;
    public static int OFFSET_X = 0;
    public static int OFFSET_Y = 48;
    private static AndroidEditor inst;

    private AndroidEditor() {
        this(ScreenMode.HVGA_PORTRAIT);
    }

    public boolean isLatestVersion() {
        try {
            URL u = new URL("http://www.droiddraw.org/version.txt");
            BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));
            String line = in.readLine();
            StringTokenizer tok = new StringTokenizer(line);
            int major = Integer.parseInt(tok.nextToken());
            int minor = Integer.parseInt(tok.nextToken());
            return MAJOR_VERSION > major || MAJOR_VERSION == major && MINOR_VERSION >= minor;
        }
        catch (MalformedURLException ex) {
            return true;
        }
        catch (IOException ex) {
            return true;
        }
        catch (Exception ex) {
            return true;
        }
    }

    private AndroidEditor(ScreenMode mode) {
        this.setScreenMode(mode);
        this.pp = new PropertiesPanel(false);
        this.colors = new Hashtable();
        this.strings = new Hashtable();
        this.arrays = new Hashtable();
        this.undo = new UndoManager();
        this.changeListeners = new Vector();
        this.colors.put("black", Color.black);
        this.colors.put("darkgray", Color.darkGray);
        this.colors.put("gray", Color.gray);
        this.colors.put("lightgray", Color.lightGray);
        this.colors.put("red", Color.red);
        this.colors.put("green", Color.green);
        this.colors.put("blue", Color.blue);
        this.colors.put("yellow", Color.yellow);
        this.colors.put("cyan", Color.cyan);
        this.colors.put("magenta", Color.magenta);
        this.colors.put("white", Color.white);
        this.changed = false;
    }

    public void queueUndoRecord(UndoableEdit edit) {
        this.undo.addEdit(edit);
        this.setChanged(true);
    }

    public void undo() {
        if (this.undo.canUndo()) {
            this.undo.undo();
            this.setChanged(true);
        }
    }

    public void redo() {
        if (this.undo.canRedo()) {
            this.undo.redo();
            this.setChanged(true);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            for (ChangeListener cl : this.changeListeners) {
                cl.stateChanged(new ChangeEvent(this.layout));
            }
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.add(cl);
    }

    public PropertiesPanel getPropertiesPanel() {
        return this.pp;
    }

    public void setDrawableDirectory(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Can not set drawable directory, given file is not a directory!");
        }
        this.drawable_dir = dir;
    }

    public File getDrawableDirectory() {
        return this.drawable_dir;
    }

    public BufferedImage findDrawable(String src) {
        if (this.getDrawableDirectory() == null) {
            return null;
        }
        int ix = src.indexOf("/");
        String file = src.substring(ix + 1);
        File f = new File(this.getDrawableDirectory(), String.valueOf(file) + ".png");
        if (!f.exists()) {
            f = new File(this.getDrawableDirectory(), String.valueOf(file) + ".bmp");
        }
        if (!f.exists()) {
            f = new File(this.getDrawableDirectory(), String.valueOf(file) + ".jpg");
        }
        if (!f.exists()) {
            return null;
        }
        try {
            return ImageIO.read(f);
        }
        catch (IOException ex) {
            this.error(ex);
            return null;
        }
    }

    public Hashtable<String, String> getStrings() {
        return this.strings;
    }

    public void setStrings(Hashtable<String, String> strings) {
        this.strings = strings;
    }

    public File getStringFile() {
        return this.stringFile;
    }

    public void setStrings(File f) {
        try {
            this.setStrings(StringHandler.load(new FileInputStream(f)));
            this.stringFile = f;
        }
        catch (IOException ex) {
            this.error(ex);
        }
        catch (SAXException ex) {
            this.error(ex);
        }
        catch (ParserConfigurationException ex) {
            this.error(ex);
        }
    }

    public File getColorFile() {
        return this.colorFile;
    }

    public void setColors(File f) {
        try {
            this.setColors(ColorHandler.load(new FileInputStream(f)));
            this.colorFile = f;
        }
        catch (IOException ex) {
            this.error(ex);
        }
        catch (SAXException ex) {
            this.error(ex);
        }
        catch (ParserConfigurationException ex) {
            this.error(ex);
        }
    }

    public Hashtable<String, Color> getColors() {
        return this.colors;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this.viewer, message, "Error", 2);
    }

    public void error(Exception ex) {
        this.error(ex.getMessage());
        ex.printStackTrace();
    }

    public void message(String title, String message) {
        JOptionPane.showMessageDialog(this.viewer, message, title, 1);
    }

    public void setColors(Hashtable<String, Color> colors) {
        for (String key : colors.keySet()) {
            colors.put(key, colors.get(key));
        }
    }

    public static AndroidEditor instance() {
        if (inst == null) {
            inst = new AndroidEditor();
        }
        return inst;
    }

    public ScreenMode getScreenMode() {
        return this.screen;
    }

    public void setScreenMode(ScreenMode mode) {
        this.screen = mode;
        if (this.screen == ScreenMode.QVGA_LANDSCAPE) {
            this.sx = 320;
            this.sy = 240;
        } else if (this.screen == ScreenMode.QVGA_PORTRAIT) {
            this.sx = 240;
            this.sy = 320;
        } else if (this.screen == ScreenMode.HVGA_LANDSCAPE) {
            this.sx = 480;
            this.sy = 320;
        } else if (this.screen == ScreenMode.HVGA_PORTRAIT) {
            this.sx = 320;
            this.sy = 480;
        } else if (this.screen == ScreenMode.WVGA_LANDSCAPE) {
            this.sx = 854;
            this.sy = 480;
        } else if (this.screen == ScreenMode.WVGA_PORTRAIT) {
            this.sx = 480;
            this.sy = 854;
        } else if (this.screen == ScreenMode.WVGA_LANDSCAPE) {
            this.sx = 854;
            this.sy = 480;
        } else if (this.screen == ScreenMode.WVGA_PORTRAIT) {
            this.sx = 480;
            this.sy = 854;
        }
        if (this.getLayout() != null) {
            this.getLayout().apply();
            for (Widget w : this.getLayout().getWidgets()) {
                w.apply();
            }
            this.getLayout().repositionAllWidgets();
        }
    }

    public int getScreenX() {
        return this.sx;
    }

    public int getScreenY() {
        return this.sy;
    }

    public void setViewer(Viewer v) {
        this.viewer = v;
        this.pp.setViewer(v);
    }

    public void setIdsFromLabels() {
        this.setIdsFromLabels(this.layout);
    }

    public void setIdsFromLabels(Layout l) {
        for (Widget w : l.getWidgets()) {
            if (w instanceof Layout) {
                this.setIdsFromLabels((Layout)w);
                continue;
            }
            Property p = w.getPropertyByAttName("android:text");
            if (p == null) continue;
            ((AbstractWidget)w).setId("@+id/" + ((StringProperty)p).getStringValue());
        }
    }

    public void setLayout(Layout l) {
        this.setLayout(l, true);
    }

    public void setLayout(Layout l, boolean fill) {
        if (fill) {
            l.setPropertyByAttName("android:layout_width", "fill_parent");
            l.setPropertyByAttName("android:layout_height", "fill_parent");
        }
        if (this.layout != null) {
            Vector<Widget> widgets = this.layout.getWidgets();
            for (Widget w : widgets) {
                l.addWidget(w);
            }
            this.layout.removeAllWidgets();
        }
        this.layout = l;
        if (l.getPropertyByAttName("xmlns:android") == null) {
            l.addProperty(new StringProperty("xmlns", "xmlns:android", "http://schemas.android.com/apk/res/android", false));
        }
        if (this.selected == null) {
            this.pp.setProperties(l.getProperties(), l);
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Widget getSelected() {
        return this.selected;
    }

    public void select(Widget w) {
        if (w == this.layout) {
            this.selected = null;
            this.pp.setProperties(this.layout.getProperties(), w);
        } else {
            this.selected = w;
        }
        if (w != null) {
            this.pp.setProperties(w.getProperties(), w);
        }
        this.pp.validate();
        this.pp.repaint();
    }

    public void removeWidget(Widget w) {
        if (w != null) {
            w.getParent().removeWidget(w);
            if (this.selected == w) {
                this.selected = null;
            }
            this.changed = true;
        }
    }

    public void removeAllWidgets() {
        this.layout.removeAllWidgets();
        this.selected = null;
        this.changed = true;
    }

    public Vector<Layout> findLayouts(int x, int y) {
        return this.findLayout(this.layout, x, y);
    }

    protected Vector<Layout> findLayout(Layout l, int x, int y) {
        Vector<Layout> res = new Vector<Layout>();
        if (l.clickedOn(x, y)) {
            for (Widget w : l.getWidgets()) {
                if (!(w instanceof Layout)) continue;
                Vector<Layout> tmp = this.findLayout((Layout)w, x, y);
                for (Layout lt : tmp) {
                    res.add(lt);
                }
            }
            res.add(l);
        }
        return res;
    }

    public Vector<Widget> findWidgets(int x, int y) {
        return this.findWidgets(this.layout, x, y);
    }

    public Vector<Widget> findWidgets(Layout l, int x, int y) {
        Vector<Widget> res = new Vector<Widget>();
        for (Widget w : l.getWidgets()) {
            if (!w.clickedOn(x, y)) continue;
            if (w instanceof Layout) {
                Vector<Widget> tmp = this.findWidgets((Layout)w, x, y);
                for (Widget wt : tmp) {
                    res.add(wt);
                }
            }
            res.add(w);
        }
        return res;
    }

    public void generateSource(PrintWriter pw, String pkg) {
        pw.println("package " + pkg + ";");
        pw.println("public class DroidDrawSetup {");
        pw.println("public static void setup(Context c) {");
        this.generateSource(this.layout, pw, pkg);
        pw.println("}");
        pw.println("}");
    }

    public void generateSource(Layout l, PrintWriter pw, String pkg) {
        for (Widget w : l.getWidgets()) {
            this.generateSource(w, pw, pkg);
        }
    }

    public void generateSource(Widget w, PrintWriter pw, String pkg) {
        StringProperty onClick;
        if (w instanceof Layout) {
            this.generateSource((Layout)w, pw, pkg);
        } else if (w instanceof Button && (onClick = (StringProperty)w.getPropertyByAttName("droiddraw:onClickListener")) != null && onClick.getStringValue() != null && onClick.getStringValue().length() > 0) {
            String id = w.getId();
            int ix = id.indexOf("/");
            id = id.substring(ix + 1);
            pw.println("View b" + id + " = context.findViewById(R.ids." + id + ";");
            pw.println("b" + id + ".setOnClickListener(new " + onClick.getStringValue() + "());");
        }
    }

    public void generate(PrintWriter pw) {
        pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.generateWidget(this.layout, pw);
        pw.flush();
    }

    public void generateWidget(Widget w, PrintWriter pw) {
        pw.println("<" + w.getTagName());
        Vector props = (Vector)w.getProperties().clone();
        if (w != this.layout) {
            w.getParent().addOutputProperties(w, props);
        }
        for (Property prop : props) {
            if (prop.getValue() == null || prop.getValue().toString().length() <= 0 || prop.isDefault() || w instanceof CheckBox && prop.getAtttributeName().equals("android:padding")) continue;
            String value = prop instanceof StringProperty ? StringEscapeUtils.escapeXml(((StringProperty)prop).getStringValue()) : prop.getValue().toString();
            pw.println(String.valueOf(prop.getAtttributeName()) + "=\"" + value + "\"");
        }
        pw.println(">");
        if (w instanceof Layout) {
            for (Widget wt : ((Layout)w).getWidgets()) {
                this.generateWidget(wt, pw);
            }
        }
        pw.println("</" + w.getTagName() + ">");
    }

    public void setURLOpener(URLOpener open) {
        this.opener = open;
    }

    public URLOpener getURLOpener() {
        return this.opener;
    }

    public File getArrayFile() {
        return this.arrayFile;
    }

    public void setArrayFile(File arrayFile) {
        this.arrayFile = arrayFile;
    }

    public Hashtable<String, Vector<String>> getArrays() {
        return this.arrays;
    }

    public void setArrays(Hashtable<String, Vector<String>> arrays) {
        this.arrays = arrays;
    }

    public void setArrays(File f) {
        this.setArrayFile(f);
        try {
            this.setArrays(ArrayHandler.load(new FileInputStream(f)));
        }
        catch (IOException ex) {
            this.error(ex);
        }
        catch (SAXException ex) {
            this.error(ex);
        }
        catch (ParserConfigurationException ex) {
            this.error(ex);
        }
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public Preferences getPreferences() {
        if (this.prefs == null) {
            this.prefs = new Preferences();
            try {
                this.prefs.load();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.prefs;
    }

    public void addWidget(Widget w, int x, int y) {
        this.viewer.addWidget(w, this.layout, x, y);
        this.queueUndoRecord(new WidgetAddRecord(this.layout, w));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScreenMode {
        QVGA_LANDSCAPE,
        QVGA_PORTRAIT,
        HVGA_LANDSCAPE,
        HVGA_PORTRAIT,
        WVGA_LANDSCAPE,
        WVGA_PORTRAIT;

    }
}

