/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.UIManager;
import org.droiddraw.AndroidEditor;
import org.droiddraw.URLOpener;
import org.droiddraw.gui.DroidDrawPanel;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.gui.LayoutPainter;
import org.droiddraw.gui.ScrollViewPainter;
import org.droiddraw.gui.WidgetRegistry;
import org.droiddraw.widget.AbstractLayout;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.ScrollView;

public class DroidDraw
extends JApplet
implements URLOpener {
    private static final long serialVersionUID = 1L;
    MediaTracker md;
    int ix;

    protected static final void switchToLookAndFeel(String clazz) {
        try {
            UIManager.setLookAndFeel(clazz);
        }
        catch (Exception ex) {
            AndroidEditor.instance().error(ex);
        }
    }

    public void openURL(String url) {
        try {
            this.getAppletContext().showDocument(new URL(url), "_blank");
        }
        catch (MalformedURLException ex) {
            AndroidEditor.instance().error(ex);
        }
    }

    protected static final void setupRootLayout(Layout l) {
        l.setPosition(AndroidEditor.OFFSET_X, AndroidEditor.OFFSET_Y);
        l.setPropertyByAttName("android:layout_width", "fill_parent");
        l.setPropertyByAttName("android:layout_height", "fill_parent");
        l.apply();
    }

    protected void loadImage(String name) {
        Image img = this.getImage(this.getCodeBase(), "ui/" + name + ".png");
        this.md.addImage(img, this.ix++);
        ImageResources.instance().addImage(img, name);
    }

    public void init() {
        super.init();
        AndroidEditor.instance().setURLOpener(this);
        AndroidEditor.instance().getPropertiesPanel().setApplet(true);
        String screen = this.getParameter("Screen");
        if (screen == null) {
            screen = "hvgap";
        }
        this.md = new MediaTracker(this);
        this.ix = 0;
        this.loadImage("emu1");
        this.loadImage("emu2");
        this.loadImage("emu3");
        this.loadImage("emu4");
        this.loadImage("emu5");
        this.loadImage("emu6");
        this.loadImage("paint");
        this.loadImage("droiddraw_small");
        this.loadImage("paypal");
        this.loadImage("background_01p");
        this.loadImage("background_01l");
        this.loadImage("statusbar_background_p");
        this.loadImage("statusbar_background_l");
        this.loadImage("rate_star_big_on");
        this.loadImage("rate_star_med_on");
        this.loadImage("rate_star_small_on");
        this.loadImage("title_bar.9");
        this.loadImage("stat_sys_data_connected");
        this.loadImage("stat_sys_battery_charge_100");
        this.loadImage("stat_sys_signal_3");
        this.loadImage("mapview");
        this.loadImage("scrollbar.9");
        this.loadImage("scrollfield.9");
        this.loadImage("light/checkbox_off_background");
        this.loadImage("light/checkbox_on_background");
        this.loadImage("light/clock_dial");
        this.loadImage("light/clock_hand_hour");
        this.loadImage("light/clock_hand_minute");
        this.loadImage("light/radiobutton_off_background");
        this.loadImage("light/radiobutton_on_background");
        this.loadImage("light/button_background_normal.9");
        this.loadImage("light/editbox_background_normal.9");
        this.loadImage("light/progress_circular_background");
        this.loadImage("light/progress_particle");
        this.loadImage("light/progress_circular_indeterminate");
        this.loadImage("light/arrow_up_float");
        this.loadImage("light/arrow_down_float");
        this.loadImage("light/spinnerbox_background_focus_yellow.9");
        this.loadImage("light/spinnerbox_arrow_middle.9");
        this.loadImage("def/btn_check_off");
        this.loadImage("def/btn_check_on");
        this.loadImage("def/btn_radio_off");
        this.loadImage("def/btn_radio_on");
        this.loadImage("def/textfield.9");
        this.loadImage("def/btn_default_normal.9");
        this.loadImage("def/progress_wheel_medium");
        this.loadImage("def/spinner_normal.9");
        this.loadImage("def/tab_selected.9");
        this.loadImage("def/btn_dropdown_neither.9");
        this.loadImage("mdpi/textfield_default.9");
        int i = 0;
        while (i < this.ix) {
            try {
                this.md.waitForID(i);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        WidgetRegistry.registerPainter(AbstractLayout.class, new LayoutPainter());
        WidgetRegistry.registerPainter(ScrollView.class, new ScrollViewPainter());
        this.setLayout(new BorderLayout());
        this.setSize(1024, 650);
        this.add((Component)new DroidDrawPanel(screen, true), "Center");
    }
}

