/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.droiddraw.AndroidEditor;
import org.droiddraw.URLOpener;
import org.droiddraw.gui.DroidDrawPanel;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.gui.LayoutPainter;
import org.droiddraw.gui.Preferences;
import org.droiddraw.gui.PreferencesPanel;
import org.droiddraw.gui.ScrollViewPainter;
import org.droiddraw.gui.WidgetDeleteRecord;
import org.droiddraw.gui.WidgetRegistry;
import org.droiddraw.util.FileFilterExtension;
import org.droiddraw.util.LayoutUploader;
import org.droiddraw.widget.AbstractLayout;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.ScrollView;
import org.droiddraw.widget.Widget;
import org.droiddraw.widget.WidgetTransferable;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;

public class Main
implements ApplicationListener,
URLOpener {
    static File saveFile = null;
    static JFrame jf;
    static DroidDrawPanel ddp;
    static JFileChooser jfc;
    static FileDialog fd;
    public static boolean osx;
    static FileFilterExtension xmlFilter;
    static FileFilter dirFilter;
    static FileFilter imgFilter;
    public static final int BUFFER = 4096;

    static {
        jfc = null;
        fd = null;
        xmlFilter = null;
        dirFilter = null;
        imgFilter = null;
    }

    protected static void doMacOSXIntegration() {
        DefaultApplication a = new DefaultApplication();
        a.addApplicationListener(new Main());
    }

    protected static void open(String file) {
        Main.open(new File(file));
    }

    protected static void open(File f) {
        ddp.open(f);
        saveFile = f;
    }

    protected static void quit() {
        Main.quit(true);
    }

    protected static void quit(boolean cancelable) {
        if (AndroidEditor.instance().isChanged()) {
            int opt = JOptionPane.showConfirmDialog(ddp, "Do you wish to save changes to your layout?", "Unsaved Changes", cancelable ? 1 : 0);
            switch (opt) {
                case 2: {
                    return;
                }
                case 0: {
                    if (Main.doSave()) break;
                    return;
                }
            }
        }
        System.exit(0);
    }

    protected static void preferences() {
        JFrame jf = new JFrame();
        jf.getContentPane().add(new PreferencesPanel(AndroidEditor.instance().getPreferences(), jf));
        jf.pack();
        jf.setVisible(true);
    }

    protected static void about() {
        final JDialog jd = new JDialog((Frame)jf, "About DroidDraw");
        jd.getContentPane().setLayout(new BorderLayout());
        jd.getContentPane().add((Component)new JLabel(new ImageIcon(ImageResources.instance().getImage("droiddraw_small"))), "Center");
        jd.pack();
        jd.setResizable(false);
        jd.setLocationRelativeTo(null);
        jd.setVisible(true);
        jd.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                jd.setVisible(false);
                jd.dispose();
            }
        });
    }

    public static void doClear(boolean confirm) {
        int res = 0;
        if (confirm) {
            res = JOptionPane.showConfirmDialog(jf, "This will delete your entire GUI.  Proceed?", "Clear Screen?", 0);
        }
        if (res == 0) {
            ddp.clear();
            ddp.repaint();
        }
    }

    public static File doOpen() {
        return Main.doOpen(null);
    }

    public static File doOpen(File file) {
        return Main.doOpen(file, xmlFilter);
    }

    public static File doOpenImage(File file) {
        return Main.doOpen(file, imgFilter);
    }

    private static File doOpen(File file, FileFilter filter) {
        if (!osx) {
            int res;
            jfc.setFileSelectionMode(2);
            jfc.setFileFilter(filter);
            if (file != null) {
                if (file.isDirectory()) {
                    jfc.setCurrentDirectory(file);
                } else {
                    jfc.setCurrentDirectory(file.getParentFile());
                }
            }
            if ((res = jfc.showOpenDialog(ddp)) == 0) {
                return jfc.getSelectedFile();
            }
        } else {
            fd.setMode(0);
            if (file != null) {
                try {
                    if (file.isDirectory()) {
                        fd.setDirectory(file.getCanonicalPath());
                    } else {
                        fd.setDirectory(file.getParentFile().getCanonicalPath());
                    }
                }
                catch (IOException ex) {
                    AndroidEditor.instance().error(ex);
                }
            }
            fd.setVisible(true);
            if (fd.getDirectory() != null && fd.getFile() != null) {
                return new File(String.valueOf(fd.getDirectory()) + "/" + fd.getFile());
            }
        }
        return null;
    }

    public static File doOpenDir() {
        jfc.setFileFilter(dirFilter);
        jfc.setFileSelectionMode(1);
        int res = jfc.showOpenDialog(ddp);
        if (res == 0) {
            return jfc.getSelectedFile();
        }
        return null;
    }

    public static File doSaveBasic() {
        int res;
        File f = null;
        if (!osx) {
            res = jfc.showSaveDialog(ddp);
            if (res == 0) {
                String extension;
                f = jfc.getSelectedFile();
                FileFilter ff = jfc.getFileFilter();
                if (FileFilterExtension.class.isInstance(ff) && (extension = ((FileFilterExtension)ff).getExtension()).length() > 0 && !f.getName().endsWith(extension)) {
                    f = new File(String.valueOf(f.getAbsolutePath()) + "." + extension);
                }
            }
        } else {
            fd.setMode(1);
            fd.setVisible(true);
            if (fd.getFile() != null) {
                f = new File(String.valueOf(fd.getDirectory()) + "/" + fd.getFile());
            }
        }
        if (f != null && f.exists() && (res = JOptionPane.showConfirmDialog(ddp, String.valueOf(f.getName()) + " exists. Overwrite?", "Overwrite", 2)) == 2) {
            return null;
        }
        return f;
    }

    protected static boolean doSave() {
        File f = Main.doSaveBasic();
        if (f != null) {
            jf.setTitle("DroidDraw: " + f.getName());
            ddp.save(f);
            saveFile = f;
            return true;
        }
        return false;
    }

    protected static void loadImage(String name) throws IOException {
        URL u = ClassLoader.getSystemClassLoader().getResource("ui/" + name + ".png");
        if (u == null) {
            AndroidEditor.instance().error("Couldn't open image : " + name);
            return;
        }
        InputStream is = u.openStream();
        BufferedImage img = ImageIO.read(is);
        ImageResources.instance().addImage(img, name);
    }

    protected static void makeAPK2(File dir, boolean install) {
        String pathToAndroid = "/Users/bburns/devel/android-sdk-mac/";
        File f = new File(String.valueOf(pathToAndroid) + File.pathSeparator + "tools" + File.pathSeparator + "android");
    }

    protected static void makeAPK(File dir, boolean install) throws IOException {
        String[] stringArray;
        ZipEntry entry;
        URL u = ClassLoader.getSystemClassLoader().getResource("data/activity.zip");
        if (u == null) {
            AndroidEditor.instance().error("Couldn't open activity.zip");
            return;
        }
        InputStream is = u.openStream();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            byte[] data = new byte[4096];
            if (entry.isDirectory()) {
                File f = new File(dir, entry.getName());
                f.mkdir();
                continue;
            }
            FileOutputStream fos = new FileOutputStream(new File(dir, entry.getName()));
            BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);
            while ((count = zis.read(data, 0, 4096)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zis.close();
        if (install) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "ant";
            stringArray = stringArray2;
            stringArray2[1] = "install";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "ant";
        }
        String[] cmd = stringArray;
        File wd = new File(dir, "activity");
        Main.run(cmd, wd);
        File res = new File(wd, "res");
        res = new File(res, "layout");
        res = new File(res, "main.xml");
        PrintWriter pw = new PrintWriter(new FileWriter(res));
        AndroidEditor.instance().generate(pw);
        pw.flush();
        pw.close();
    }

    private static boolean run(String[] cmd, File workingDirectory) throws IOException {
        Process p = Runtime.getRuntime().exec(cmd, null, workingDirectory);
        try {
            int ret = p.waitFor();
            if (ret != 0) {
                InputStream input = p.getErrorStream();
                byte[] buff = new byte[4096];
                int i = input.read(buff);
                while (i != -1) {
                    System.err.write(buff, 0, i);
                    i = input.read(buff);
                }
                input = p.getInputStream();
                i = input.read(buff);
                while (i != -1) {
                    System.out.write(buff, 0, i);
                    i = input.read(buff);
                }
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public static void copy(File from, File to) throws IOException {
        FileInputStream fis = new FileInputStream(from);
        FileOutputStream fos = new FileOutputStream(to);
        byte[] buffer = new byte[4096];
        int rd = fis.read(buffer);
        while (rd != -1) {
            fos.write(buffer, 0, rd);
            rd = fis.read(buffer);
        }
        fos.flush();
        fos.close();
    }

    public static void main(String[] args) throws IOException {
        int res;
        AndroidEditor.instance().setURLOpener(new Main());
        osx = System.getProperty("os.name").toLowerCase().contains("mac os x");
        if (osx) {
            Main.doMacOSXIntegration();
        }
        Preferences prefs = AndroidEditor.instance().getPreferences();
        boolean checkUpdate = false;
        if (prefs.getUpdateCheck() == Preferences.Update.YES) {
            checkUpdate = true;
        } else if (prefs.getUpdateCheck() == Preferences.Update.ASK) {
            res = JOptionPane.showConfirmDialog(null, "Check for updates to DroidDraw?", "Update?", 0);
            boolean bl = checkUpdate = res == 0;
        }
        if (checkUpdate && !AndroidEditor.instance().isLatestVersion() && (res = JOptionPane.showConfirmDialog(ddp, "There is a new DroidDraw version available. Do you wish to download it?", "DroidDraw Update", 0)) == 0) {
            AndroidEditor.instance().getURLOpener().openURL("http://code.google.com/p/droiddraw/downloads/list");
        }
        Main.loadImage("emu1");
        Main.loadImage("emu2");
        Main.loadImage("emu3");
        Main.loadImage("emu4");
        Main.loadImage("paint");
        Main.loadImage("droiddraw_small");
        Main.loadImage("paypal");
        Main.loadImage("background_01p");
        Main.loadImage("background_01l");
        Main.loadImage("statusbar_background_p");
        Main.loadImage("statusbar_background_l");
        Main.loadImage("title_bar.9");
        Main.loadImage("stat_sys_data_connected");
        Main.loadImage("stat_sys_battery_charge_100");
        Main.loadImage("stat_sys_signal_3");
        Main.loadImage("scrollbar.9");
        Main.loadImage("scrollfield.9");
        Main.loadImage("mapview");
        Main.loadImage("rate_star_big_on");
        Main.loadImage("rate_star_med_on");
        Main.loadImage("rate_star_small_on");
        Main.loadImage("light/checkbox_off_background");
        Main.loadImage("light/checkbox_on_background");
        Main.loadImage("light/clock_dial");
        Main.loadImage("light/clock_hand_hour");
        Main.loadImage("light/clock_hand_minute");
        Main.loadImage("light/radiobutton_off_background");
        Main.loadImage("light/radiobutton_on_background");
        Main.loadImage("light/button_background_normal.9");
        Main.loadImage("light/editbox_background_normal.9");
        Main.loadImage("light/progress_circular_background");
        Main.loadImage("light/progress_particle");
        Main.loadImage("light/progress_circular_indeterminate");
        Main.loadImage("light/arrow_up_float");
        Main.loadImage("light/arrow_down_float");
        Main.loadImage("light/spinnerbox_background_focus_yellow.9");
        Main.loadImage("light/spinnerbox_arrow_middle.9");
        Main.loadImage("def/btn_check_off");
        Main.loadImage("def/btn_check_on");
        Main.loadImage("def/btn_radio_off");
        Main.loadImage("def/btn_radio_on");
        Main.loadImage("def/textfield.9");
        Main.loadImage("def/btn_default_normal.9");
        Main.loadImage("def/progress_wheel_medium");
        Main.loadImage("def/spinner_normal.9");
        Main.loadImage("def/btn_dropdown_neither.9");
        Main.loadImage("def/tab_selected.9");
        Main.loadImage("mdpi/textfield_default.9");
        jf = new JFrame("DroidDraw");
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Main.quit(false);
            }
        });
        WidgetRegistry.registerPainter(ScrollView.class, new ScrollViewPainter());
        WidgetRegistry.registerPainter(AbstractLayout.class, new LayoutPainter());
        String screen = "hvgap";
        AndroidEditor.ScreenMode scr = prefs.getScreenMode();
        if (scr.equals((Object)AndroidEditor.ScreenMode.HVGA_LANDSCAPE)) {
            screen = "hvgal";
        } else if (scr.equals((Object)AndroidEditor.ScreenMode.QVGA_LANDSCAPE)) {
            screen = "qvgal";
        } else if (scr.equals((Object)AndroidEditor.ScreenMode.QVGA_PORTRAIT)) {
            screen = "qvgap";
        } else if (scr.equals((Object)AndroidEditor.ScreenMode.WVGA_LANDSCAPE)) {
            screen = "wvgal";
        } else if (scr.equals((Object)AndroidEditor.ScreenMode.WVGA_PORTRAIT)) {
            screen = "wvgap";
        }
        ddp = new DroidDrawPanel(screen, false);
        AndroidEditor.instance().setScreenMode(prefs.getScreenMode());
        fd = new FileDialog(jf);
        jfc = new JFileChooser();
        xmlFilter = new FileFilterExtension("xml", "Android Layout file (.xml)");
        dirFilter = new FileFilter(){

            public boolean accept(File arg) {
                return arg.isDirectory();
            }

            public String getDescription() {
                return "Directory";
            }
        };
        imgFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".png") || f.getName().endsWith(".jpg") || f.getName().endsWith(".jpeg") || f.getName().endsWith(".gif");
            }

            public String getDescription() {
                return "Image file (*.png, *.jpg, *.jpeg, *.gif)";
            }
        };
        jfc.setFileFilter(xmlFilter);
        int ctl_key = 2;
        if (osx) {
            ctl_key = 4;
        }
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem it = new JMenuItem("New");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.doClear(false);
            }
        });
        it.setAccelerator(KeyStroke.getKeyStroke(78, ctl_key));
        menu.add(it);
        it = new JMenuItem("Open");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Main.open(Main.doOpen());
            }
        });
        it.setAccelerator(KeyStroke.getKeyStroke(79, ctl_key));
        menu.add(it);
        menu.addSeparator();
        it = new JMenuItem("Save");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (saveFile == null) {
                    Main.doSave();
                } else {
                    ddp.save(saveFile);
                }
            }
        });
        it.setAccelerator(KeyStroke.getKeyStroke(83, ctl_key));
        menu.add(it);
        it = new JMenuItem("Save As...");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Main.doSave();
            }
        });
        menu.add(it);
        it = new JMenuItem("Export as .apk");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String tmpFile = System.getProperty("java.io.tmpdir");
                File f = new File(tmpFile);
                if (f != null) {
                    try {
                        Main.makeAPK(f, false);
                        File save = Main.doOpenDir();
                        File apk = new File(f, "activity");
                        apk = new File(apk, "bin");
                        apk = new File(apk, "DroidDrawActivity.apk");
                        save = new File(save, "DroidDrawActivity.apk");
                        Main.copy(apk, save);
                        AndroidEditor.instance().message("Saved", "Layout saved as " + save.getCanonicalPath());
                    }
                    catch (IOException ex) {
                        AndroidEditor.instance().error(ex);
                    }
                }
            }
        });
        menu.add(it);
        it = new JMenuItem("Export to device");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String tmpFile = System.getProperty("java.io.tmpdir");
                File f = new File(tmpFile);
                if (f.exists()) {
                    try {
                        Main.makeAPK(f, true);
                        AndroidEditor.instance().message("Installed", "Layout successfully installed.");
                    }
                    catch (IOException ex) {
                        AndroidEditor.instance().error(ex);
                    }
                } else {
                    AndroidEditor.instance().error("Error generating .apk");
                }
            }
        });
        menu.add(it);
        if (!osx) {
            it = new JMenuItem("Preferences");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Main.preferences();
                }
            });
            menu.add(it);
            menu.addSeparator();
            it = new JMenuItem("Quit");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    Main.quit();
                }
            });
            it.setAccelerator(KeyStroke.getKeyStroke(81, ctl_key));
            menu.add(it);
        }
        mb.add(menu);
        menu = new JMenu("Edit");
        it = new JMenuItem("Undo");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AndroidEditor.instance().undo();
            }
        });
        it.setAccelerator(KeyStroke.getKeyStroke(90, ctl_key));
        menu.add(it);
        it = new JMenuItem("Redo");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AndroidEditor.instance().redo();
            }
        });
        it.setAccelerator(KeyStroke.getKeyStroke(89, ctl_key));
        menu.add(it);
        it = new JMenuItem("Cut");
        Main.addCutAction(it);
        it.setAccelerator(KeyStroke.getKeyStroke(88, ctl_key));
        menu.add(it);
        it = new JMenuItem("Copy");
        Main.addCopyAction(it);
        it.setAccelerator(KeyStroke.getKeyStroke(67, ctl_key));
        menu.add(it);
        it = new JMenuItem("Paste");
        Main.addPasteAction(it);
        it.setAccelerator(KeyStroke.getKeyStroke(86, ctl_key));
        menu.add(it);
        menu.addSeparator();
        it = new JMenuItem("Select All");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ddp.selectAll();
            }
        });
        it.setAccelerator(KeyStroke.getKeyStroke(65, ctl_key));
        menu.add(it);
        menu.addSeparator();
        it = new JMenuItem("Clear Screen");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Main.doClear(true);
            }
        });
        menu.add(it);
        it = new JMenuItem("Set Ids from Labels");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AndroidEditor.instance().setIdsFromLabels();
            }
        });
        menu.add(it);
        mb.add(menu);
        menu = new JMenu("Project");
        it = new JMenuItem("Load string resources");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                File f = Main.doOpen();
                if (f != null) {
                    AndroidEditor.instance().setStrings(f);
                }
            }
        });
        menu.add(it);
        it = new JMenuItem("Load color resources");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                File f = Main.doOpen();
                if (f != null) {
                    AndroidEditor.instance().setColors(f);
                }
            }
        });
        menu.add(it);
        it = new JMenuItem("Load array resources");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                File f = Main.doOpen();
                if (f != null) {
                    AndroidEditor.instance().setArrays(f);
                }
            }
        });
        menu.add(it);
        it = new JMenuItem("Set drawables directory");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                File f = Main.doOpenDir();
                if (f != null) {
                    AndroidEditor.instance().setDrawableDirectory(f);
                }
            }
        });
        menu.add(it);
        menu.addSeparator();
        it = new JMenuItem("Load resource directory");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                File f = Main.doOpenDir();
                if (f != null) {
                    File drawable = new File(f, "drawable");
                    if (drawable.exists() && drawable.isDirectory()) {
                        AndroidEditor.instance().setDrawableDirectory(f);
                    }
                    if ((f = new File(f, "values")).exists() && f.isDirectory()) {
                        File arrays;
                        File colors;
                        File strings = new File(f, "strings.xml");
                        if (strings.exists()) {
                            AndroidEditor.instance().setStrings(strings);
                        }
                        if ((colors = new File(f, "colors.xml")).exists()) {
                            AndroidEditor.instance().setColors(colors);
                        }
                        if ((arrays = new File(f, "arrays.xml")).exists()) {
                            AndroidEditor.instance().setArrays(arrays);
                        }
                    }
                }
            }
        });
        menu.add(it);
        menu.addSeparator();
        it = new JMenuItem("Send GUI to device");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    ByteArrayOutputStream ba = new ByteArrayOutputStream();
                    PrintWriter pw = new PrintWriter(ba);
                    AndroidEditor.instance().generate(pw);
                    pw.flush();
                    ba.flush();
                    if (LayoutUploader.upload("127.0.0.1", 6100, (InputStream)new ByteArrayInputStream(ba.toByteArray()))) {
                        JOptionPane.showMessageDialog(jf, "Upload succeeded");
                    } else {
                        JOptionPane.showMessageDialog(jf, "Upload failed.  Is AnDroidDraw running?");
                    }
                }
                catch (IOException ex) {
                    AndroidEditor.instance().error(ex);
                }
            }
        });
        it.setAccelerator(KeyStroke.getKeyStroke(68, ctl_key));
        menu.add(it);
        mb.add(menu);
        menu = new JMenu("Help");
        it = new JMenuItem("Tutorial");
        it.setAccelerator(KeyStroke.getKeyStroke(72, ctl_key));
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher l = new BrowserLauncher();
                    l.openURLinBrowser("http://www.droiddraw.org/tutorial.html");
                }
                catch (UnsupportedOperatingSystemException ex) {
                    AndroidEditor.instance().error(ex);
                }
                catch (BrowserLaunchingInitializingException ex) {
                    AndroidEditor.instance().error(ex);
                }
            }
        });
        menu.add(it);
        if (!osx) {
            it = new JMenuItem("About");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    Main.about();
                }
            });
            menu.add(it);
        }
        it = new JMenuItem("Donate");
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher l = new BrowserLauncher();
                    l.openURLinBrowser("https://www.paypal.com/us/cgi-bin/webscr?cmd=_xclick&business=brendan.d.burns@gmail.com&item_name=Support%20DroidDraw&currency_code=USD");
                }
                catch (UnsupportedOperatingSystemException ex) {
                    AndroidEditor.instance().error(ex);
                }
                catch (BrowserLaunchingInitializingException ex) {
                    AndroidEditor.instance().error(ex);
                }
            }
        });
        menu.add(it);
        mb.add(menu);
        jf.setJMenuBar(mb);
        jf.getContentPane().add(ddp);
        jf.pack();
        jf.setVisible(true);
    }

    public static void addPasteAction(JMenuItem it) {
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (ddp != null && ddp.hasFocus()) {
                    try {
                        String txt = (String)c.getData(DataFlavor.stringFlavor);
                        if (txt != null) {
                            ddp.insertText(txt);
                        }
                    }
                    catch (UnsupportedFlavorException txt) {
                    }
                    catch (IOException txt) {}
                } else {
                    DataFlavor flavor = new DataFlavor(Widget.class, "DroidDraw Widget");
                    if (c.isDataFlavorAvailable(flavor)) {
                        try {
                            Widget w = (Widget)c.getData(flavor);
                            if (w != null) {
                                AndroidEditor.instance().addWidget(w, 50, 50);
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (UnsupportedFlavorException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public static void addCopyAction(JMenuItem it) {
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (ddp.hasFocus()) {
                    if (ddp.getSelectedText() != null && ddp.getSelectedText().length() != 0) {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ddp.getSelectedText()), null);
                    }
                } else {
                    Widget w = AndroidEditor.instance().getSelected();
                    if (w != null) {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new WidgetTransferable(w), null);
                    }
                }
            }
        });
    }

    public static void addCutAction(JMenuItem it) {
        it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (ddp.hasFocus()) {
                    String txt = ddp.getSelectedText();
                    ddp.deleteSelectedText();
                    Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                    c.setContents(new StringSelection(txt), null);
                } else {
                    Widget w = AndroidEditor.instance().getSelected();
                    if (w != null) {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new WidgetTransferable(w), null);
                        AndroidEditor.instance().removeWidget(w);
                        Layout l = w.getParent();
                        AndroidEditor.instance().queueUndoRecord(new WidgetDeleteRecord(l, w));
                        AndroidEditor.instance().viewer.repaint();
                    }
                }
            }
        });
    }

    public void handleAbout(ApplicationEvent ev) {
        Main.about();
        ev.setHandled(true);
    }

    public void handleOpenApplication(ApplicationEvent arg0) {
    }

    public void handleOpenFile(ApplicationEvent ev) {
        String f = ev.getFilename();
        if (f.endsWith(".xml")) {
            Main.open(ev.getFilename());
            ev.setHandled(true);
        }
    }

    public void handlePreferences(ApplicationEvent arg0) {
        Main.preferences();
    }

    public void handlePrintFile(ApplicationEvent arg0) {
    }

    public void handleQuit(ApplicationEvent arg0) {
        Main.quit();
    }

    public void handleReopenApplication(ApplicationEvent arg0) {
    }

    public void openURL(String url) {
        try {
            BrowserLauncher l = new BrowserLauncher();
            l.openURLinBrowser(url);
        }
        catch (UnsupportedOperatingSystemException ex) {
            AndroidEditor.instance().error(ex);
        }
        catch (BrowserLaunchingInitializingException ex) {
            AndroidEditor.instance().error(ex);
        }
    }
}

