/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Dimension d = new Dimension(500, 300);
    JTable dataTable;
    JButton save;
    JButton create;
    JButton delete;
    DataTableModel model;

    public AbstractDataPanel(Class<?>[] classes) {
        this.model = new DataTableModel(classes);
        this.dataTable = new JTable(this.model);
        this.dataTable.setShowHorizontalLines(true);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.dataTable), "Center");
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        JButton save = new JButton("Save");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractDataPanel.this.doSave();
            }
        });
        JButton create = new JButton("New");
        create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(AbstractDataPanel.this.dataTable, (Object)"Enter a name for this new value:");
                if (name != null) {
                    AbstractDataPanel.this.addValue(name);
                    AbstractDataPanel.this.model.fireTableDataChanged();
                }
            }
        });
        JButton delete = new JButton("Delete");
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = AbstractDataPanel.this.dataTable.getSelectedRow();
                AbstractDataPanel.this.model.deleteRow(row);
            }
        });
        jp.add(save);
        jp.add(create);
        jp.add(delete);
        this.add((Component)jp, "South");
    }

    @Override
    public Dimension getPreferredSize() {
        return this.d;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.d;
    }

    protected abstract int parentRowCount();

    protected abstract Object parentValueAt(int var1, int var2);

    protected abstract void parentSetValueAt(Object var1, int var2, int var3);

    protected abstract void parentDeleteRow(int var1);

    protected abstract void doSave();

    protected abstract void addValue(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private Class<?>[] classes;

        public DataTableModel(Class<?>[] classes) {
            this.classes = classes;
        }

        @Override
        public int getColumnCount() {
            return this.classes.length;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.classes[col];
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Name";
            }
            return "Value";
        }

        @Override
        public int getRowCount() {
            return AbstractDataPanel.this.parentRowCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return AbstractDataPanel.this.parentValueAt(row, col);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            AbstractDataPanel.this.parentSetValueAt(value, rowIndex, columnIndex);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void deleteRow(int row) {
            AbstractDataPanel.this.parentDeleteRow(row);
            this.fireTableDataChanged();
        }
    }
}

