/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.droiddraw.AndroidEditor;
import org.droiddraw.Main;
import org.droiddraw.gui.AbstractDataPanel;
import org.droiddraw.util.ArrayHandler;

public class ArrayPanel
extends AbstractDataPanel {
    private static final long serialVersionUID = 1L;

    public ArrayPanel() {
        super(new Class[]{String.class, String.class});
    }

    protected void addValue(String name) {
        AndroidEditor.instance().getArrays().put(name, new Vector());
    }

    protected void doSave() {
        File f = AndroidEditor.instance().getArrayFile();
        try {
            if (f == null) {
                f = Main.doSaveBasic();
            }
            if (f != null) {
                FileWriter fw = new FileWriter(f);
                ArrayHandler.dump(fw, AndroidEditor.instance().getArrays());
                fw.flush();
                fw.close();
            }
        }
        catch (IOException ex) {
            AndroidEditor.instance().error(ex);
        }
    }

    protected void parentDeleteRow(int row) {
        String key = (String)this.parentValueAt(row, 0);
        Hashtable<String, Vector<String>> arrays = AndroidEditor.instance().getArrays();
        arrays.remove(key);
    }

    protected int parentRowCount() {
        Hashtable<String, Vector<String>> arrays = AndroidEditor.instance().getArrays();
        return arrays.size();
    }

    protected void parentSetValueAt(Object value, int rowIndex, int columnIndex) {
        String key = (String)this.parentValueAt(rowIndex, 0);
        Hashtable<String, Vector<String>> arrays = AndroidEditor.instance().getArrays();
        if (columnIndex == 1) {
            String val = (String)value;
            Vector<String> data = arrays.get(key);
            data.clear();
            StringTokenizer tok = new StringTokenizer(val, ",");
            while (tok.hasMoreTokens()) {
                data.add(tok.nextToken());
            }
            arrays.put(key, data);
        } else {
            Vector<String> val = arrays.get(key);
            arrays.remove(key);
            arrays.put((String)value, val);
        }
    }

    protected Object parentValueAt(int row, int col) {
        Hashtable<String, Vector<String>> arrays = AndroidEditor.instance().getArrays();
        ArrayList<String> sorted = Collections.list(arrays.keys());
        Collections.sort(sorted);
        if (col == 0) {
            return sorted.get(row);
        }
        if (col == 1) {
            Vector<String> data = arrays.get(sorted.get(row));
            String res = "";
            if (data.size() > 0) {
                res = data.get(0);
                int i = 1;
                while (i < data.size()) {
                    res = String.valueOf(res) + "," + data.get(i);
                    ++i;
                }
            }
            return res;
        }
        return null;
    }
}

