/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.droiddraw.AndroidEditor;
import org.droiddraw.gui.JAutoComboBox;
import org.droiddraw.property.ColorProperty;

public class ColorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JButton jb;
    JTextField jt;
    JAutoComboBox jac;
    BufferedImage img;
    Color c;
    static JDialog jd;
    static JColorChooser jcc;
    static Color sc;

    public ColorPanel(Color clr) {
        this.c = clr;
        this.img = new BufferedImage(20, 20, 6);
        Graphics g = this.img.getGraphics();
        g.setColor(this.c);
        g.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
        this.jb = new JButton(new ImageIcon(this.img));
        Vector<String> colors = new Vector<String>();
        colors.add("");
        for (String key : AndroidEditor.instance().getColors().keySet()) {
            colors.add("@color/" + key);
        }
        this.jt = new JTextField();
        this.jac = new JAutoComboBox((List<String>)colors);
        this.jac.setEditable(true);
        this.jac.setStrict(false);
        this.jac.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                System.out.println(ColorPanel.this.jac.getSelectedItem().toString());
                Color c = ColorProperty.parseColor(ColorPanel.this.jac.getSelectedItem().toString());
                if (c != null) {
                    ColorPanel.this.setColor(c);
                }
            }
        });
        this.jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Color nc = ColorPanel.chooseColor();
                if (nc != null) {
                    ColorPanel.this.setColor(nc);
                    String colorString = ColorProperty.makeColor(nc);
                    ColorPanel.this.jac.addItem(colorString);
                    ColorPanel.this.jac.setSelectedItem(colorString);
                }
            }
        });
        this.add(this.jac);
        this.add(this.jb);
    }

    public void setColor(Color nc) {
        System.out.println(nc);
        Graphics g = this.img.getGraphics();
        g.setColor(nc);
        g.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
        this.jb.repaint();
        this.c = nc;
    }

    public Color getColor() {
        return this.c;
    }

    public String getString() {
        return this.jac.getSelectedItem().toString();
    }

    public static Color chooseColor() {
        sc = null;
        if (jcc == null) {
            jcc = new JColorChooser();
            jd = JColorChooser.createDialog(null, "Choose a color", true, jcc, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    sc = jcc.getColor();
                }
            }, null);
        }
        jd.setVisible(true);
        return sc;
    }
}

