/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.droiddraw.AndroidEditor;
import org.droiddraw.Main;
import org.droiddraw.gui.AbstractDataPanel;
import org.droiddraw.util.ColorHandler;

public class ColorsPanel
extends AbstractDataPanel {
    private static final long serialVersionUID = 1L;

    public ColorsPanel() {
        super(new Class[]{String.class, Color.class});
        this.dataTable.setDefaultRenderer(Color.class, new ColorRenderer());
        this.dataTable.setDefaultEditor(Color.class, new ColorEditor());
    }

    protected int parentRowCount() {
        Hashtable<String, Color> colors = AndroidEditor.instance().getColors();
        return colors.size();
    }

    protected Object parentValueAt(int row, int col) {
        Hashtable<String, Color> colors = AndroidEditor.instance().getColors();
        ArrayList<String> sorted = Collections.list(colors.keys());
        Collections.sort(sorted);
        if (col == 0) {
            return sorted.get(row);
        }
        if (col == 1) {
            return colors.get(sorted.get(row));
        }
        return null;
    }

    protected void parentSetValueAt(Object value, int rowIndex, int columnIndex) {
        String key = (String)this.parentValueAt(rowIndex, 0);
        Hashtable<String, Color> colors = AndroidEditor.instance().getColors();
        if (columnIndex == 1) {
            colors.put(key, (Color)value);
        } else {
            Color val = colors.get(key);
            colors.remove(key);
            colors.put((String)value, val);
        }
    }

    protected void parentDeleteRow(int row) {
        String key = (String)this.parentValueAt(row, 0);
        Hashtable<String, Color> colors = AndroidEditor.instance().getColors();
        colors.remove(key);
    }

    protected void doSave() {
        File out = AndroidEditor.instance().getColorFile();
        if (out == null) {
            out = Main.doSaveBasic();
        }
        if (out != null) {
            try {
                ColorHandler.dump(new FileWriter(out), AndroidEditor.instance().getColors());
            }
            catch (IOException ex) {
                AndroidEditor.instance().error(ex);
            }
        }
    }

    protected void addValue(String name) {
        AndroidEditor.instance().getColors().put(name, new Color(128, 128, 128));
    }

    public class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        Color current;
        JButton b = new JButton("Edit");
        JColorChooser cc;
        JDialog dl;

        public ColorEditor() {
            this.b.addActionListener(this);
            this.cc = new JColorChooser();
            this.dl = JColorChooser.createDialog(this.b, "Choose a Color", true, this.cc, this, null);
        }

        public void actionPerformed(ActionEvent e) {
            if ("Edit".equals(e.getActionCommand())) {
                this.b.setBackground(this.current);
                this.cc.setColor(this.current);
                this.dl.setVisible(true);
                this.fireEditingStopped();
            } else {
                this.current = this.cc.getColor();
            }
        }

        public Object getCellEditorValue() {
            return this.current;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.current = (Color)value;
            return this.b;
        }
    }

    public static class ColorRenderer
    implements TableCellRenderer {
        Border selectedBorder;
        Border unselectedBorder;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = (Color)value;
            JLabel lb = new JLabel("#" + Integer.toString(color.getRed(), 16) + Integer.toString(color.getGreen(), 16) + Integer.toString(color.getBlue(), 16) + Integer.toString(color.getAlpha(), 16));
            lb.setOpaque(true);
            lb.setBackground(color);
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, table.getSelectionBackground());
                }
                lb.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, table.getBackground());
                }
                lb.setBorder(this.unselectedBorder);
            }
            lb.setToolTipText("Red: " + color.getRed() + ", Green: " + color.getGreen() + ", Blue: " + color.getBlue());
            return lb;
        }
    }
}

