/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.xml.parsers.ParserConfigurationException;
import org.droiddraw.AndroidEditor;
import org.droiddraw.Main;
import org.droiddraw.gui.ArrayPanel;
import org.droiddraw.gui.ColorsPanel;
import org.droiddraw.gui.DonatePanel;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.gui.StringsPanel;
import org.droiddraw.gui.Viewer;
import org.droiddraw.gui.WidgetPanel;
import org.droiddraw.property.ColorProperty;
import org.droiddraw.util.DroidDrawHandler;
import org.droiddraw.widget.AbsoluteLayout;
import org.droiddraw.widget.AbstractLayout;
import org.droiddraw.widget.AnalogClock;
import org.droiddraw.widget.AutoCompleteTextView;
import org.droiddraw.widget.Button;
import org.droiddraw.widget.CheckBox;
import org.droiddraw.widget.DatePicker;
import org.droiddraw.widget.DigitalClock;
import org.droiddraw.widget.EditView;
import org.droiddraw.widget.FrameLayout;
import org.droiddraw.widget.Gallery;
import org.droiddraw.widget.GridView;
import org.droiddraw.widget.ImageButton;
import org.droiddraw.widget.ImageSwitcher;
import org.droiddraw.widget.ImageView;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.LinearLayout;
import org.droiddraw.widget.ListView;
import org.droiddraw.widget.MapView;
import org.droiddraw.widget.ProgressBar;
import org.droiddraw.widget.RadioButton;
import org.droiddraw.widget.RadioGroup;
import org.droiddraw.widget.RatingBar;
import org.droiddraw.widget.RelativeLayout;
import org.droiddraw.widget.ScrollView;
import org.droiddraw.widget.Spinner;
import org.droiddraw.widget.TabHost;
import org.droiddraw.widget.TabWidget;
import org.droiddraw.widget.TableLayout;
import org.droiddraw.widget.TableRow;
import org.droiddraw.widget.TextView;
import org.droiddraw.widget.Ticker;
import org.droiddraw.widget.TimePicker;
import org.xml.sax.SAXException;

public class DroidDrawPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Dimension d = new Dimension(1100, 600);
    JTabbedPane jtb = new JTabbedPane();
    TextArea text;
    JTextArea jtext;
    private JPopupMenu popup;

    public String getSelectedText() {
        if (this.text != null) {
            return this.text.getSelectedText();
        }
        return this.jtext.getSelectedText();
    }

    public void deleteSelectedText() {
        if (this.text != null) {
            String txt = this.text.getText();
            int start = this.text.getSelectionStart();
            int end = this.text.getSelectionEnd();
            if (end < txt.length()) {
                this.text.setText(String.valueOf(txt.substring(0, start)) + txt.substring(end + 1));
            } else {
                this.text.setText(txt.substring(0, start));
            }
        } else {
            String txt = this.jtext.getText();
            int start = this.jtext.getSelectionStart();
            int end = this.jtext.getSelectionEnd();
            if (end < txt.length()) {
                this.jtext.setText(String.valueOf(txt.substring(0, start)) + txt.substring(end + 1));
            } else {
                this.jtext.setText(txt.substring(0, start));
            }
        }
    }

    public void insertText(String txt) {
        int start = this.text != null ? this.text.getSelectionStart() : this.jtext.getSelectionStart();
        this.deleteSelectedText();
        if (this.text != null) {
            this.text.insert(txt, start);
        } else {
            this.jtext.insert(txt, start);
        }
    }

    public Dimension getMinimumSize() {
        return this.d;
    }

    public void selectAll() {
        if (this.text != null) {
            this.text.selectAll();
        } else {
            this.jtext.selectAll();
        }
    }

    public Dimension getPreferredSize() {
        return this.d;
    }

    public void editSelected() {
        this.jtb.setSelectedIndex(2);
    }

    public void save(File f) {
        try {
            AndroidEditor.instance().generate(new PrintWriter(new FileWriter(f)));
            AndroidEditor.instance().setChanged(false);
        }
        catch (IOException ex) {
            AndroidEditor.instance().error(ex);
        }
    }

    public void open(File f) {
        try {
            this.open(new FileReader(f));
        }
        catch (FileNotFoundException ex) {
            AndroidEditor.instance().error(ex);
        }
    }

    public void open(FileReader r) {
        try {
            StringBuffer buff = new StringBuffer();
            char[] data = new char[4098];
            int read = r.read(data);
            while (read != -1) {
                buff.append(data, 0, read);
                read = r.read(data);
            }
            AndroidEditor.instance().removeAllWidgets();
            DroidDrawHandler.loadFromString(buff.toString());
            if (this.text != null) {
                this.text.setText(buff.toString());
            } else {
                this.jtext.setText(buff.toString());
            }
            this.repaint();
            AndroidEditor.instance().setChanged(false);
        }
        catch (IOException ex) {
            AndroidEditor.instance().error(ex);
        }
        catch (SAXException ex) {
            AndroidEditor.instance().error(ex);
        }
        catch (ParserConfigurationException ex) {
            AndroidEditor.instance().error(ex);
        }
    }

    protected static final void switchToLookAndFeel(String clazz) {
        try {
            UIManager.setLookAndFeel(clazz);
        }
        catch (Exception ex) {
            AndroidEditor.instance().error(ex);
        }
    }

    protected static final void setupRootLayout(Layout l) {
        l.setPosition(AndroidEditor.OFFSET_X + l.getPadding(1) + l.getMargin(1), AndroidEditor.OFFSET_Y + l.getPadding(0) + l.getMargin(0));
        l.setPropertyByAttName("android:layout_width", "fill_parent");
        l.setPropertyByAttName("android:layout_height", "fill_parent");
        l.apply();
    }

    public DroidDrawPanel(String screen, boolean applet) {
        DroidDrawPanel.switchToLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        AndroidEditor ae = AndroidEditor.instance();
        if (applet) {
            this.text = new TextArea(10, 50);
        } else {
            this.jtext = new JTextArea(10, 50);
            this.jtext.getDocument().addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent e) {
                    AndroidEditor.instance().queueUndoRecord(e.getEdit());
                }
            });
            this.popup = new JPopupMenu();
            JMenuItem it = new JMenuItem("Cut");
            this.popup.add(it);
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (DroidDrawPanel.this.getSelectedText() != null && DroidDrawPanel.this.getSelectedText().length() != 0) {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(DroidDrawPanel.this.getSelectedText()), null);
                        DroidDrawPanel.this.deleteSelectedText();
                    }
                }
            });
            it = new JMenuItem("Copy");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (DroidDrawPanel.this.getSelectedText() != null && DroidDrawPanel.this.getSelectedText().length() != 0) {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(DroidDrawPanel.this.getSelectedText()), null);
                    }
                }
            });
            Main.addCopyAction(it);
            this.popup.add(it);
            it = new JMenuItem("Paste");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                    try {
                        String txt = (String)c.getData(DataFlavor.stringFlavor);
                        if (txt != null) {
                            DroidDrawPanel.this.insertText(txt);
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.popup.add(it);
            this.jtext.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        DroidDrawPanel.this.popup.show(DroidDrawPanel.this.jtext, e.getX() + 3, e.getY() + 3);
                    }
                }
            });
        }
        AbsoluteLayout al = new AbsoluteLayout();
        DroidDrawPanel.setupRootLayout(al);
        ae.setLayout(al);
        Image img = null;
        if ("qvgap".equals(screen)) {
            ae.setScreenMode(AndroidEditor.ScreenMode.QVGA_PORTRAIT);
            img = ImageResources.instance().getImage("emu2");
        } else if ("hvgal".equals(screen)) {
            ae.setScreenMode(AndroidEditor.ScreenMode.HVGA_LANDSCAPE);
            img = ImageResources.instance().getImage("emu3");
        } else if ("hvgap".equals(screen)) {
            ae.setScreenMode(AndroidEditor.ScreenMode.HVGA_PORTRAIT);
            img = ImageResources.instance().getImage("emu4");
        } else if ("qvgal".equals(screen)) {
            ae.setScreenMode(AndroidEditor.ScreenMode.QVGA_LANDSCAPE);
            img = ImageResources.instance().getImage("emu1");
        } else if ("wvgap".equals(screen)) {
            ae.setScreenMode(AndroidEditor.ScreenMode.WVGA_PORTRAIT);
            img = ImageResources.instance().getImage("emu4");
        } else if ("wvgal".equals(screen)) {
            ae.setScreenMode(AndroidEditor.ScreenMode.WVGA_LANDSCAPE);
            img = ImageResources.instance().getImage("emu1");
        } else if ("wvgap".equals(screen)) {
            ae.setScreenMode(AndroidEditor.ScreenMode.HVGA_PORTRAIT);
            img = ImageResources.instance().getImage("emu4");
        } else if ("wvgal".equals(screen)) {
            img = ImageResources.instance().getImage("emu1");
        }
        final Viewer viewer = new Viewer(ae, this, img);
        JPanel jp = new JPanel();
        ae.setViewer(viewer);
        this.setLayout(new BorderLayout());
        JButton gen = new JButton("Generate");
        gen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                StringWriter sw = new StringWriter();
                AndroidEditor.instance().generate(new PrintWriter(sw));
                if (DroidDrawPanel.this.text != null) {
                    DroidDrawPanel.this.text.setText(sw.getBuffer().toString());
                } else {
                    DroidDrawPanel.this.jtext.setText(sw.getBuffer().toString());
                }
            }
        });
        JButton edit = new JButton("Edit");
        edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DroidDrawPanel.this.editSelected();
            }
        });
        JButton delete = new JButton("Delete");
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AndroidEditor.instance().removeWidget(AndroidEditor.instance().getSelected());
                viewer.repaint();
            }
        });
        JToolBar tb = new JToolBar();
        tb.addSeparator();
        tb.add(edit);
        tb.addSeparator();
        tb.add(delete);
        tb.addSeparator();
        tb.setFloatable(false);
        JPanel p = new JPanel();
        SpringLayout sl = new SpringLayout();
        p.setLayout(sl);
        JLabel lbl = new JLabel("Root Layout:");
        final JComboBox<String> layout = new JComboBox<String>(new String[]{"AbsoluteLayout", "LinearLayout", "RelativeLayout", "ScrollView", "TableLayout", "TabHost"});
        if (!System.getProperty("os.name").toLowerCase().contains("mac os x")) {
            layout.setLightWeightPopupEnabled(false);
        }
        final ActionListener layoutActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxChanged")) {
                    String select = (String)((JComboBox)e.getSource()).getSelectedItem();
                    AbstractLayout l = null;
                    if (select.equals("AbsoluteLayout")) {
                        l = new AbsoluteLayout();
                    } else if (select.equals("LinearLayout")) {
                        l = new LinearLayout();
                    } else if (select.equals("RelativeLayout")) {
                        l = new RelativeLayout();
                    } else if (select.equals("ScrollView")) {
                        l = new ScrollView();
                    } else if (select.equals("TableLayout")) {
                        l = new TableLayout();
                    } else if (select.equals("TabHost")) {
                        l = new TabHost();
                    }
                    viewer.repaint();
                    DroidDrawPanel.setupRootLayout(l);
                    AndroidEditor.instance().setLayout(l);
                }
            }
        };
        layout.addActionListener(layoutActionListener);
        tb.add(layout);
        p.add(tb);
        JButton load = new JButton("Load");
        load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    AndroidEditor.instance().removeAllWidgets();
                    String layoutXML = DroidDrawPanel.this.text != null ? DroidDrawPanel.this.text.getText() : DroidDrawPanel.this.jtext.getText();
                    if (layoutXML.length() > 0) {
                        DroidDrawHandler.loadFromString(layoutXML);
                    }
                    layout.removeActionListener(layoutActionListener);
                    layout.setSelectedItem(AndroidEditor.instance().getLayout().toString());
                    layout.addActionListener(layoutActionListener);
                    viewer.repaint();
                }
                catch (Exception ex) {
                    AndroidEditor.instance().error(ex);
                }
            }
        });
        p.setSize(200, 300);
        p.validate();
        jp.setLayout(new BorderLayout());
        JComboBox<String> screen_size = new JComboBox<String>(new String[]{"QVGA Landscape", "QVGA Portrait", "HVGA Landscape", "HVGA Portrait", "WVGA Landscape", "WVGA Portrait"});
        screen_size.setSelectedIndex(3);
        JPanel top = new JPanel();
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(0);
        top.setLayout(new GridLayout(2, 2));
        top.add(lbl);
        top.add(layout);
        top.add(new JLabel("Screen Size:"));
        top.add(screen_size);
        p = new JPanel();
        p.setLayout(fl);
        p.add(top);
        jp.add((Component)p, "North");
        jp.add((Component)viewer, "Center");
        jp.setBorder(BorderFactory.createTitledBorder("Screen"));
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Layout", jp);
        JPanel out = new JPanel();
        out.setLayout(new BorderLayout());
        out.add(this.text != null ? this.text : new JScrollPane(this.jtext), "Center");
        TitledBorder border = BorderFactory.createTitledBorder("Output");
        out.setBorder(border);
        JPanel wp = new JPanel();
        JPanel mp = new JPanel();
        wp.setLayout(new GridLayout(0, 1));
        Button b = new Button("Button");
        ((ColorProperty)b.getPropertyByAttName("android:textColor")).setColorValue(Color.black);
        mp.add(new WidgetPanel(b));
        CheckBox cb = new CheckBox("CheckBox");
        ((ColorProperty)cb.getPropertyByAttName("android:textColor")).setColorValue(Color.black);
        mp.add(new WidgetPanel(cb));
        RadioButton rb = new RadioButton("RadioButton");
        ((ColorProperty)rb.getPropertyByAttName("android:textColor")).setColorValue(Color.black);
        mp.add(new WidgetPanel(rb));
        mp.add(new WidgetPanel(new RadioGroup()));
        mp.add(new WidgetPanel(new ImageButton()));
        mp.add(new WidgetPanel(new ImageView()));
        Gallery g = new Gallery();
        g.setWidth(100);
        g.setHeight(40);
        mp.add(new WidgetPanel(g));
        wp.add(mp);
        mp = new JPanel();
        mp.setLayout(new FlowLayout(0));
        mp.add(new WidgetPanel(new Spinner()));
        EditView ev = new EditView("EditText");
        ((ColorProperty)ev.getPropertyByAttName("android:textColor")).setColorValue(Color.black);
        mp.add(new WidgetPanel(ev));
        AutoCompleteTextView actv = new AutoCompleteTextView("AutoComplete");
        ((ColorProperty)actv.getPropertyByAttName("android:textColor")).setColorValue(Color.black);
        mp.add(new WidgetPanel(actv));
        TextView tv = new TextView("TextView");
        ((ColorProperty)tv.getPropertyByAttName("android:textColor")).setColorValue(Color.black);
        mp.add(new WidgetPanel(tv));
        mp.add(new WidgetPanel(new ProgressBar()));
        mp.add(new WidgetPanel(new GridView()));
        wp.add(mp);
        mp = new JPanel();
        mp.setLayout(new FlowLayout(0));
        AnalogClock ac = new AnalogClock();
        ac.setSize(50, 50);
        mp.add(new WidgetPanel(ac));
        DigitalClock dcb = new DigitalClock();
        ((ColorProperty)dcb.getPropertyByAttName("android:textColor")).setColorValue(Color.black);
        mp.add(new WidgetPanel(dcb));
        DatePicker dp = new DatePicker();
        dp.setSize(140, 40);
        mp.add(new WidgetPanel(dp));
        mp.add(new WidgetPanel(new TimePicker()));
        mp.add(new WidgetPanel(new ListView()));
        mp.add(new WidgetPanel(new ImageSwitcher()));
        wp.add(mp);
        mp = new JPanel();
        mp.setLayout(new FlowLayout(0));
        mp.add(new WidgetPanel(new TabWidget()));
        MapView mapView = new MapView();
        mapView.setHeight(100);
        mapView.setWidth(100);
        mp.add(new WidgetPanel(mapView));
        RatingBar rating = new RatingBar();
        mp.add(new WidgetPanel(rating));
        wp.add(mp);
        JPanel ppp = new JPanel();
        ppp.add(wp);
        JScrollPane jswp = new JScrollPane(ppp);
        jswp.setMinimumSize(new Dimension(wp.getWidth(), 160));
        JPanel lp = new JPanel();
        lp.setLayout(new GridLayout(0, 1));
        mp = new JPanel();
        mp.setLayout(new FlowLayout());
        mp.add(new WidgetPanel(new AbsoluteLayout()));
        mp.add(new WidgetPanel(new FrameLayout()));
        mp.add(new WidgetPanel(new LinearLayout()));
        mp.add(new WidgetPanel(new ScrollView()));
        lp.add(mp);
        mp = new JPanel();
        mp.add(new WidgetPanel(new RelativeLayout()));
        TableRow tr = new TableRow();
        tr.setSizeInternal(70, tr.getHeight());
        mp.add(new WidgetPanel(tr));
        mp.add(new WidgetPanel(new TableLayout()));
        mp.add(new WidgetPanel(new Ticker()));
        lp.add(mp);
        mp = new JPanel();
        mp.add(lp);
        JScrollPane jslp = new JScrollPane(mp);
        this.jtb.addTab("Widgets", jswp);
        this.jtb.addTab("Layouts", jslp);
        this.jtb.addTab("Properties", AndroidEditor.instance().getPropertiesPanel());
        if (!applet) {
            this.jtb.addTab("Strings", new StringsPanel());
            this.jtb.addTab("Colors", new ColorsPanel());
            this.jtb.addTab("Arrays", new ArrayPanel());
        }
        this.jtb.addTab("Support", new DonatePanel());
        JButton undo = new JButton("Undo");
        undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AndroidEditor.instance().undo();
            }
        });
        JButton redo = new JButton("Redo");
        redo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AndroidEditor.instance().redo();
            }
        });
        JToolBar gp = new JToolBar();
        gp.add(gen);
        gp.add(load);
        gp.addSeparator();
        gp.add(undo);
        gp.add(redo);
        JSplitPane ctl = new JSplitPane(0, this.jtb, out);
        final JSplitPane jsp = new JSplitPane(1, jp, ctl);
        this.add((Component)gp, "North");
        this.add((Component)jsp, "Center");
        screen_size.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                int ix = jcb.getSelectedIndex();
                AndroidEditor ae = AndroidEditor.instance();
                switch (ix) {
                    case 0: {
                        ae.setScreenMode(AndroidEditor.ScreenMode.QVGA_LANDSCAPE);
                        viewer.resetScreen(ImageResources.instance().getImage("emu1"));
                        break;
                    }
                    case 1: {
                        ae.setScreenMode(AndroidEditor.ScreenMode.QVGA_PORTRAIT);
                        viewer.resetScreen(ImageResources.instance().getImage("emu2"));
                        break;
                    }
                    case 2: {
                        ae.setScreenMode(AndroidEditor.ScreenMode.HVGA_LANDSCAPE);
                        viewer.resetScreen(ImageResources.instance().getImage("emu3"));
                        break;
                    }
                    case 3: {
                        ae.setScreenMode(AndroidEditor.ScreenMode.HVGA_PORTRAIT);
                        viewer.resetScreen(ImageResources.instance().getImage("emu4"));
                        break;
                    }
                    case 4: {
                        ae.setScreenMode(AndroidEditor.ScreenMode.WVGA_LANDSCAPE);
                        viewer.resetScreen(ImageResources.instance().getImage("emu5"));
                        DroidDrawPanel.this.setSize(1000, 750);
                        break;
                    }
                    case 5: {
                        ae.setScreenMode(AndroidEditor.ScreenMode.WVGA_PORTRAIT);
                        viewer.resetScreen(ImageResources.instance().getImage("emu6"));
                        DroidDrawPanel.this.setSize(1000, 750);
                    }
                }
                jsp.validate();
                viewer.repaint();
            }
        });
        this.validate();
    }

    public void clear() {
        AndroidEditor.instance().getLayout().removeAllWidgets();
        AndroidEditor.instance().select(AndroidEditor.instance().getLayout());
        if (this.text != null) {
            this.text.setText("");
        } else {
            this.jtext.setText("");
        }
    }
}

