/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class NineWayImage {
    BufferedImage[] images;
    int dx1;
    int dy1;
    int dx2;
    int dy2;
    int wx;
    int wy;

    public NineWayImage(Image img, int dx, int dy) {
        this(img, dx, dy, dx, dy);
    }

    public NineWayImage(Image img, int dx1, int dy1, int dx2, int dy2) {
        if (img == null) {
            throw new IllegalArgumentException();
        }
        this.images = new BufferedImage[9];
        this.dx1 = dx1;
        this.dy1 = dy1;
        this.dx2 = dx2;
        this.dy2 = dy2;
        this.wx = img.getWidth(null) - (dx1 + dx2);
        this.wy = img.getHeight(null) - (dy1 + dy2);
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 6);
        bi.getGraphics().drawImage(img, 0, 0, null);
        int w = bi.getWidth();
        int h = bi.getHeight();
        if (dx1 > 0 && dy1 > 0) {
            this.images[0] = bi.getSubimage(1, 1, dx1, dy1);
        }
        if (dy1 > 0) {
            this.images[1] = bi.getSubimage(dx1, 1, this.wx, dy1);
        }
        if (dx2 > 0 && dy1 > 0) {
            this.images[2] = bi.getSubimage(w - dx2 - 1, 1, dx2, dy1);
        }
        if (dx1 > 0) {
            this.images[3] = bi.getSubimage(1, dy1, dx1, this.wy);
        }
        this.images[4] = bi.getSubimage(dx1, dy1, this.wx, this.wy);
        if (dx2 > 0) {
            this.images[5] = bi.getSubimage(w - dx2 - 1, dy1, dx2, this.wy);
        }
        if (dx1 > 0 && dy2 > 0) {
            this.images[6] = bi.getSubimage(1, h - dy2 - 1, dx1, dy2);
        }
        if (dy2 > 0) {
            this.images[7] = bi.getSubimage(dx1, h - dy2 - 1, this.wx, dy2);
        }
        if (dx2 > 0 && dy2 > 0) {
            this.images[8] = bi.getSubimage(w - dx2 - 1, h - dy2 - 1, dx2, dy2);
        }
    }

    public void paint(Graphics g, int x, int y, int sx, int sy) {
        if (this.images[0] != null) {
            g.drawImage(this.images[0], x, y, null);
        }
        if (this.images[1] != null) {
            g.drawImage(this.images[1], x + this.dx1, y, sx - (this.dx1 + this.dx2), this.dy1, null);
        }
        if (this.images[2] != null) {
            g.drawImage(this.images[2], x + sx - this.dx2, y, null);
        }
        if (this.images[3] != null) {
            g.drawImage(this.images[3], x, y + this.dy1, this.dx1, sy - (this.dy1 + this.dy2), null);
        }
        if (this.images[4] != null) {
            g.drawImage(this.images[4], x + this.dx1, y + this.dy1, sx - (this.dx1 + this.dx2), sy - (this.dy1 + this.dy2), null);
        }
        if (this.images[5] != null) {
            g.drawImage(this.images[5], x + sx - this.dx2, y + this.dy1, this.dx2, sy - (this.dy1 + this.dy2), null);
        }
        if (this.images[6] != null) {
            g.drawImage(this.images[6], x, y + sy - this.dy2, null);
        }
        if (this.images[7] != null) {
            g.drawImage(this.images[7], x + this.dx1, y + sy - this.dy2, sx - (this.dx1 + this.dx2), this.dy2, null);
        }
        if (this.images[8] != null) {
            g.drawImage(this.images[8], x + sx - this.dx2, y + sy - this.dy2, null);
        }
    }
}

