/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.util.prefs.BackingStoreException;
import org.droiddraw.AndroidEditor;

public class Preferences {
    private static String SNAP = "snap";
    private static String SCREEN = "screen";
    private static String LAYOUT = "layout";
    private static String UPDATE = "update";
    protected boolean snap = false;
    protected AndroidEditor.ScreenMode screen = AndroidEditor.ScreenMode.HVGA_PORTRAIT;
    protected Layout layout = Layout.ABSOLUTE;
    protected Update updateCheck = Update.ASK;

    public void load() {
        java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(Preferences.class);
        this.snap = prefs.getBoolean(SNAP, false);
        int screenPref = prefs.getInt(SCREEN, 3);
        if (screenPref < 0 || screenPref >= AndroidEditor.ScreenMode.values().length) {
            screenPref = 3;
        }
        this.screen = 3 < AndroidEditor.ScreenMode.values().length ? AndroidEditor.ScreenMode.values()[3] : AndroidEditor.ScreenMode.QVGA_PORTRAIT;
        int layoutPref = prefs.getInt(LAYOUT, 0);
        if (layoutPref < 0 || layoutPref >= Layout.values().length) {
            layoutPref = 0;
        }
        this.layout = Layout.values()[layoutPref];
        int updatePref = prefs.getInt(UPDATE, 1);
        if (updatePref < 0 || updatePref >= Update.values().length) {
            updatePref = 1;
        }
        this.updateCheck = Update.values()[updatePref];
    }

    public void save() {
        java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(Preferences.class);
        prefs.putBoolean(SNAP, this.snap);
        prefs.putInt(SCREEN, this.screen.ordinal());
        prefs.putInt(LAYOUT, this.layout.ordinal());
        prefs.putInt(UPDATE, this.updateCheck.ordinal());
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            AndroidEditor.instance().error(ex);
        }
    }

    public void setSnap(boolean value) {
        this.snap = value;
    }

    public boolean getSnap() {
        return this.snap;
    }

    public void setScreenMode(AndroidEditor.ScreenMode screen) {
        this.screen = screen;
    }

    public AndroidEditor.ScreenMode getScreenMode() {
        return this.screen;
    }

    public void setDefaultLayout(Layout l) {
        this.layout = l;
    }

    public Layout getDefaultLayout() {
        return this.layout;
    }

    public Update getUpdateCheck() {
        return this.updateCheck;
    }

    public void setUpdateCheck(Update u) {
        this.updateCheck = u;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layout {
        ABSOLUTE,
        LINEAR,
        RELATIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Update {
        YES,
        ASK,
        NO;

    }
}

