/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.droiddraw.AndroidEditor;
import org.droiddraw.Main;
import org.droiddraw.gui.ColorPanel;
import org.droiddraw.gui.JAutoTextField;
import org.droiddraw.gui.Viewer;
import org.droiddraw.property.BooleanProperty;
import org.droiddraw.property.ColorProperty;
import org.droiddraw.property.ImageProperty;
import org.droiddraw.property.IntProperty;
import org.droiddraw.property.Property;
import org.droiddraw.property.SelectProperty;
import org.droiddraw.property.StringProperty;
import org.droiddraw.util.FileCopier;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    Vector<Property> properties;
    Hashtable<Property, JComponent> components = new Hashtable();
    Hashtable<ColorProperty, Color> colorTable = new Hashtable();
    Viewer viewer;
    Widget w;
    JPanel items;
    Dimension d;
    boolean applet;

    public PropertiesPanel(boolean applet) {
        this(new Vector<Property>(), null, applet);
    }

    public PropertiesPanel(Vector<Property> properties, Widget w, boolean applet) {
        this.w = w;
        this.applet = applet;
        this.setProperties(properties, w);
        this.d = new Dimension(200, 400);
    }

    public void setApplet(boolean applet) {
        this.applet = applet;
    }

    public void setProperties(Vector<Property> properties, Widget w) {
        this.properties = properties;
        this.removeAll();
        this.w = w;
        if (w == null) {
            return;
        }
        w.setPropertyChangeListener(this);
        this.items = new JPanel();
        this.items.setLayout(new GridLayout(0, 2));
        this.components.clear();
        if (properties.size() > 0) {
            this.items.add(new JLabel("Properties for: "));
            this.items.add(new JLabel(w.getTagName()));
        }
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(2);
        for (Property prop : properties) {
            JComponent jc;
            JPanel jp;
            JTextField jf;
            if (!prop.getEditable()) continue;
            if (prop instanceof BooleanProperty) {
                this.items.add(new JPanel());
                JCheckBox jcb = new JCheckBox(prop.getEnglishName());
                jcb.setSelected(((BooleanProperty)prop).getBooleanValue());
                this.components.put(prop, jcb);
                this.items.add(jcb);
                continue;
            }
            if (prop instanceof IntProperty) {
                this.items.add(new JLabel(prop.getEnglishName()));
                jf = new JTextField(prop.getValue() != null ? prop.getValue().toString() : "", 5);
                jp = new JPanel();
                jp.setLayout(fl);
                jp.add(jf);
                this.components.put(prop, jf);
                this.items.add(jp);
                continue;
            }
            if (prop instanceof ImageProperty) {
                this.items.add(new JLabel(prop.getEnglishName()));
                jf = new JTextField(prop.getValue() != null ? prop.getValue().toString() : "", 10);
                jp = new JPanel();
                jp.setLayout(fl);
                jp.add(jf);
                if (!this.applet) {
                    JButton jb = new JButton("Browse");
                    jb.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            File img;
                            File dir;
                            if (AndroidEditor.instance().getDrawableDirectory() == null) {
                                JOptionPane.showMessageDialog(PropertiesPanel.this, "You must select a drawables directory.\n If you select an image which is not in this directory,\n it will be copied into it.", "Select Drawable Dir.", 1);
                                dir = Main.doOpenDir();
                                if (dir != null) {
                                    AndroidEditor.instance().setDrawableDirectory(dir);
                                }
                            }
                            if ((dir = AndroidEditor.instance().getDrawableDirectory()) != null && (img = Main.doOpenImage(dir)) != null) {
                                String name;
                                int ix;
                                if (!img.getParentFile().equals(dir)) {
                                    try {
                                        FileCopier.copy(img, dir, true);
                                    }
                                    catch (IOException ex) {
                                        AndroidEditor.instance().error(ex);
                                    }
                                }
                                if ((ix = (name = img.getName()).indexOf(".")) != -1) {
                                    name = name.substring(0, ix);
                                }
                                jf.setText("@drawable/" + name);
                                jf.requestFocus();
                            }
                        }
                    });
                    jp.add(jb);
                }
                this.components.put(prop, jf);
                this.items.add(jp);
                continue;
            }
            if (!(prop instanceof StringProperty)) continue;
            this.items.add(new JLabel(prop.getEnglishName()));
            if (prop instanceof SelectProperty) {
                JComboBox<String> jcb = new JComboBox<String>(((SelectProperty)prop).getOptions());
                jcb.setSelectedIndex(((SelectProperty)prop).getSelectedIndex());
                jc = jcb;
            } else if (prop instanceof ColorProperty) {
                jc = new ColorPanel(((ColorProperty)prop).getColorValue());
            } else if (prop.getAtttributeName().equals("android:layout_width") || prop.getAtttributeName().equals("android:layout_height")) {
                Vector<String> v = new Vector<String>();
                v.add("");
                v.add("fill_parent");
                v.add("wrap_content");
                JAutoTextField jat = new JAutoTextField(v);
                jat.setStrict(false);
                jat.setColumns(10);
                if (prop.getValue() != null) {
                    jat.setText(prop.getValue().toString());
                }
                jc = jat;
            } else {
                jc = new JTextField(prop.getValue() != null ? prop.getValue().toString() : "", 10);
            }
            prop.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    Property p = (Property)evt.getSource();
                    JComponent jc = PropertiesPanel.this.components.get(p);
                    if (p instanceof BooleanProperty) {
                        ((JCheckBox)jc).setSelected((Boolean)evt.getNewValue());
                    } else if (!(p instanceof ColorProperty) && !(p instanceof SelectProperty) && p instanceof StringProperty && jc != null) {
                        ((JTextField)jc).setText(evt.getNewValue().toString());
                    }
                }
            });
            this.components.put(prop, jc);
            JPanel p = new JPanel();
            p.setLayout(fl);
            p.add(jc);
            this.items.add(p);
        }
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.add(this.items);
        this.add((Component)new JScrollPane(p), "Center");
        if (properties.size() > 0) {
            JButton apply = new JButton("Apply");
            apply.addActionListener(this);
            p = new JPanel();
            p.add(apply);
            this.add((Component)p, "South");
        }
        this.repaint();
        this.invalidate();
    }

    public void setViewer(Viewer v) {
        this.viewer = v;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.apply();
    }

    protected void apply() {
        for (Property prop : this.properties) {
            JComponent jcb;
            if (!prop.getEditable()) continue;
            if (prop instanceof BooleanProperty) {
                jcb = (JCheckBox)this.components.get(prop);
                ((BooleanProperty)prop).setBooleanValue(((AbstractButton)jcb).isSelected());
                continue;
            }
            if (prop instanceof IntProperty) {
                JTextField jf = (JTextField)this.components.get(prop);
                try {
                    ((IntProperty)prop).setIntValue(Integer.parseInt(jf.getText()));
                }
                catch (NumberFormatException ex) {
                    AndroidEditor.instance().error(ex);
                }
                continue;
            }
            if (!(prop instanceof StringProperty)) continue;
            if (prop instanceof SelectProperty) {
                jcb = (JComboBox)this.components.get(prop);
                if (jcb == null) {
                    AndroidEditor.instance().error("Couldn't find select for: " + prop.getAtttributeName());
                    continue;
                }
                ((SelectProperty)prop).setSelectedIndex(((JComboBox)jcb).getSelectedIndex());
                continue;
            }
            if (prop instanceof ColorProperty) {
                ColorPanel cp = (ColorPanel)this.components.get(prop);
                ((ColorProperty)prop).setStringValue(cp.getString());
                continue;
            }
            JTextField jtf = (JTextField)this.components.get(prop);
            if (jtf == null) {
                AndroidEditor.instance().error("Couldn't find text for: " + prop.getAtttributeName());
                continue;
            }
            if (prop.getAtttributeName().equals("android:layout_width") || prop.getAtttributeName().equals("android:layout_height")) {
                if (!(jtf.getText().endsWith("px") || jtf.getText().equals("wrap_content") || jtf.getText().equals("fill_parent"))) {
                    AndroidEditor.instance().error("Incorrect Syntax for: " + prop.getEnglishName() + "\n\"px\" is required after a width or height entry");
                    ((StringProperty)prop).setStringValue(String.valueOf(jtf.getText()) + "px");
                    continue;
                }
                ((StringProperty)prop).setStringValue(jtf.getText());
                continue;
            }
            ((StringProperty)prop).setStringValue(jtf.getText());
        }
        this.w.apply();
        if (this.w instanceof Layout) {
            ((Layout)this.w).repositionAllWidgets();
            this.w.apply();
        }
        if (this.w.getParent() != null) {
            this.w.getParent().positionWidget(this.w);
        }
        if (this.viewer != null) {
            this.viewer.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.w.equals(evt.getSource())) {
            this.setProperties((Vector)evt.getNewValue(), this.w);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.apply();
        }
    }
}

