/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.droiddraw.AndroidEditor;
import org.droiddraw.gui.DroidDrawPanel;
import org.droiddraw.gui.MoveRecord;
import org.droiddraw.gui.Viewer;
import org.droiddraw.gui.WidgetAddRecord;
import org.droiddraw.gui.WidgetDeleteRecord;
import org.droiddraw.property.StringProperty;
import org.droiddraw.widget.AbsoluteLayout;
import org.droiddraw.widget.AnalogClock;
import org.droiddraw.widget.AutoCompleteTextView;
import org.droiddraw.widget.Button;
import org.droiddraw.widget.CheckBox;
import org.droiddraw.widget.DatePicker;
import org.droiddraw.widget.DigitalClock;
import org.droiddraw.widget.EditView;
import org.droiddraw.widget.FrameLayout;
import org.droiddraw.widget.Gallery;
import org.droiddraw.widget.GridView;
import org.droiddraw.widget.ImageButton;
import org.droiddraw.widget.ImageSwitcher;
import org.droiddraw.widget.ImageView;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.LinearLayout;
import org.droiddraw.widget.ListView;
import org.droiddraw.widget.MapView;
import org.droiddraw.widget.ProgressBar;
import org.droiddraw.widget.RadioButton;
import org.droiddraw.widget.RadioGroup;
import org.droiddraw.widget.RatingBar;
import org.droiddraw.widget.RelativeLayout;
import org.droiddraw.widget.ScrollView;
import org.droiddraw.widget.Spinner;
import org.droiddraw.widget.TabHost;
import org.droiddraw.widget.TabWidget;
import org.droiddraw.widget.TableLayout;
import org.droiddraw.widget.TableRow;
import org.droiddraw.widget.TextView;
import org.droiddraw.widget.Ticker;
import org.droiddraw.widget.TimePicker;
import org.droiddraw.widget.Widget;

public class ViewerListener
implements MouseListener,
MouseMotionListener,
KeyListener {
    int off_x;
    int off_y;
    int sx;
    int sy;
    int grid_x = 10;
    int grid_y = 10;
    boolean select;
    boolean shift;
    int mode;
    private static final int NORMAL = 0;
    private static final int E = 1;
    private static final int SE = 2;
    private static final int S = 3;
    Viewer viewer;
    AndroidEditor app;
    JComboBox widgetType = new JComboBox<String>(new String[]{"AnalogClock", "AutoCompleteTextView", "Button", "CheckBox", "DigitalClock", "EditText", "ImageButton", "ImageView", "ListView", "ProgressBar", "RadioButton", "RadioGroup", "Spinner", "TableRow", "TextView", "TimePicker", "AbsoluteLayout", "LinearLayout", "RelativeLayout", "TableLayout", "Ticker", "TabHost", "TabWidget"});
    DroidDrawPanel ddp;
    private boolean dragging;

    public ViewerListener(AndroidEditor app, DroidDrawPanel ddp, Viewer viewer) {
        this.ddp = ddp;
        this.app = app;
        this.viewer = viewer;
        if (!System.getProperty("os.name").toLowerCase().contains("mac os x")) {
            this.widgetType.setLightWeightPopupEnabled(false);
        }
    }

    public Component getWidgetSelector() {
        return this.widgetType;
    }

    public Widget createWidget() {
        String str = (String)this.widgetType.getSelectedItem();
        return ViewerListener.createWidget(str);
    }

    public static Widget createWidget(String str) {
        if (str.equals("Button")) {
            return new Button("Button");
        }
        if (str.equals("CheckBox")) {
            return new CheckBox("CheckBox");
        }
        if (str.equals("EditText")) {
            return new EditView("EditText");
        }
        if (str.equals("TextView")) {
            return new TextView("TextView");
        }
        if (str.equals("AnalogClock")) {
            return new AnalogClock();
        }
        if (str.equals("DigitalClock")) {
            return new DigitalClock();
        }
        if (str.equals("ProgressBar")) {
            return new ProgressBar();
        }
        if (str.equals("LinearLayout")) {
            return new LinearLayout();
        }
        if (str.equals("AbsoluteLayout")) {
            return new AbsoluteLayout();
        }
        if (str.equals("RelativeLayout")) {
            return new RelativeLayout();
        }
        if (str.equals("RadioButton")) {
            return new RadioButton("RadioButton");
        }
        if (str.equals("RadioGroup")) {
            return new RadioGroup();
        }
        if (str.equals("TimePicker")) {
            return new TimePicker();
        }
        if (str.equals("ListView")) {
            return new ListView();
        }
        if (str.equals("Ticker")) {
            return new Ticker();
        }
        if (str.equals("Spinner")) {
            return new Spinner();
        }
        if (str.equals("ImageView")) {
            return new ImageView();
        }
        if (str.equals("ImageButton")) {
            return new ImageButton();
        }
        if (str.equals("AutoCompleteTextView")) {
            return new AutoCompleteTextView("AutoComplete");
        }
        if (str.equals("TableRow")) {
            return new TableRow();
        }
        if (str.equals("TableLayout")) {
            return new TableLayout();
        }
        if (str.equals("FrameLayout")) {
            return new FrameLayout();
        }
        if (str.equals("ScrollView")) {
            return new ScrollView();
        }
        if (str.equals("GridView")) {
            return new GridView();
        }
        if (str.equals("Gallery")) {
            return new Gallery();
        }
        if (str.equals("DatePicker")) {
            return new DatePicker();
        }
        if (str.equals("ImageSwitcher")) {
            return new ImageSwitcher();
        }
        if (str.equals("TabHost")) {
            return new TabHost();
        }
        if (str.equals("TabWidget")) {
            return new TabWidget();
        }
        if (str.equals("MapView")) {
            return new MapView();
        }
        if (str.equals("RatingBar")) {
            return new RatingBar();
        }
        return null;
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mouseClicked(MouseEvent e) {
        final int x = e.getX() - this.viewer.getOffX();
        final int y = e.getY() - this.viewer.getOffY();
        final MouseEvent ev = e;
        if (this.select) {
            final Vector<Widget> ws = this.app.findWidgets(x, y);
            Widget w = null;
            if (ws.contains(this.app.getSelected())) {
                w = this.app.getSelected();
            } else {
                switch (ws.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        w = ws.get(0);
                        break;
                    }
                    default: {
                        if (e.isControlDown() || e.getButton() == 3) {
                            JPopupMenu menu = new JPopupMenu();
                            JMenuItem it = new JMenuItem("Select a widget:");
                            it.setEnabled(false);
                            menu.add(it);
                            menu.addSeparator();
                            int i = 0;
                            while (i < ws.size()) {
                                it = new JMenuItem(ws.get(i).getTagName());
                                final int id = i++;
                                it.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent arg0) {
                                        ViewerListener.this.doSelect((Widget)ws.get(id), ev.getClickCount(), x, y);
                                    }
                                });
                                menu.add(it);
                            }
                            menu.show(this.viewer, x, y);
                            break;
                        }
                        w = ws.get(0);
                    }
                }
            }
            this.doSelect(w, e.getClickCount(), x, y);
        }
    }

    protected void doSelect(Widget w, int clickCount, int x, int y) {
        if (clickCount > 1) {
            if (w != null) {
                if (w != this.app.getSelected()) {
                    this.app.select(w);
                }
                this.ddp.editSelected();
            }
        } else if (this.mode == 0) {
            if (w != null) {
                this.off_x = (w.getParent() != null ? w.getParent().getScreenX() : 0) + w.getX() - x;
                this.off_y = (w.getParent() != null ? w.getParent().getScreenY() : 0) + w.getY() - y;
            }
            this.app.select(w);
            this.viewer.requestFocus();
            this.viewer.repaint();
        }
    }

    public void addWidget(Widget ww, int xx, int yy) {
        final int x = xx;
        final int y = yy;
        final Widget w = ww;
        final Vector<Layout> ls = this.app.findLayouts(x, y);
        Layout l = null;
        switch (ls.size()) {
            case 0: {
                return;
            }
            case 1: {
                l = ls.get(0);
                break;
            }
            default: {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem it = new JMenuItem("Select a layout:");
                it.setEnabled(false);
                menu.add(it);
                menu.addSeparator();
                int i = 0;
                while (i < ls.size()) {
                    it = new JMenuItem(ls.get(i).getTagName());
                    final int id = i++;
                    it.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent arg0) {
                            if (!ViewerListener.this.isTabWidgetValid((Layout)ls.get(id), w)) {
                                return;
                            }
                            if ("FrameLayout".equals(w.getTagName()) && "LinearLayout".equals(((Layout)ls.get(id)).getTagName()) && ViewerListener.this.isFrameLayoutForTab((Layout)ls.get(id), w)) {
                                ((StringProperty)w.getProperties().get(w.getProperties().indexOf(w.getPropertyByAttName("android:id")))).setStringValue("@android:id/tabcontent");
                            }
                            ViewerListener.this.addWidget(w, (Layout)ls.get(id), x, y);
                        }
                    });
                    menu.add(it);
                }
                menu.show(this.viewer, x, y);
            }
        }
        if (l != null) {
            if (!this.isTabWidgetValid(l, w)) {
                return;
            }
            this.addWidget(w, l, x, y);
        }
    }

    private boolean isFrameLayoutForTab(Layout layout, Widget widget) {
        boolean found = false;
        if (!"TabHost".equals(this.app.getLayout().getTagName())) {
            AndroidEditor.instance().error("Please ensure that the root layout is a TabHost layout.");
            return false;
        }
        Vector<Widget> widgets = this.app.getLayout().getWidgets();
        for (Widget w : widgets) {
            if (!"LinearLayout".equals(w.getTagName())) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean isTabWidgetValid(Layout layout, Widget widget) {
        if (!"TabHost".equals(this.app.getLayout().getTagName()) && "TabWidget".equals(widget.getTagName())) {
            AndroidEditor.instance().error("Please select TabHost as the root layout.");
            return false;
        }
        if (!"LinearLayout".equals(layout.getTagName()) && "TabWidget".equals(widget.getTagName())) {
            AndroidEditor.instance().error("First add a LinearLayout widget to the TabHost Layout.  Then add the TabWidget to that LinearLayout");
            return false;
        }
        return true;
    }

    public void addWidget(Widget w, Layout l, int x, int y) {
        boolean prefersGrid = AndroidEditor.instance().getPreferences().getSnap();
        if (l instanceof AbsoluteLayout && (this.shift && !prefersGrid || !this.shift && prefersGrid)) {
            w.setPosition(x / this.grid_x * this.grid_x - l.getScreenX(), y / this.grid_y * this.grid_y - l.getScreenY());
        } else {
            w.setPosition(x - l.getScreenX(), y - l.getScreenY());
        }
        l.addWidget(w);
        AndroidEditor.instance().queueUndoRecord(new WidgetAddRecord(l, w));
        l.apply();
        this.app.select(w);
        this.select = true;
        this.viewer.requestFocus();
        this.viewer.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.dragging = false;
        e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
        Widget w = this.app.getSelected();
        if (w != null) {
            int nx = w.getX();
            int ny = w.getY();
            if (nx != this.sx || ny != this.sy) {
                this.app.queueUndoRecord(new MoveRecord(this.sx, this.sy, nx, ny, w));
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX() - this.viewer.getOffX();
        int y = e.getY() - this.viewer.getOffY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x > this.app.getScreenX()) {
            x = this.app.getScreenX();
        }
        if (y > this.app.getScreenY()) {
            y = this.app.getScreenY();
        }
        Widget selected = this.app.getSelected();
        Vector<Widget> ws = this.app.findWidgets(x, y);
        if (!this.dragging && !ws.contains(selected)) {
            if (ws.size() > 0) {
                this.app.select(ws.get(0));
                Widget w = selected = this.app.getSelected();
                this.off_x = (w.getParent() != null ? w.getParent().getScreenX() : 0) + w.getX() - x;
                this.off_y = (w.getParent() != null ? w.getParent().getScreenY() : 0) + w.getY() - y;
            } else {
                this.app.select(null);
                return;
            }
        }
        this.dragging = true;
        if (selected != null) {
            Layout l = selected.getParent();
            Vector<Layout> ls = this.app.findLayouts(x, y);
            if (ls.size() > 0) {
                int ix = 0;
                while ((l = ls.get(ix++)).equals(selected) && ix < ls.size()) {
                }
            } else {
                l = selected.getParent();
            }
            if (l != selected.getParent()) {
                if (!(selected instanceof Layout) || !((Layout)selected).containsWidget(l)) {
                    selected.getParent().removeWidget(selected);
                    l.addWidget(selected);
                } else {
                    l = selected.getParent();
                }
            }
            if (this.mode == 0) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(13));
                int nx = x + this.off_x;
                int ny = y + this.off_y;
                boolean prefersGrid = AndroidEditor.instance().getPreferences().getSnap();
                if (l instanceof AbsoluteLayout && (this.shift && !prefersGrid || !this.shift && prefersGrid)) {
                    nx = nx / this.grid_x * this.grid_x;
                    ny = ny / this.grid_y * this.grid_y;
                }
                selected.setPosition(nx - l.getScreenX(), ny - l.getScreenY());
            } else if (this.mode == 1) {
                Widget w = AndroidEditor.instance().getSelected();
                w.setWidth(x - (l.getScreenX() + w.getX()));
            } else if (this.mode == 2) {
                Widget wd = AndroidEditor.instance().getSelected();
                int w = x - (l.getScreenX() + wd.getX());
                int h = y - (l.getScreenY() + wd.getY());
                if (this.shift) {
                    if (w > h) {
                        h = w;
                    } else {
                        w = h;
                    }
                }
                wd.setSize(w, h);
            } else if (this.mode == 3) {
                Widget w = AndroidEditor.instance().getSelected();
                w.setHeight(y - (l.getScreenY() + w.getY()));
            }
            l.positionWidget(selected);
            l.apply();
            this.viewer.repaint();
        }
    }

    public void mouseMoved(MouseEvent ev) {
        int ex = ev.getX();
        int ey = ev.getY();
        Widget selected = AndroidEditor.instance().getSelected();
        this.mode = 0;
        Cursor c = Cursor.getPredefinedCursor(0);
        if (selected != null) {
            boolean close_b;
            int x = selected.getParent().getScreenX() + selected.getX() + this.viewer.getOffX();
            int y = selected.getParent().getScreenY() + selected.getY() + this.viewer.getOffY();
            int distance_x = ex - (x + selected.getWidth());
            int distance_y = ey - (y + selected.getHeight());
            boolean close_r = distance_x > -8 && distance_x < -1 && ey > y && ey < y + selected.getHeight();
            boolean bl = close_b = distance_y > -8 && distance_y < -1 && ex > x && ex < x + selected.getWidth();
            if (close_r) {
                if (close_b) {
                    c = Cursor.getPredefinedCursor(5);
                    this.mode = 2;
                } else {
                    c = Cursor.getPredefinedCursor(11);
                    this.mode = 1;
                }
            } else if (close_b) {
                c = Cursor.getPredefinedCursor(9);
                this.mode = 3;
            }
        }
        ev.getComponent().setCursor(c);
    }

    public void keyPressed(KeyEvent ev) {
        Widget w;
        switch (ev.getKeyCode()) {
            case 16: {
                this.shift = true;
                break;
            }
            case 8: 
            case 127: {
                w = this.app.getSelected();
                if (w == null) break;
                Layout l = w.getParent();
                this.app.removeWidget(this.app.getSelected());
                this.app.queueUndoRecord(new WidgetDeleteRecord(l, w));
                this.viewer.repaint();
            }
        }
        w = this.app.getSelected();
        if (w != null && w.getParent() instanceof AbsoluteLayout) {
            int dx = 0;
            int dy = 0;
            switch (ev.getKeyCode()) {
                case 38: {
                    dy = -1;
                    break;
                }
                case 40: {
                    dy = 1;
                    break;
                }
                case 37: {
                    dx = -1;
                    break;
                }
                case 39: {
                    dx = 1;
                }
            }
            if (dx != 0 || dy != 0) {
                int sx = w.getX();
                int sy = w.getY();
                w.move(dx, dy);
                this.app.queueUndoRecord(new MoveRecord(sx, sy, sx + dx, sy + dy, w));
            }
        }
    }

    public void keyReleased(KeyEvent ev) {
        switch (ev.getKeyCode()) {
            case 16: {
                this.shift = false;
            }
        }
    }

    public void keyTyped(KeyEvent ev) {
    }

    public void mousePressed(MouseEvent e) {
        Widget w = this.app.getSelected();
        if (w != null) {
            int x = e.getX() - this.viewer.getOffX();
            int y = e.getY() - this.viewer.getOffY();
            this.sx = w.getX();
            this.sy = w.getY();
            this.off_x = (w.getParent() != null ? w.getParent().getScreenX() : 0) + w.getX() - x;
            this.off_y = (w.getParent() != null ? w.getParent().getScreenY() : 0) + w.getY() - y;
        }
    }
}

