/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.droiddraw.AndroidEditor;
import org.droiddraw.gui.ViewerListener;
import org.droiddraw.widget.Widget;

public class WidgetPanel
extends JPanel
implements DragGestureListener,
DragSourceListener {
    private static final long serialVersionUID = 1L;
    Widget w;
    Dimension d;
    DragSource ds;
    BufferedImage img;
    int x;
    int y;

    public WidgetPanel(Widget w) {
        this.w = w;
        this.d = new Dimension(w.getWidth(), w.getHeight());
        this.w.setPosition(0, 0);
        this.setToolTipText(w.getTagName());
        this.ds = DragSource.getDefaultDragSource();
        this.ds.createDefaultDragGestureRecognizer(this, 1, this);
        this.img = new BufferedImage(w.getWidth(), w.getHeight(), 6);
        Graphics g = this.img.getGraphics();
        w.paint(g);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    AndroidEditor.instance().getLayout().addWidget(ViewerListener.createWidget(WidgetPanel.this.w.getTagName()));
                    AndroidEditor.instance().setChanged(true);
                } else if (WidgetPanel.this.w.getParent() != null) {
                    AndroidEditor.instance().select(WidgetPanel.this.w);
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public Dimension getMinimumSize() {
        return this.d;
    }

    public Dimension getPreferredSize() {
        return this.d;
    }

    public void paint(Graphics g) {
        this.w.paint(g);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        try {
            StringSelection t = new StringSelection(this.w.getTagName());
            this.ds.startDrag(e, DragSource.DefaultCopyDrop, this.img, new Point(this.x, this.y), t, this);
        }
        catch (InvalidDnDOperationException ex) {
            AndroidEditor.instance().error(ex);
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent arg0) {
    }
}

