/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.property;

import java.beans.PropertyChangeEvent;
import org.droiddraw.property.Property;

public class BooleanProperty
extends Property {
    boolean value;
    boolean defaultValue;

    public BooleanProperty(String englishName, String attName, boolean defaultValue) {
        this(englishName, attName, defaultValue, true);
        this.defaultValue = defaultValue;
    }

    public BooleanProperty(String englishName, String attName, boolean defaultValue, boolean editable) {
        super(englishName, attName, editable);
        this.value = defaultValue;
    }

    protected boolean isDefaultInternal() {
        return this.value == this.defaultValue;
    }

    public Object getValue() {
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    public void setBooleanValue(boolean b) {
        boolean old = this.value;
        this.value = b;
        this.firePropertyChangedEvent(new PropertyChangeEvent(this, this.getAtttributeName(), old, b));
    }

    public void setValue(String value) {
        if ("true".equals(value)) {
            this.setBooleanValue(true);
        } else if ("false".equals(value)) {
            this.setBooleanValue(false);
        }
    }
}

