/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.property;

import java.awt.Color;
import org.droiddraw.AndroidEditor;
import org.droiddraw.property.StringProperty;

public class ColorProperty
extends StringProperty {
    Color c;
    Color defaultColor;

    public ColorProperty(String englishName, String attName, Color defaultValue) {
        super(englishName, attName, ColorProperty.makeColor(defaultValue));
        this.c = defaultValue;
        this.defaultColor = defaultValue;
    }

    protected boolean isDefaultInternal() {
        if (this.c == null) {
            return true;
        }
        return this.c.equals(this.defaultColor);
    }

    public void setStringValue(String col) {
        if (col == null || col.length() == 0) {
            this.setColorValue(null);
        } else {
            try {
                this.setColorValue(ColorProperty.parseColor(col));
                if (col.startsWith("@")) {
                    super.setStringValue(col);
                }
            }
            catch (NumberFormatException ex) {
                AndroidEditor.instance().error(ex);
            }
        }
    }

    public static Color parseColor(String col) {
        int b;
        int g;
        int r;
        int a;
        if (col.length() == 0) {
            return null;
        }
        if (col.startsWith("@")) {
            int ix = col.indexOf("/");
            String name = col.substring(ix + 1);
            if (AndroidEditor.instance().getColors() != null) {
                return AndroidEditor.instance().getColors().get(name);
            }
            return null;
        }
        switch (col.length()) {
            case 4: {
                a = 255;
                r = ColorProperty.readHex(col.substring(1, 2));
                g = ColorProperty.readHex(col.substring(2, 3));
                b = ColorProperty.readHex(col.substring(3));
                break;
            }
            case 5: {
                a = ColorProperty.readHex(col.substring(1, 2));
                r = ColorProperty.readHex(col.substring(2, 3));
                g = ColorProperty.readHex(col.substring(3, 4));
                b = ColorProperty.readHex(col.substring(4));
                break;
            }
            case 7: {
                a = 255;
                r = ColorProperty.readHex(col.substring(1, 3));
                g = ColorProperty.readHex(col.substring(3, 5));
                b = ColorProperty.readHex(col.substring(5));
                break;
            }
            case 9: {
                a = ColorProperty.readHex(col.substring(1, 3));
                r = ColorProperty.readHex(col.substring(3, 5));
                g = ColorProperty.readHex(col.substring(5, 7));
                b = ColorProperty.readHex(col.substring(7));
                break;
            }
            default: {
                throw new NumberFormatException(col);
            }
        }
        return new Color(r, g, b, a);
    }

    public Color getColorValue() {
        return this.c;
    }

    public void setColorValue(Color c) {
        this.c = c;
        super.setStringValue(ColorProperty.makeColor(this.c));
    }

    public static final int readHex(String in) {
        return Integer.parseInt(in, 16);
    }

    public static final String makeColor(Color c) {
        if (c == null) {
            return "";
        }
        return "#" + ColorProperty.hexString(c.getAlpha()) + ColorProperty.hexString(c.getRed()) + ColorProperty.hexString(c.getGreen()) + ColorProperty.hexString(c.getBlue());
    }

    public static final String hexString(int c) {
        String res = Integer.toHexString(c);
        if (res.length() == 1) {
            res = "0" + res;
        }
        return res;
    }
}

