/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.property;

import java.beans.PropertyChangeEvent;
import org.droiddraw.AndroidEditor;
import org.droiddraw.property.Property;

public class StringProperty
extends Property {
    String value;
    String defaultValue;

    public StringProperty(String englishName, String attName, String defaultValue) {
        this(englishName, attName, defaultValue, true);
        this.defaultValue = defaultValue;
    }

    public StringProperty(String englishName, String attName, String defaultValue, boolean editable) {
        super(englishName, attName, editable);
        this.value = defaultValue;
    }

    protected boolean isDefaultInternal() {
        return this.value.equals(this.defaultValue);
    }

    public Object getValue() {
        return this.getStringValue();
    }

    public String getStringValue() {
        if (this.value != null && this.value.startsWith("@string") && AndroidEditor.instance().getStrings() != null) {
            String key = this.value.substring(this.value.indexOf("/") + 1);
            String str = AndroidEditor.instance().getStrings().get(key);
            if (str == null) {
                str = this.value;
            }
            return str;
        }
        return this.value;
    }

    public void setStringValue(String value) {
        this.setStringValue(value, false);
    }

    public void setStringValue(String value, boolean setDefault) {
        String old = this.value;
        this.value = value;
        if (setDefault) {
            this.defaultValue = value;
        }
        this.firePropertyChangedEvent(new PropertyChangeEvent(this, this.getAtttributeName(), old, value));
    }

    public void setValue(String value) {
        this.setStringValue(value);
    }
}

