/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.util;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.droiddraw.property.ColorProperty;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorHandler
extends DefaultHandler {
    Hashtable<String, Color> colors = new Hashtable();
    StringBuffer buff = new StringBuffer();
    String name;

    @Override
    public void characters(char[] arg0, int arg1, int arg2) {
        this.buff.append(arg0, arg1, arg2);
    }

    @Override
    public void startDocument() {
        this.colors.clear();
    }

    @Override
    public void startElement(String ns, String lName, String qName, Attributes atts) {
        this.buff.setLength(0);
        if (qName.equals("color")) {
            this.name = atts.getValue("name");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("color")) {
            this.colors.put(this.name, ColorProperty.parseColor(this.buff.toString()));
        }
    }

    public Hashtable<String, Color> getColors() {
        return this.colors;
    }

    public static Hashtable<String, Color> load(InputStream is) throws SAXException, ParserConfigurationException, IOException {
        return ColorHandler.load(new InputSource(is));
    }

    public static Hashtable<String, Color> load(InputSource in) throws SAXException, ParserConfigurationException, IOException {
        ColorHandler sh = new ColorHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)sh);
        return sh.getColors();
    }

    public static void dump(Writer w, Hashtable<String, Color> colors) throws IOException {
        PrintWriter pw = new PrintWriter(w);
        pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        pw.println("<resources>");
        for (String key : colors.keySet()) {
            Color value = colors.get(key);
            String clr = "#" + Integer.toString(value.getRed(), 16) + Integer.toString(value.getGreen(), 16) + Integer.toString(value.getBlue(), 16) + Integer.toString(value.getAlpha(), 16);
            pw.println("<drawable name=\"" + key + "\">" + clr + "</drawable>");
        }
        pw.println("</resources>");
        pw.flush();
        w.flush();
    }
}

