/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.util;

import org.droiddraw.property.StringProperty;

public class DisplayMetrics {
    public static float density = 1.0f;
    public static float scaledDensity = 1.0f;
    public static float xdpi = 160.0f;
    public static float ydpi = 160.0f;
    public static final float MM_TO_IN = 0.03937008f;
    public static final float PT_TO_IN = 0.013888889f;

    public static int readSize(StringProperty prop) {
        return DisplayMetrics.readSize(prop.getStringValue());
    }

    public static int readSize(String sz) {
        if (sz == null) {
            return -1;
        }
        try {
            float size = sz.endsWith("dip") ? Float.parseFloat(sz.substring(0, sz.length() - 3)) : Float.parseFloat(sz.substring(0, sz.length() - 2));
            if (sz.endsWith("px")) {
                return (int)size;
            }
            if (sz.endsWith("in")) {
                return (int)(size * xdpi);
            }
            if (sz.endsWith("mm")) {
                return (int)(size * 0.03937008f * xdpi);
            }
            if (sz.endsWith("pt")) {
                return (int)(size * 0.013888889f * xdpi);
            }
            if (sz.endsWith("dp") || sz.endsWith("dip")) {
                return (int)(size * density);
            }
            if (sz.endsWith("sp")) {
                return (int)(size * scaledDensity);
            }
            return Integer.parseInt(sz);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

