/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.droiddraw.AndroidEditor;
import org.droiddraw.util.DisplayMetrics;
import org.droiddraw.widget.AbsoluteLayout;
import org.droiddraw.widget.AbstractLayout;
import org.droiddraw.widget.AbstractWidget;
import org.droiddraw.widget.AnalogClock;
import org.droiddraw.widget.AutoCompleteTextView;
import org.droiddraw.widget.Button;
import org.droiddraw.widget.CheckBox;
import org.droiddraw.widget.DatePicker;
import org.droiddraw.widget.DigitalClock;
import org.droiddraw.widget.EditView;
import org.droiddraw.widget.FrameLayout;
import org.droiddraw.widget.Gallery;
import org.droiddraw.widget.GridView;
import org.droiddraw.widget.ImageButton;
import org.droiddraw.widget.ImageView;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.LinearLayout;
import org.droiddraw.widget.ListView;
import org.droiddraw.widget.ProgressBar;
import org.droiddraw.widget.RadioButton;
import org.droiddraw.widget.RadioGroup;
import org.droiddraw.widget.RatingBar;
import org.droiddraw.widget.RelativeLayout;
import org.droiddraw.widget.ScrollView;
import org.droiddraw.widget.Spinner;
import org.droiddraw.widget.TableLayout;
import org.droiddraw.widget.TableRow;
import org.droiddraw.widget.TextView;
import org.droiddraw.widget.Ticker;
import org.droiddraw.widget.TimePicker;
import org.droiddraw.widget.View;
import org.droiddraw.widget.Widget;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DroidDrawHandler
extends DefaultHandler {
    Vector<String> all_props = new Vector();
    Stack<Vector<String>> layout_props;
    Stack<Layout> layoutStack;

    public DroidDrawHandler() {
        this.all_props.add("android:layout_width");
        this.all_props.add("android:layout_height");
        this.all_props.add("android:background");
        this.all_props.add("android:padding");
        this.all_props.add("android:id");
        this.all_props.add("android:visibility");
        this.all_props.add("android:layout_marginTop");
        this.all_props.add("android:layout_marginBottom");
        this.all_props.add("android:layout_marginLeft");
        this.all_props.add("android:layout_marginRight");
        this.layout_props = new Stack();
        this.layoutStack = new Stack();
    }

    protected boolean isLayout(String name) {
        return name.endsWith("Layout") || name.equals("RadioGroup") || name.equals("Ticker") || name.equals("TableRow") || name.equals("ScrollView");
    }

    public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
        if (this.isLayout(qName)) {
            AbstractLayout l = null;
            Vector<String> l_props = new Vector<String>();
            if (qName.equals("AbsoluteLayout")) {
                l = new AbsoluteLayout();
            } else if (qName.equals("LinearLayout") || qName.equals("RadioGroup")) {
                if (qName.equals("LinearLayout")) {
                    l = new LinearLayout();
                } else if (qName.equals("RadioGroup")) {
                    l = new RadioGroup();
                    l.setPropertyByAttName("android:checkedButton", this.getValue(atts, "android:checkedButton"));
                }
                l.setPropertyByAttName("android:gravity", this.getValue(atts, "android:gravity"));
                if (this.getValue(atts, "android:orientation") == null) {
                    l.setPropertyByAttName("android:orientation", "horizontal");
                } else {
                    l.setPropertyByAttName("android:orientation", this.getValue(atts, "android:orientation"));
                }
                l_props.add("android:layout_gravity");
                l_props.add("android:layout_weight");
            } else if (qName.equals("RelativeLayout")) {
                l = new RelativeLayout();
                int i = 0;
                while (i < RelativeLayout.propNames.length) {
                    l_props.add(RelativeLayout.propNames[i]);
                    ++i;
                }
            } else if (qName.equals("FrameLayout")) {
                l = new FrameLayout();
            } else if (qName.equals("TableLayout")) {
                l = new TableLayout();
                l.setPropertyByAttName("android:stretchColumns", this.getValue(atts, "android:stretchColumns"));
            } else if (qName.equals("TableRow")) {
                l = new TableRow();
                l_props.add("android:layout_column");
                l_props.add("android:layout_span");
            } else if (qName.equals("Ticker")) {
                l = new Ticker();
            } else if (qName.equals("ScrollView")) {
                l = new ScrollView();
            }
            if (this.layoutStack.size() == 0) {
                l.setPosition(AndroidEditor.OFFSET_X, AndroidEditor.OFFSET_Y);
                for (String prop : this.all_props) {
                    if (this.getValue(atts, prop) == null) continue;
                    l.setPropertyByAttName(prop, this.getValue(atts, prop));
                }
                l.apply();
                AndroidEditor.instance().setLayout(l, false);
            } else {
                this.addWidget(l, atts);
            }
            this.layoutStack.push(l);
            this.layout_props.push(l_props);
        } else {
            if (this.layoutStack.size() == 0) {
                throw new SAXException("Error, no Layout!");
            }
            AbstractWidget w = null;
            if (qName.equals("Button")) {
                String txt = this.getValue(atts, "android:text");
                Button b = new Button(txt);
                w = b;
            } else if (qName.equals("TextView")) {
                String txt = this.getValue(atts, "android:text");
                w = new TextView(txt);
                if (this.getValue(atts, "android:textAlign") != null) {
                    w.setPropertyByAttName("android:textAlign", this.getValue(atts, "android:textAlign"));
                }
            } else if (qName.equals("EditText")) {
                String txt = this.getValue(atts, "android:text");
                EditView et = new EditView(txt);
                String hint = this.getValue(atts, "android:hint");
                if (hint != null) {
                    et.setPropertyByAttName("android:hint", hint);
                }
                int i = 0;
                while (i < EditView.propertyNames.length) {
                    et.setPropertyByAttName(EditView.propertyNames[i], this.getValue(atts, EditView.propertyNames[i]));
                    ++i;
                }
                w = et;
            } else if (qName.equals("CheckBox") || qName.equals("RadioButton")) {
                String txt = this.getValue(atts, "android:text");
                if (qName.equals("CheckBox")) {
                    w = new CheckBox(txt);
                } else if (qName.equals("RadioButton")) {
                    w = new RadioButton(txt);
                }
                w.setPropertyByAttName("android:checked", this.getValue(atts, "android:checked"));
            } else if (qName.equals("DigitalClock")) {
                w = new DigitalClock();
            } else if (qName.equals("AnalogClock")) {
                w = new AnalogClock();
            } else if (qName.equals("TimePicker")) {
                w = new TimePicker();
            } else if (qName.equals("ListView")) {
                w = new ListView();
            } else if (qName.equals("Spinner")) {
                w = new Spinner();
            } else if (qName.equals("AutoCompleteTextView")) {
                w = new AutoCompleteTextView("AutoComplete");
            } else if (qName.equals("ImageButton")) {
                w = new ImageButton();
                w.setPropertyByAttName("android:src", this.getValue(atts, "android:src"));
            } else if (qName.equals("ImageView")) {
                w = new ImageView();
                w.setPropertyByAttName("android:src", this.getValue(atts, "android:src"));
            } else if (qName.equals("ProgressBar") || qName.equals("RatingBar")) {
                int i;
                if (qName.equals("ProgressBar")) {
                    w = new ProgressBar();
                } else {
                    w = new RatingBar();
                    i = 0;
                    while (i < RatingBar.propertyNames.length) {
                        w.setPropertyByAttName(RatingBar.propertyNames[i], this.getValue(atts, RatingBar.propertyNames[i]));
                        ++i;
                    }
                }
                i = 0;
                while (i < ProgressBar.propertyNames.length) {
                    w.setPropertyByAttName(ProgressBar.propertyNames[i], this.getValue(atts, ProgressBar.propertyNames[i]));
                    ++i;
                }
            } else if (qName.equals("View")) {
                w = new View();
            } else if (qName.equals("GridView")) {
                w = new GridView();
                int i = 0;
                while (i < GridView.propertyNames.length) {
                    w.setPropertyByAttName(GridView.propertyNames[i], this.getValue(atts, GridView.propertyNames[i]));
                    ++i;
                }
            } else if (qName.equals("Gallery")) {
                w = new Gallery();
                int i = 0;
                while (i < Gallery.propertyNames.length) {
                    w.setPropertyByAttName(Gallery.propertyNames[i], this.getValue(atts, Gallery.propertyNames[i]));
                    ++i;
                }
            } else if (qName.equals("DatePicker")) {
                w = new DatePicker();
            }
            if (w != null) {
                this.addWidget(w, atts);
            }
        }
    }

    public void endElement(String ns, String lName, String qName) {
        if (this.isLayout(qName)) {
            this.layout_props.pop();
            this.layoutStack.pop();
        }
    }

    protected void addWidget(Widget w, Attributes atts) {
        if (w instanceof TextView) {
            int i = 0;
            while (i < TextView.propertyNames.length) {
                w.setPropertyByAttName(TextView.propertyNames[i], this.getValue(atts, TextView.propertyNames[i]));
                ++i;
            }
        }
        for (String prop : this.all_props) {
            if (this.getValue(atts, prop) == null) continue;
            w.setPropertyByAttName(prop, this.getValue(atts, prop));
        }
        for (String prop : this.layout_props.peek()) {
            if (this.getValue(atts, prop) == null) continue;
            w.setPropertyByAttName(prop, this.getValue(atts, prop));
        }
        Layout layout = this.layoutStack.peek();
        w.apply();
        if (layout instanceof LinearLayout) {
            w.setPosition(layout.getWidth(), layout.getHeight());
        }
        layout.addWidget(w);
        if (layout instanceof AbsoluteLayout) {
            int x = DisplayMetrics.readSize(this.getValue(atts, "android:layout_x"));
            int y = DisplayMetrics.readSize(this.getValue(atts, "android:layout_y"));
            w.setPropertyByAttName("android:layout_x", this.getValue(atts, "android:layout_x"));
            w.setPropertyByAttName("android:layout_y", this.getValue(atts, "android:layout_y"));
            w.setPosition(x, y);
        }
    }

    private String getValue(Attributes atts, String name) {
        return StringEscapeUtils.unescapeXml(atts.getValue(name));
    }

    public static void loadFromString(String content) throws SAXException, ParserConfigurationException, IOException {
        DroidDrawHandler.load(new InputSource(new StringReader(content)));
    }

    public static void load(File f) throws SAXException, ParserConfigurationException, IOException, FileNotFoundException {
        DroidDrawHandler.load(new FileReader(f));
    }

    public static void load(Reader r) throws SAXException, ParserConfigurationException, IOException {
        DroidDrawHandler.load(new InputSource(r));
    }

    public static void load(InputSource in) throws SAXException, ParserConfigurationException, IOException {
        DroidDrawHandler ddh = new DroidDrawHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)ddh);
        AndroidEditor.instance().getLayout().repositionAllWidgets();
    }
}

