/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHandler
extends DefaultHandler {
    Hashtable<String, String> strings = new Hashtable();
    StringBuffer buff = new StringBuffer();
    String name;

    @Override
    public void characters(char[] arg0, int arg1, int arg2) {
        this.buff.append(arg0, arg1, arg2);
    }

    @Override
    public void startDocument() {
        this.strings.clear();
    }

    @Override
    public void startElement(String ns, String lName, String qName, Attributes atts) {
        this.buff.setLength(0);
        if (qName.equals("string")) {
            this.name = atts.getValue("name");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("string")) {
            String str = this.buff.toString();
            while (str.indexOf("\\u") != -1) {
                int ix = str.indexOf("\\u");
                int code = Integer.parseInt(str.substring(ix + 2, ix + 6), 16);
                str = String.valueOf(str.substring(0, ix)) + (char)code + str.substring(ix + 6);
            }
            while (str.indexOf("\\n") != -1) {
                str = str.replace("\\n", "\n");
            }
            this.strings.put(this.name, str);
        }
    }

    public Hashtable<String, String> getStrings() {
        return this.strings;
    }

    public static Hashtable<String, String> load(InputStream is) throws SAXException, ParserConfigurationException, IOException {
        return StringHandler.load(new InputSource(is));
    }

    public static Hashtable<String, String> load(InputSource in) throws SAXException, ParserConfigurationException, IOException {
        StringHandler sh = new StringHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)sh);
        return sh.getStrings();
    }

    public static void dump(Writer w, Hashtable<String, String> strings) throws IOException {
        PrintWriter pw = new PrintWriter(w);
        pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        pw.println("<resources>");
        for (String key : strings.keySet()) {
            String value = strings.get(key);
            pw.println("<string name=\"" + key + "\">" + value + "</string>");
        }
        pw.println("</resources>");
        pw.flush();
        w.flush();
    }
}

