/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import org.droiddraw.AndroidEditor;
import org.droiddraw.widget.AbstractWidget;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayout
extends AbstractWidget
implements Layout {
    protected Vector<Widget> widgets = new Vector();

    public AbstractLayout(String tagName) {
        super(tagName);
        this.apply();
    }

    public String toString() {
        return this.getTagName();
    }

    @Override
    public void addWidget(Widget w) {
        assert (w != this);
        this.widgets.add(w);
        w.setParent(this);
        this.addEditableProperties(w);
        this.positionWidget(w);
        this.readWidthHeight();
        if (this.getParent() != null) {
            this.getParent().repositionAllWidgets();
        }
    }

    @Override
    public Vector<Widget> getWidgets() {
        return this.widgets;
    }

    @Override
    public void removeWidget(Widget w) {
        this.widgets.remove(w);
        this.removeEditableProperties(w);
        this.repositionAllWidgets();
    }

    @Override
    public void removeAllWidgets() {
        for (Widget w : this.widgets) {
            this.removeEditableProperties(w);
        }
        this.widgets.clear();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.drawBackground(g);
        g2d.translate(this.getX(), this.getY());
        g.setColor(Color.black);
        if (this.widgets.size() == 0) {
            g.drawString(this.getTagName(), 2, 15);
        }
        g.drawRect(0, 0, this.getWidth(), this.getHeight());
        for (Widget w : this.widgets) {
            if (!w.isVisible()) continue;
            w.paint(g);
        }
        g2d.translate(-this.getX(), -this.getY());
    }

    @Override
    public int getContentWidth() {
        if (this.widgets.size() > 0) {
            int maxX = 0;
            for (Widget w : this.widgets) {
                int width_w_pad = w.getWidth() + w.getPadding(3);
                if (w.getX() + width_w_pad <= maxX) continue;
                maxX = w.getX() + width_w_pad;
            }
            return maxX;
        }
        return 100;
    }

    @Override
    public int getContentHeight() {
        if (this.widgets.size() > 0) {
            int maxY = 0;
            for (Widget w : this.widgets) {
                int height_w_pad = w.getHeight() + w.getPadding(2);
                if (w.getY() + height_w_pad <= maxY) continue;
                maxY = w.getY() + height_w_pad;
            }
            return maxY;
        }
        return 20;
    }

    @Override
    public abstract void positionWidget(Widget var1);

    @Override
    public abstract void repositionAllWidgets();

    @Override
    public int getScreenX() {
        if (this.parent != null && this.parent != this) {
            return this.parent.getScreenX() + this.getX();
        }
        return this.getX();
    }

    @Override
    public int getScreenY() {
        if (this.parent != null && this.parent != this) {
            return this.parent.getScreenY() + this.getY();
        }
        return this.getY();
    }

    @Override
    public void resizeForRendering() {
        for (Widget w : this.widgets) {
            if (!(w instanceof Layout)) continue;
            ((Layout)w).resizeForRendering();
        }
    }

    @Override
    public void clearRendering() {
        for (Widget w : this.widgets) {
            w.apply();
            if (!(w instanceof Layout)) continue;
            ((Layout)w).clearRendering();
        }
    }

    @Override
    public boolean containsWidget(Widget w) {
        for (Widget wt : this.widgets) {
            if (wt.equals(w)) {
                return true;
            }
            if (!(wt instanceof Layout) || !((Layout)wt).containsWidget(w)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Widget copy() {
        AndroidEditor.instance().error("Cloning layouts is not supported (yet)");
        return null;
    }
}

