/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.droiddraw.AndroidEditor;
import org.droiddraw.property.ColorProperty;
import org.droiddraw.property.Property;
import org.droiddraw.property.SelectProperty;
import org.droiddraw.property.StringProperty;
import org.droiddraw.property.WidthProperty;
import org.droiddraw.util.DisplayMetrics;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWidget
implements Widget {
    int x;
    int y;
    int[] padding;
    int baseline;
    int width;
    int height;
    private String tagName;
    Vector<Property> props;
    PropertyChangeListener listener;
    protected StringProperty id;
    protected static int widget_num = 0;
    Layout parent;
    WidthProperty widthProp;
    WidthProperty heightProp;
    StringProperty pad;
    StringProperty visibility;
    StringProperty marginBottom;
    StringProperty marginTop;
    StringProperty marginLeft;
    StringProperty marginRight;
    ColorProperty background;

    public AbstractWidget(String tagName) {
        this.setTagName(tagName);
        this.props = new Vector();
        this.id = new StringProperty("Id", "android:id", "");
        this.id.setStringValue("@+id/widget" + widget_num++);
        this.widthProp = new WidthProperty("Width", "android:layout_width", "");
        this.widthProp.setStringValue("wrap_content");
        this.heightProp = new WidthProperty("Height", "android:layout_height", "");
        this.heightProp.setStringValue("wrap_content");
        this.background = new ColorProperty("Background Color", "android:background", null);
        this.pad = new StringProperty("Padding", "android:padding", "0px");
        this.visibility = new SelectProperty("Visible", "android:visibility", new String[]{"visible", "invisible", "gone"}, 0);
        this.marginTop = new StringProperty("Top Margin", "android:layout_marginTop", "0px");
        this.marginBottom = new StringProperty("Bottom Margin", "android:layout_marginBottom", "0px");
        this.marginLeft = new StringProperty("Left Margin", "android:layout_marginLeft", "0px");
        this.marginRight = new StringProperty("Right Margin", "android:layout_marginRight", "0px");
        this.padding = new int[4];
        this.props.add(this.id);
        this.props.add(this.widthProp);
        this.props.add(this.heightProp);
        this.props.add(this.background);
        this.props.add(this.pad);
        this.props.add(this.visibility);
        this.props.add(this.marginTop);
        this.props.add(this.marginBottom);
        this.props.add(this.marginLeft);
        this.props.add(this.marginRight);
        this.baseline = 14;
        this.parent = null;
    }

    @Override
    public void setPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    @Override
    public Layout getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Layout parent) {
        this.parent = parent;
        ((AbstractWidget)((Object)parent)).parentTest(this);
    }

    public void parentTest(Widget w) {
        try {
            if (w == this) {
                throw new IllegalArgumentException("BAD!");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
        if (this.getParent() != null) {
            ((AbstractWidget)((Object)this.getParent())).parentTest(w);
        }
    }

    @Override
    public String getId() {
        return this.id.getStringValue();
    }

    public void setId(String id) {
        this.id.setStringValue(id);
    }

    @Override
    public Vector<Property> getProperties() {
        return this.props;
    }

    @Override
    public void addProperty(Property p) {
        if (!this.props.contains(p)) {
            this.props.add(p);
        }
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "properties", null, this.props));
        }
    }

    @Override
    public void removeProperty(Property p) {
        this.props.remove(p);
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "properties", null, this.props));
        }
    }

    @Override
    public Property getPropertyByAttName(String attName) {
        for (Property prop : this.props) {
            if (!prop.getAtttributeName().equals(attName)) continue;
            return prop;
        }
        return null;
    }

    @Override
    public boolean propertyHasValueByAttName(String attName, Object value) {
        for (Property prop : this.props) {
            if (!prop.getAtttributeName().equals(attName) || !prop.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPropertyByAttName(String attName, String value) {
        Property p = this.getPropertyByAttName(attName);
        if (p != null) {
            p.setValue(value);
        } else {
            this.props.add(new StringProperty(attName, attName, value));
        }
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setWidth(int width) {
        this.widthProp.setStringValue(String.valueOf(width) + "px");
        this.apply();
    }

    @Override
    public void setHeight(int height) {
        this.heightProp.setStringValue(String.valueOf(height) + "px");
        this.apply();
    }

    @Override
    public void setSize(int width, int height) {
        this.widthProp.setStringValue(String.valueOf(width) + "px");
        this.heightProp.setStringValue(String.valueOf(height) + "px");
        this.apply();
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean clickedOn(int x, int y) {
        int off_x = 0;
        int off_y = 0;
        if (this.parent != null) {
            off_x = this.parent.getScreenX();
            off_y = this.parent.getScreenY();
        }
        return x > this.getX() + off_x && x < this.getX() + off_x + this.getWidth() && y > this.getY() + off_y && y < this.getY() + this.getHeight() + off_y;
    }

    @Override
    public void move(int dx, int dy) {
        this.setPosition(this.x + dx, this.y + dy);
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    protected void readWidthHeight() {
        StringProperty prop;
        int w = DisplayMetrics.readSize(this.widthProp);
        int h = DisplayMetrics.readSize(this.heightProp);
        if (w < 0) {
            w = this.getWidth();
        }
        if (h < 0) {
            h = this.getHeight();
        }
        try {
            this.setPadding(DisplayMetrics.readSize(this.pad.getStringValue()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.widthProp.getStringValue().equals("wrap_content")) {
            w = this.getContentWidth();
        }
        if (this.heightProp.getStringValue().equals("wrap_content")) {
            h = this.getContentHeight();
        }
        if (this.widthProp.getStringValue().equals("fill_parent")) {
            w = this.getParent() != null ? ((prop = (StringProperty)this.parent.getPropertyByAttName("android:layout_width")).getStringValue().equals("wrap_content") ? this.getContentWidth() : this.getParent().getWidth()) : AndroidEditor.instance().getScreenX() - AndroidEditor.OFFSET_X;
            w = w - this.getX() - this.padding[3];
        }
        if (this.heightProp.getStringValue().equals("fill_parent")) {
            h = this.getParent() != null ? ((prop = (StringProperty)this.parent.getPropertyByAttName("android:layout_height")).getStringValue().equals("wrap_content") ? this.getContentHeight() : this.getParent().getHeight()) : AndroidEditor.instance().getScreenY();
            h = h - this.getY() - this.padding[2];
        }
        this.width = w;
        this.height = h;
    }

    @Override
    public void apply() {
        this.readWidthHeight();
        if (this.getParent() == null) {
            this.setPosition(this.getPadding(1) + AndroidEditor.OFFSET_X, this.getPadding(0) + AndroidEditor.OFFSET_Y);
        }
        if (this.widthProp.getStringValue().equals("fill_parent")) {
            this.x = this.padding[1];
        }
        if (this.heightProp.getStringValue().equals("fill_parent") && this.getParent() != null) {
            this.y = this.padding[0];
        }
    }

    @Override
    public void setSizeInternal(int w, int h) {
        this.width = w;
        this.height = h;
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    public void drawBackground(Graphics g) {
        if (this.background.getColorValue() != null) {
            g.setColor(this.background.getColorValue());
            g.fillRect(this.getX() - this.getPadding(1), this.getY() - this.getPadding(0), this.getWidth() + this.getPadding(1) + this.getPadding(3), this.getHeight() + this.getPadding(0) + this.getPadding(2));
        }
    }

    @Override
    public void setPadding(int pad) {
        this.setPadding(pad, 0);
        this.setPadding(pad, 1);
        this.setPadding(pad, 2);
        this.setPadding(pad, 3);
    }

    @Override
    public void setPadding(int pad, int which) {
        this.padding[which] = pad;
    }

    @Override
    public int getPadding(int which) {
        return this.padding[which];
    }

    @Override
    public int getMargin(int which) {
        switch (which) {
            case 0: {
                return DisplayMetrics.readSize(this.marginTop);
            }
            case 2: {
                return DisplayMetrics.readSize(this.marginBottom);
            }
            case 1: {
                return DisplayMetrics.readSize(this.marginLeft);
            }
            case 3: {
                return DisplayMetrics.readSize(this.marginRight);
            }
        }
        return 0;
    }

    @Override
    public boolean isVisible() {
        return this.visibility.getStringValue().equals("visible");
    }

    protected abstract int getContentWidth();

    protected abstract int getContentHeight();

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public Widget copy() {
        try {
            AbstractWidget w = (AbstractWidget)this.clone();
            w.setId("@+id/widget" + widget_num++);
            return w;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

