/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.widget.AbstractWidget;

public class AnalogClock
extends AbstractWidget {
    public static final String TAG_NAME = "AnalogClock";
    BufferedImage face;
    BufferedImage face_scale;
    BufferedImage hour;
    BufferedImage hour_scale;
    BufferedImage minute;
    BufferedImage minute_scale;
    int offx;

    public AnalogClock() {
        super(TAG_NAME);
        this.apply();
        if (this.face == null) {
            Image img = ImageResources.instance().getImage("light/clock_dial");
            if (img != null) {
                this.face = new BufferedImage(img.getWidth(null), img.getHeight(null), 6);
                this.face.getGraphics().drawImage(img, 0, 0, null);
                this.face_scale = this.face;
            }
            if ((img = ImageResources.instance().getImage("light/clock_hand_hour")) != null) {
                this.hour = new BufferedImage(img.getWidth(null), img.getHeight(null), 6);
                this.hour.getGraphics().drawImage(img, 0, 0, null);
                this.hour_scale = this.hour;
            }
            if ((img = ImageResources.instance().getImage("light/clock_hand_minute")) != null) {
                this.minute = new BufferedImage(img.getWidth(null), img.getHeight(null), 6);
                this.minute.getGraphics().drawImage(img, 0, 0, null);
                this.minute_scale = this.minute;
            }
            this.offx = 14;
        }
    }

    protected int getContentHeight() {
        return 154;
    }

    protected int getContentWidth() {
        return 154;
    }

    public void apply() {
        super.apply();
        if (this.face != null) {
            double scale_x = (double)this.getWidth() / 154.0;
            double scale_y = (double)this.getHeight() / 154.0;
            AffineTransform at = AffineTransform.getScaleInstance(scale_x, scale_y);
            AffineTransformOp op = new AffineTransformOp(at, 2);
            this.face_scale = new BufferedImage(this.getWidth(), this.getHeight(), 6);
            op.filter(this.face, this.face_scale);
            this.hour_scale = new BufferedImage((int)((double)this.hour.getWidth() * scale_x), (int)((double)this.hour.getHeight() * scale_y), 6);
            op.filter(this.hour, this.hour_scale);
            this.minute_scale = new BufferedImage((int)((double)this.minute.getWidth() * scale_x), (int)((double)this.minute.getHeight() * scale_y), 6);
            op.filter(this.minute, this.minute_scale);
            this.offx = (int)(14.0 * scale_x);
        }
    }

    private void drawAngleLine(Graphics g, double angle, double scale) {
        int dx = (int)(Math.cos(angle) * (double)this.getWidth() * scale);
        int dy = (int)(Math.sin(angle) * (double)this.getWidth() * scale);
        int cx = this.getX() + this.getWidth() / 2;
        int cy = this.getY() + this.getHeight() / 2;
        g.drawLine(cx, cy, cx + dx, cy - dy);
    }

    public void paint(Graphics g) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int hrs = c.get(10);
        int min = c.get(12);
        double hr_a = Math.toRadians(90.0 - ((double)hrs + (double)min / 60.0) * 30.0);
        double hr_m = Math.toRadians(90 - min * 6);
        if (this.face_scale == null) {
            g.setColor(Color.white);
            g.fillOval(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            g.drawOval(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            this.drawAngleLine(g, hr_a, 0.25);
            this.drawAngleLine(g, hr_m, 0.45);
        } else {
            g.drawImage(this.face_scale, this.getX(), this.getY(), null);
            g.drawImage(this.minute_scale, this.getX() + this.getWidth() / 2 - this.offx, this.getY(), null);
            g.drawImage(this.hour_scale, this.getX() + this.getWidth() / 2 - this.offx, this.getY(), null);
        }
    }
}

