/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import org.droiddraw.AndroidEditor;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.gui.NineWayImage;
import org.droiddraw.property.StringProperty;
import org.droiddraw.widget.TextView;

public class Button
extends TextView {
    public static final String TAG_NAME = "Button";
    NineWayImage img;
    Image img_base;
    StringProperty onClick;

    public Button(String txt) {
        super(txt);
        this.setTagName(TAG_NAME);
        this.pad_x = 10;
        this.pad_y = 0;
        this.img_base = null;
        String theme = AndroidEditor.instance().getTheme();
        if (theme == null || theme.equals("default")) {
            this.img_base = ImageResources.instance().getImage("def/btn_default_normal.9");
            if (this.img_base != null) {
                this.img = new NineWayImage(this.img_base, 10, 10);
            }
        } else if (theme.equals("light")) {
            this.img_base = ImageResources.instance().getImage("light/button_background_normal.9");
            if (this.img_base != null) {
                this.img = new NineWayImage(this.img_base, 10, 10);
            }
        }
        this.onClick = new StringProperty("Click Listener Classname", "android:onClickListener", null);
        this.addProperty(this.onClick);
        this.apply();
    }

    public void apply() {
        super.apply();
        this.baseline = this.fontSize + 2;
    }

    protected int getContentHeight() {
        if (this.img_base != null) {
            return this.img_base.getHeight(null) - 4;
        }
        return 10;
    }

    protected int getContentWidth() {
        int w = super.getContentWidth();
        if (this.img_base != null && w < this.img_base.getWidth(null)) {
            return this.img_base.getWidth(null);
        }
        return w;
    }

    public void paint(Graphics g) {
        if (this.img == null) {
            g.setColor(Color.white);
            g.fillRoundRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 8, 8);
            g.setColor(Color.black);
            g.drawRoundRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 8, 8);
        } else {
            this.img.paint(g, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(Color.black);
        }
        g.setFont(this.f);
        g.setColor(this.textColor.getColorValue());
        this.drawText(g, 0, this.getHeight() / 2 + this.fontSize / 2 - 5, 1);
    }
}

