/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import org.droiddraw.AndroidEditor;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.widget.CompoundButton;

public class CheckBox
extends CompoundButton {
    public static final String TAG_NAME = "CheckBox";
    Image off;
    Image on;

    public CheckBox(String text) {
        super(text);
        this.setTagName(TAG_NAME);
        this.apply();
    }

    public void apply() {
        String theme = AndroidEditor.instance().getTheme();
        if (theme == null || theme.equals("default")) {
            this.off = ImageResources.instance().getImage("def/btn_check_off");
            this.on = ImageResources.instance().getImage("def/btn_check_on");
        } else if (theme.equals("light")) {
            this.off = ImageResources.instance().getImage("light/checkbox_off_background");
            this.on = ImageResources.instance().getImage("light/checkbox_on_background");
        }
        this.pad_x = this.off != null ? this.off.getWidth(null) : 24;
        super.apply();
    }

    protected int getContentHeight() {
        if (this.off != null) {
            return this.off.getHeight(null);
        }
        return super.getContentHeight();
    }

    public void paint(Graphics g) {
        int off_y;
        int off_x;
        if (this.on == null || this.off == null) {
            g.setColor(Color.white);
            g.fillRect(this.getX() + 2, this.getY() + 2, 16, 16);
            g.setColor(Color.black);
            g.drawRect(this.getX() + 2, this.getY() + 2, 16, 16);
            if ("true".equals(this.getPropertyByAttName("android:checked").getValue())) {
                g.drawLine(this.getX() + 2, this.getY() + 2, this.getX() + 18, this.getY() + 18);
                g.drawLine(this.getX() + 2, this.getY() + 18, this.getX() + 18, this.getY() + 2);
            }
            off_x = 20;
            off_y = 18;
        } else {
            Image img = "true".equals(this.getPropertyByAttName("android:checked").getValue()) ? this.on : this.off;
            g.drawImage(img, this.getX(), this.getY(), null);
            g.setColor(Color.black);
            off_x = img.getWidth(null);
            off_y = img.getHeight(null);
        }
        this.baseline = (off_y + this.fontSize) / 2;
        this.setTextColor(g);
        g.setFont(this.f);
        g.drawString(this.text.getStringValue(), this.getX() + off_x, this.getY() + this.baseline - 4);
    }
}

