/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import org.droiddraw.AndroidEditor;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.gui.NineWayImage;
import org.droiddraw.property.BooleanProperty;
import org.droiddraw.property.Property;
import org.droiddraw.property.SelectProperty;
import org.droiddraw.property.StringProperty;
import org.droiddraw.widget.TextView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditView
extends TextView {
    public static final String TAG_NAME = "EditText";
    BooleanProperty password;
    SelectProperty numeric;
    BooleanProperty phone;
    BooleanProperty autoText;
    SelectProperty capitalize;
    StringProperty digits;
    NineWayImage img;
    Image img_base;
    public static final String[] propertyNames = new String[]{"android:password", "android:capitalize", "android:numeric", "android:phoneNumber", "android:autoText", "android:digits"};

    public EditView(String txt) {
        super(txt);
        this.setTagName(TAG_NAME);
        this.password = new BooleanProperty("Password", "android:password", false);
        this.capitalize = new SelectProperty("Capitalize", "android:capitalize", new String[]{"sentences", "words"}, 0);
        this.numeric = new SelectProperty("Number Format", "android:numeric", new String[]{"integer", "signed", "decimal"}, 0);
        this.phone = new BooleanProperty("Phone Number", "android:phoneNumber", false);
        this.autoText = new BooleanProperty("Correct Spelling", "android:autoText", false);
        this.digits = new StringProperty("Valid Characters", "android:digits", "");
        this.props.add(this.password);
        this.props.add(this.numeric);
        this.props.add(this.phone);
        this.props.add(this.autoText);
        this.props.add(this.capitalize);
        this.props.add(this.digits);
        this.img_base = null;
        String theme = AndroidEditor.instance().getTheme();
        if (theme == null || theme.equals("default")) {
            this.fontSz.setStringValue("18sp");
            this.fontSize = 18;
            this.img_base = ImageResources.instance().getImage("mdpi/textfield_default.9");
            if (this.img_base != null) {
                this.img = new NineWayImage(this.img_base, 11, 6);
            }
            this.pad_x = 20;
            this.pad_y = 0;
        } else if (theme.equals("light")) {
            this.img_base = ImageResources.instance().getImage("light/editbox_background_normal.9");
            if (this.img_base != null) {
                this.img = new NineWayImage(this.img_base, 10, 10);
            }
            this.pad_x = 18;
            this.pad_y = 0;
        }
        this.apply();
    }

    @Override
    public Vector<Property> getProperties() {
        Vector<Property> ret = super.getProperties();
        if (this.digits.getStringValue() == null || this.digits.getStringValue().length() < 1) {
            ret.remove(this.digits);
        }
        return ret;
    }

    @Override
    public int getContentWidth() {
        if (this.password != null && this.password.getBooleanValue()) {
            String s = "";
            int i = 0;
            while (i < this.text.getStringValue().length()) {
                s = String.valueOf(s) + '\u00a5';
                ++i;
            }
            return this.stringLength(s) + this.pad_x;
        }
        return super.getContentWidth();
    }

    @Override
    public int getContentHeight() {
        if (this.img_base != null) {
            String theme = AndroidEditor.instance().getTheme();
            if (theme == null || theme.equals("default")) {
                return this.img_base.getHeight(null) - 5;
            }
            if (theme.equals("light")) {
                return this.img_base.getHeight(null) - 5;
            }
        }
        return this.fontSize;
    }

    @Override
    public void paint(Graphics g) {
        if (this.img == null) {
            g.setColor(Color.white);
            g.fillRoundRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 8, 8);
            g.setColor(Color.darkGray);
            g.drawRoundRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 8, 8);
        } else {
            this.img.paint(g, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(Color.darkGray);
        }
        g.setFont(this.f);
        if (this.password.getBooleanValue()) {
            String s = "";
            int i = 0;
            while (i < this.text.getStringValue().length()) {
                s = String.valueOf(s) + '\u00a5';
                ++i;
            }
        } else {
            String s = this.text.getStringValue();
        }
        g.setColor(this.textColor.getColorValue());
        this.drawText(g, 0, (this.fontSize + this.getHeight()) / 2 - 1);
        g.setColor(Color.black);
        g.fillRect(this.getX() + this.pad_x / 2 - 4, this.getY() + (this.getHeight() - this.fontSize) / 2 - 3, 1, this.fontSize + 5);
    }
}

