/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Color;
import java.awt.Graphics;
import org.droiddraw.property.IntProperty;
import org.droiddraw.property.StringProperty;
import org.droiddraw.property.WidthProperty;
import org.droiddraw.widget.AbstractWidget;

public class GridView
extends AbstractWidget {
    public static final String TAG_NAME = "GridView";
    IntProperty columnCount = new IntProperty("Columns", "android:numColumns", -1);
    StringProperty columnWidth;
    WidthProperty hSpacing;
    WidthProperty vSpacing;
    public static final String[] propertyNames = new String[]{"android:numColumns", "android:columnWidth", "android:horizontalSpacing", "android:verticalSpacing"};

    public GridView() {
        super(TAG_NAME);
        this.columnCount.setIntValue(5);
        this.columnWidth = new StringProperty("Column Width", "android:columnWidth", "");
        this.columnWidth.setStringValue("20px");
        this.hSpacing = new WidthProperty("Horiz. Spacing", "android:horizontalSpacing", 0);
        this.vSpacing = new WidthProperty("Vert. Spacing", "android:verticalSpacing", 0);
        this.addProperty(this.columnCount);
        this.addProperty(this.columnWidth);
        this.addProperty(this.hSpacing);
        this.addProperty(this.vSpacing);
        this.apply();
    }

    protected int getContentHeight() {
        return 50;
    }

    protected int getContentWidth() {
        int w;
        int cols = this.columnCount.getIntValue();
        if (cols * (w = this.removePX(this.columnWidth.getStringValue())) > 50) {
            return cols * w;
        }
        return 50;
    }

    public void paint(Graphics g) {
        this.drawBackground(g);
        g.setColor(Color.darkGray);
        g.drawString(TAG_NAME, this.getX() + 3, this.getY() + 16);
        g.setColor(Color.lightGray);
        int i = 1;
        while (i < this.columnCount.getIntValue()) {
            int x = this.getX() + i * this.removePX(this.columnWidth.getStringValue());
            g.drawLine(x, this.getY(), x, this.getY() + this.getHeight());
            if (this.hSpacing.getIntValue() > 0) {
                g.drawLine(x += this.hSpacing.getIntValue(), this.getY(), x, this.getY() + this.getHeight());
            }
            ++i;
        }
    }

    private int removePX(String propertyValue) {
        return Integer.parseInt(propertyValue.substring(0, propertyValue.indexOf("px")));
    }
}

