/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.util.Vector;
import org.droiddraw.property.Property;
import org.droiddraw.property.SelectProperty;
import org.droiddraw.property.StringProperty;
import org.droiddraw.widget.AbstractLayout;
import org.droiddraw.widget.Layout;
import org.droiddraw.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearLayout
extends AbstractLayout {
    public static final String TAG_NAME = "LinearLayout";
    SelectProperty orientation = new SelectProperty("Orientation", "android:orientation", new String[]{"horizontal", "vertical"}, 0);
    SelectProperty gravity;
    boolean vertical;
    int max_base;
    public static int VERTICAL_PADDING = 2;
    public static int HORIZONTAL_PADDING = 2;
    int share;
    private static final String[] OPTIONS = new String[]{"left", "right", "center_horizontal", "top", "bottom", "center_vertical"};

    public LinearLayout() {
        this(true);
    }

    public LinearLayout(boolean vertical) {
        super(TAG_NAME);
        this.orientation.setSelectedIndex(1);
        this.gravity = new SelectProperty("Gravity", "android:gravity", new String[]{"top", "bottom", "left", "right", "center"}, 0);
        this.addProperty(this.orientation);
        this.addProperty(this.gravity);
    }

    @Override
    public void apply() {
        super.apply();
        if (this.orientation != null) {
            this.vertical = "vertical".equals(this.orientation.getStringValue());
        }
    }

    @Override
    public void addWidget(Widget w) {
        if (!this.vertical && !(w instanceof Layout) && w.getBaseline() > this.max_base) {
            this.max_base = w.getBaseline();
        }
        super.addWidget(w);
    }

    @Override
    public void positionWidget(Widget w) {
        this.widgets.remove(w);
        if (this.vertical) {
            int y = w.getY();
            if (y >= -100) {
                int ix = 0;
                while (ix < this.widgets.size() && y > ((Widget)this.widgets.get(ix)).getY()) {
                    ++ix;
                }
                this.widgets.add(ix, w);
            } else {
                this.widgets.add(w);
            }
        } else {
            int x = w.getX();
            if (x >= 0) {
                int ix = 0;
                while (ix < this.widgets.size() && x > ((Widget)this.widgets.get(ix)).getX()) {
                    ++ix;
                }
                this.widgets.add(ix, w);
            } else {
                this.widgets.add(w);
            }
        }
        this.repositionAllWidgets();
    }

    @Override
    public void repositionAllWidgets() {
        for (Widget w : this.widgets) {
            w.apply();
        }
        this.repositionAllWidgetsInternal();
    }

    protected void repositionAllWidgetsInternal() {
        Vector<Widget> with_weight = new Vector<Widget>();
        int max_base = 0;
        int max_base_bottom = 0;
        if (this.gravity == null) {
            return;
        }
        String lGrav = this.gravity.getStringValue();
        int y = 0;
        int x = 0;
        for (Widget w : this.widgets) {
            StringProperty prop;
            if (!this.vertical && !(w instanceof Layout)) {
                if (!w.propertyHasValueByAttName("android:layout_gravity", "bottom") || !this.gravity.isDefault() && lGrav.equals("bottom")) {
                    if (w.getBaseline() > max_base) {
                        max_base = w.getBaseline();
                    }
                } else if (w.getHeight() - w.getBaseline() > max_base_bottom) {
                    max_base_bottom = w.getHeight() - w.getBaseline();
                }
            }
            if ((prop = (StringProperty)w.getPropertyByAttName("android:layout_weight")) != null && "1".equals(prop.getStringValue())) {
                with_weight.add(w);
            }
            if (this.vertical) {
                y += w.getPadding(0) + w.getHeight() + w.getPadding(2) + w.getMargin(0) + w.getMargin(2);
                continue;
            }
            x += w.getPadding(1) + w.getWidth() + w.getPadding(3) + w.getMargin(1) + w.getMargin(3);
        }
        int extra = 0;
        extra = this.vertical ? this.getHeight() - y : this.getWidth() - x;
        if (with_weight.size() > 0) {
            this.share = extra / with_weight.size();
            System.err.println("Share: " + this + " " + this.share);
        }
        y = 0;
        x = 0;
        for (Widget w : this.widgets) {
            String gravity = "left";
            StringProperty prop = (StringProperty)w.getPropertyByAttName("android:layout_gravity");
            if (prop != null) {
                gravity = prop.getStringValue();
            }
            if (this.vertical) {
                int width_w_pad = w.getPadding(1) + w.getWidth() + w.getPadding(3);
                x = gravity.contains("right") ? this.getWidth() - width_w_pad : ("center_horizontal".equals(gravity) || "center".equals(gravity) ? this.getWidth() / 2 - width_w_pad / 2 : w.getPadding(1) + w.getMargin(1));
            } else {
                y = gravity.contains("bottom") ? this.getHeight() - max_base_bottom - w.getBaseline() : ("center_vertical".equals(gravity) || "center".equals(gravity) ? this.getHeight() / 2 - w.getBaseline() : (w instanceof Layout ? w.getPadding(0) + w.getMargin(0) : max_base - w.getBaseline() + w.getPadding(0)));
            }
            if (this.vertical) {
                y += w.getPadding(0) + w.getMargin(0);
            } else {
                x += w.getPadding(1) + w.getMargin(1);
            }
            w.setPosition(x, y);
            if (with_weight.size() == 0) {
                if (this.vertical) {
                    if (lGrav.equals("bottom")) {
                        w.setPosition(x, y + extra);
                    }
                } else if (lGrav.equals("right")) {
                    w.setPosition(x + extra, y);
                }
            }
            if (this.vertical) {
                y += w.getHeight() + w.getPadding(2) + w.getMargin(2);
                if (!with_weight.contains(w)) continue;
                y += this.share;
                continue;
            }
            x += w.getWidth() + w.getPadding(3) + w.getMargin(3);
            if (!with_weight.contains(w)) continue;
            x += this.share;
        }
    }

    @Override
    public void resizeForRendering() {
        boolean vertical = "vertical".equals(this.orientation.getStringValue());
        for (Widget w : this.widgets) {
            StringProperty prop;
            boolean weight;
            if (w instanceof Layout) {
                ((Layout)w).resizeForRendering();
            }
            boolean bl = weight = (prop = (StringProperty)w.getPropertyByAttName("android:layout_weight")) != null && "1".equals(prop.getStringValue());
            if (!weight) continue;
            if (vertical) {
                w.setSizeInternal(w.getWidth(), w.getHeight() + this.share);
                continue;
            }
            w.setSizeInternal(w.getWidth() + this.share, w.getHeight());
        }
    }

    @Override
    public void addOutputProperties(Widget w, Vector<Property> properties) {
    }

    @Override
    public void addEditableProperties(Widget w) {
        w.addProperty(new StringProperty("Linear Layout Weight", "android:layout_weight", "0"));
        w.addProperty(new SelectProperty("Layout Gravity", "android:layout_gravity", OPTIONS, 0));
    }

    @Override
    public void removeEditableProperties(Widget w) {
        w.removeProperty(new StringProperty("", "android:layout_weight", ""));
        w.removeProperty(new SelectProperty("", "android:layout_gravity", new String[]{""}, 0));
    }
}

