/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import org.droiddraw.AndroidEditor;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.property.BooleanProperty;
import org.droiddraw.property.StringProperty;
import org.droiddraw.widget.AbstractWidget;

public class ProgressBar
extends AbstractWidget {
    public static final String[] propertyNames = new String[]{"android:indeterminate", "android:max"};
    public static final String TAG_NAME = "ProgressBar";
    BooleanProperty indeterminate = new BooleanProperty("Indeterminate", "android:indeterminate", false);
    Image base;
    Image dot;
    Image indet;

    public ProgressBar() {
        super(TAG_NAME);
        this.addProperty(this.indeterminate);
        this.addProperty(new StringProperty("Max. Value", "android:max", "100"));
        this.apply();
        String theme = AndroidEditor.instance().getTheme();
        if (theme == null || theme.equals("default")) {
            this.base = ImageResources.instance().getImage("def/progress_wheel_medium");
        } else {
            this.base = ImageResources.instance().getImage("light/progress_circular_background");
            this.dot = ImageResources.instance().getImage("light/progress_particle");
            this.indet = ImageResources.instance().getImage("light/progress_circular_indeterminate");
        }
    }

    protected int getContentHeight() {
        return 48;
    }

    protected int getContentWidth() {
        return 48;
    }

    public void paint(Graphics g) {
        if (this.base == null) {
            g.setColor(Color.black);
            g.fillOval(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(Color.white);
            g.fillOval(this.getX() + this.getWidth() / 4, this.getY() + this.getHeight() / 4, this.getWidth() / 2, this.getHeight() / 2);
            g.fillOval(this.getX() + this.getWidth() / 3, this.getY(), this.getWidth() / 4 - 3, this.getHeight() / 4 - 3);
        } else {
            g.drawImage(this.base, this.getX(), this.getY(), this.getWidth(), this.getHeight(), null);
            if (this.indet != null) {
                if (this.indeterminate.getBooleanValue()) {
                    g.drawImage(this.indet, this.getX(), this.getY(), this.getWidth(), this.getHeight(), null);
                } else {
                    g.drawImage(this.dot, this.getX(), this.getY(), this.getWidth(), this.getHeight(), null);
                }
            }
        }
    }
}

