/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import org.droiddraw.AndroidEditor;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.widget.CompoundButton;

public class RadioButton
extends CompoundButton {
    public static final String TAG_NAME = "RadioButton";
    Image on;
    Image off;

    public RadioButton(String text) {
        super(text);
        this.setTagName(TAG_NAME);
        this.pad_y = 6;
        this.apply();
    }

    public void apply() {
        String theme = AndroidEditor.instance().getTheme();
        if (theme == null || theme.equals("default")) {
            this.off = ImageResources.instance().getImage("def/btn_radio_off");
            this.on = ImageResources.instance().getImage("def/btn_radio_on");
        } else if (theme.equals("light")) {
            this.off = ImageResources.instance().getImage("light/radiobutton_off_background");
            this.on = ImageResources.instance().getImage("light/radiobutton_on_background");
        }
        this.pad_x = this.off != null ? this.off.getWidth(null) : 24;
        super.apply();
    }

    protected int getContentHeight() {
        if (this.off != null) {
            return this.off.getHeight(null);
        }
        return super.getContentHeight();
    }

    public void paint(Graphics g) {
        int off_y;
        int off_x;
        if (this.off == null || this.on == null) {
            g.setColor(Color.white);
            g.fillOval(this.getX() + 2, this.getY() + 2, 16, 16);
            g.setColor(Color.black);
            g.drawOval(this.getX() + 2, this.getY() + 2, 16, 16);
            if ("true".equals(this.getPropertyByAttName("android:checked").getValue())) {
                g.fillOval(this.getX() + 6, this.getY() + 6, 8, 8);
            }
            off_x = 20;
            off_y = 18;
        } else {
            Image img = this.off;
            if ("true".equals(this.getPropertyByAttName("android:checked").getValue())) {
                img = this.on;
            }
            g.drawImage(img, this.getX(), this.getY(), null);
            g.setColor(Color.black);
            off_x = img.getWidth(null);
            off_y = img.getHeight(null);
        }
        this.baseline = (off_y + this.fontSize) / 2;
        this.setTextColor(g);
        g.setFont(this.f);
        g.drawString(this.text.getStringValue(), this.getX() + off_x, this.getY() + this.baseline - 4);
    }
}

