/*
 * Decompiled with CFR 0.152.
 */
package org.droiddraw.widget;

import java.awt.Graphics;
import java.awt.Image;
import org.droiddraw.gui.ImageResources;
import org.droiddraw.property.BooleanProperty;
import org.droiddraw.property.IntProperty;
import org.droiddraw.widget.ProgressBar;

public class RatingBar
extends ProgressBar {
    Image star;
    IntProperty numStars;
    BooleanProperty indicator;
    public static final String TAG_NAME = "RatingBar";
    public static final String[] propertyNames = new String[]{"android:numStars", "android:isIndicator"};
    private static final long serialVersionUID = 3214432742146876735L;

    public RatingBar() {
        this.setTagName(TAG_NAME);
        this.star = ImageResources.instance().getImage("rate_star_med_on");
        this.numStars = new IntProperty("Number of Stars", "android:numStars", 5);
        this.indicator = new BooleanProperty("User Editable", "android:isIndicator", true);
        this.addProperty(this.numStars);
        this.addProperty(this.indicator);
    }

    public void paint(Graphics g) {
        int width = 42;
        int i = 0;
        while (i < this.numStars.getIntValue()) {
            g.drawImage(this.star, this.getX() + width * i, this.getY(), width, this.getHeight(), null);
            ++i;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Not yet...");
    }

    protected int getContentHeight() {
        return 44;
    }

    protected int getContentWidth() {
        int stars = 5;
        if (this.numStars != null) {
            stars = this.numStars.getIntValue();
        }
        return 42 * stars;
    }
}

